// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrass.serde

import aws.sdk.kotlin.services.greengrass.model.CreateFunctionDefinitionVersionRequest
import aws.sdk.kotlin.services.greengrass.model.Function
import aws.sdk.kotlin.services.greengrass.model.FunctionDefaultConfig
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateFunctionDefinitionVersionOperationSerializer: HttpSerializer.NonStreaming<CreateFunctionDefinitionVersionRequest> {
    override fun serialize(context: ExecutionContext, input: CreateFunctionDefinitionVersionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.functionDefinitionId) { "functionDefinitionId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("greengrass"))
                add(PercentEncoding.Path.encode("definition"))
                add(PercentEncoding.Path.encode("functions"))
                add(PercentEncoding.SmithyLabel.encode(input.functionDefinitionId))
                add(PercentEncoding.Path.encode("versions"))
            }
        }

        builder.headers {
            if (input.amznClientToken != null) append("X-Amzn-Client-Token", input.amznClientToken)
        }

        val payload = serializeCreateFunctionDefinitionVersionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateFunctionDefinitionVersionOperationBody(context: ExecutionContext, input: CreateFunctionDefinitionVersionRequest): ByteArray {
    val serializer = JsonSerializer()
    val DEFAULTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("DefaultConfig"))
    val FUNCTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Functions"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEFAULTCONFIG_DESCRIPTOR)
        field(FUNCTIONS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.defaultConfig?.let { field(DEFAULTCONFIG_DESCRIPTOR, it, ::serializeFunctionDefaultConfigDocument) }
        if (input.functions != null) {
            listField(FUNCTIONS_DESCRIPTOR) {
                for (el0 in input.functions) {
                    serializeSdkSerializable(asSdkSerializable(el0, ::serializeFunctionDocument))
                }
            }
        }
    }
    return serializer.toByteArray()
}
