// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrass.serde

import aws.sdk.kotlin.services.greengrass.model.CreateDeploymentRequest
import aws.sdk.kotlin.services.greengrass.model.DeploymentType
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.headers
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateDeploymentOperationSerializer: HttpSerializer.NonStreaming<CreateDeploymentRequest> {
    override fun serialize(context: ExecutionContext, input: CreateDeploymentRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.groupId) { "groupId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("greengrass"))
                add(PercentEncoding.Path.encode("groups"))
                add(PercentEncoding.SmithyLabel.encode(input.groupId))
                add(PercentEncoding.Path.encode("deployments"))
            }
        }

        builder.headers {
            if (input.amznClientToken != null) append("X-Amzn-Client-Token", input.amznClientToken)
        }

        val payload = serializeCreateDeploymentOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateDeploymentOperationBody(context: ExecutionContext, input: CreateDeploymentRequest): ByteArray {
    val serializer = JsonSerializer()
    val DEPLOYMENTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("DeploymentId"))
    val DEPLOYMENTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("DeploymentType"))
    val GROUPVERSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("GroupVersionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DEPLOYMENTID_DESCRIPTOR)
        field(DEPLOYMENTTYPE_DESCRIPTOR)
        field(GROUPVERSIONID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.deploymentId?.let { field(DEPLOYMENTID_DESCRIPTOR, it) }
        input.deploymentType?.let { field(DEPLOYMENTTYPE_DESCRIPTOR, it.value) }
        input.groupVersionId?.let { field(GROUPVERSIONID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
