// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrass.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Configuration information that specifies how a Lambda function runs.
 */
public class FunctionExecutionConfig private constructor(builder: Builder) {
    /**
     * Specifies whether the Lambda function runs in a Greengrass container (default) or without containerization. Unless your scenario requires that you run without containerization, we recommend that you run in a Greengrass container. Omit this value to run the Lambda function with the default containerization for the group.
     */
    public val isolationMode: aws.sdk.kotlin.services.greengrass.model.FunctionIsolationMode? = builder.isolationMode
    /**
     * Specifies the user and group whose permissions are used when running the Lambda function. You can specify one or both values to override the default values. We recommend that you avoid running as root unless absolutely necessary to minimize the risk of unintended changes or malicious attacks. To run as root, you must set ''IsolationMode'' to ''NoContainer'' and update config.json in ''greengrass-root/config'' to set ''allowFunctionsToRunAsRoot'' to ''yes''.
     */
    public val runAs: aws.sdk.kotlin.services.greengrass.model.FunctionRunAsConfig? = builder.runAs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrass.model.FunctionExecutionConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FunctionExecutionConfig(")
        append("isolationMode=$isolationMode,")
        append("runAs=$runAs")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = isolationMode?.hashCode() ?: 0
        result = 31 * result + (runAs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FunctionExecutionConfig

        if (isolationMode != other.isolationMode) return false
        if (runAs != other.runAs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrass.model.FunctionExecutionConfig = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether the Lambda function runs in a Greengrass container (default) or without containerization. Unless your scenario requires that you run without containerization, we recommend that you run in a Greengrass container. Omit this value to run the Lambda function with the default containerization for the group.
         */
        public var isolationMode: aws.sdk.kotlin.services.greengrass.model.FunctionIsolationMode? = null
        /**
         * Specifies the user and group whose permissions are used when running the Lambda function. You can specify one or both values to override the default values. We recommend that you avoid running as root unless absolutely necessary to minimize the risk of unintended changes or malicious attacks. To run as root, you must set ''IsolationMode'' to ''NoContainer'' and update config.json in ''greengrass-root/config'' to set ''allowFunctionsToRunAsRoot'' to ''yes''.
         */
        public var runAs: aws.sdk.kotlin.services.greengrass.model.FunctionRunAsConfig? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrass.model.FunctionExecutionConfig) : this() {
            this.isolationMode = x.isolationMode
            this.runAs = x.runAs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrass.model.FunctionExecutionConfig = FunctionExecutionConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.greengrass.model.FunctionRunAsConfig] inside the given [block]
         */
        public fun runAs(block: aws.sdk.kotlin.services.greengrass.model.FunctionRunAsConfig.Builder.() -> kotlin.Unit) {
            this.runAs = aws.sdk.kotlin.services.greengrass.model.FunctionRunAsConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
