// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrass.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The environment configuration of the function.
 */
public class FunctionConfigurationEnvironment private constructor(builder: Builder) {
    /**
     * If true, the Lambda function is allowed to access the host's /sys folder. Use this when the Lambda function needs to read device information from /sys. This setting applies only when you run the Lambda function in a Greengrass container.
     */
    public val accessSysfs: kotlin.Boolean? = builder.accessSysfs
    /**
     * Configuration related to executing the Lambda function
     */
    public val execution: aws.sdk.kotlin.services.greengrass.model.FunctionExecutionConfig? = builder.execution
    /**
     * A list of the resources, with their permissions, to which the Lambda function will be granted access. A Lambda function can have at most 10 resources. ResourceAccessPolicies apply only when you run the Lambda function in a Greengrass container.
     */
    public val resourceAccessPolicies: List<ResourceAccessPolicy>? = builder.resourceAccessPolicies
    /**
     * Environment variables for the Lambda function's configuration.
     */
    public val variables: Map<String, String>? = builder.variables

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrass.model.FunctionConfigurationEnvironment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("FunctionConfigurationEnvironment(")
        append("accessSysfs=$accessSysfs,")
        append("execution=$execution,")
        append("resourceAccessPolicies=$resourceAccessPolicies,")
        append("variables=$variables")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accessSysfs?.hashCode() ?: 0
        result = 31 * result + (execution?.hashCode() ?: 0)
        result = 31 * result + (resourceAccessPolicies?.hashCode() ?: 0)
        result = 31 * result + (variables?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as FunctionConfigurationEnvironment

        if (accessSysfs != other.accessSysfs) return false
        if (execution != other.execution) return false
        if (resourceAccessPolicies != other.resourceAccessPolicies) return false
        if (variables != other.variables) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrass.model.FunctionConfigurationEnvironment = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * If true, the Lambda function is allowed to access the host's /sys folder. Use this when the Lambda function needs to read device information from /sys. This setting applies only when you run the Lambda function in a Greengrass container.
         */
        public var accessSysfs: kotlin.Boolean? = null
        /**
         * Configuration related to executing the Lambda function
         */
        public var execution: aws.sdk.kotlin.services.greengrass.model.FunctionExecutionConfig? = null
        /**
         * A list of the resources, with their permissions, to which the Lambda function will be granted access. A Lambda function can have at most 10 resources. ResourceAccessPolicies apply only when you run the Lambda function in a Greengrass container.
         */
        public var resourceAccessPolicies: List<ResourceAccessPolicy>? = null
        /**
         * Environment variables for the Lambda function's configuration.
         */
        public var variables: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrass.model.FunctionConfigurationEnvironment) : this() {
            this.accessSysfs = x.accessSysfs
            this.execution = x.execution
            this.resourceAccessPolicies = x.resourceAccessPolicies
            this.variables = x.variables
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrass.model.FunctionConfigurationEnvironment = FunctionConfigurationEnvironment(this)

        /**
         * construct an [aws.sdk.kotlin.services.greengrass.model.FunctionExecutionConfig] inside the given [block]
         */
        public fun execution(block: aws.sdk.kotlin.services.greengrass.model.FunctionExecutionConfig.Builder.() -> kotlin.Unit) {
            this.execution = aws.sdk.kotlin.services.greengrass.model.FunctionExecutionConfig.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
