// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrass.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about a connector. Connectors run on the Greengrass core and contain built-in integration with local infrastructure, device protocols, AWS, and other cloud services.
 */
public class Connector private constructor(builder: Builder) {
    /**
     * The ARN of the connector.
     */
    public val connectorArn: kotlin.String? = builder.connectorArn
    /**
     * A descriptive or arbitrary ID for the connector. This value must be unique within the connector definition version. Max length is 128 characters with pattern &#91;a-zA-Z0-9:_-&#93;+.
     */
    public val id: kotlin.String? = builder.id
    /**
     * The parameters or configuration that the connector uses.
     */
    public val parameters: Map<String, String>? = builder.parameters

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrass.model.Connector = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Connector(")
        append("connectorArn=$connectorArn,")
        append("id=$id,")
        append("parameters=$parameters")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = connectorArn?.hashCode() ?: 0
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (parameters?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Connector

        if (connectorArn != other.connectorArn) return false
        if (id != other.id) return false
        if (parameters != other.parameters) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrass.model.Connector = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The ARN of the connector.
         */
        public var connectorArn: kotlin.String? = null
        /**
         * A descriptive or arbitrary ID for the connector. This value must be unique within the connector definition version. Max length is 128 characters with pattern &#91;a-zA-Z0-9:_-&#93;+.
         */
        public var id: kotlin.String? = null
        /**
         * The parameters or configuration that the connector uses.
         */
        public var parameters: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrass.model.Connector) : this() {
            this.connectorArn = x.connectorArn
            this.id = x.id
            this.parameters = x.parameters
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrass.model.Connector = Connector(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
