// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrass.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Relevant metrics on input records processed during bulk deployment.
 */
public class BulkDeploymentMetrics private constructor(builder: Builder) {
    /**
     * The total number of records that returned a non-retryable error. For example, this can occur if a group record from the input file uses an invalid format or specifies a nonexistent group version, or if the execution role doesn't grant permission to deploy a group or group version.
     */
    public val invalidInputRecords: kotlin.Int? = builder.invalidInputRecords
    /**
     * The total number of group records from the input file that have been processed so far, or attempted.
     */
    public val recordsProcessed: kotlin.Int? = builder.recordsProcessed
    /**
     * The total number of deployment attempts that returned a retryable error. For example, a retry is triggered if the attempt to deploy a group returns a throttling error. ''StartBulkDeployment'' retries a group deployment up to five times.
     */
    public val retryAttempts: kotlin.Int? = builder.retryAttempts

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.greengrass.model.BulkDeploymentMetrics = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("BulkDeploymentMetrics(")
        append("invalidInputRecords=$invalidInputRecords,")
        append("recordsProcessed=$recordsProcessed,")
        append("retryAttempts=$retryAttempts")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = invalidInputRecords ?: 0
        result = 31 * result + (recordsProcessed ?: 0)
        result = 31 * result + (retryAttempts ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as BulkDeploymentMetrics

        if (invalidInputRecords != other.invalidInputRecords) return false
        if (recordsProcessed != other.recordsProcessed) return false
        if (retryAttempts != other.retryAttempts) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.greengrass.model.BulkDeploymentMetrics = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The total number of records that returned a non-retryable error. For example, this can occur if a group record from the input file uses an invalid format or specifies a nonexistent group version, or if the execution role doesn't grant permission to deploy a group or group version.
         */
        public var invalidInputRecords: kotlin.Int? = null
        /**
         * The total number of group records from the input file that have been processed so far, or attempted.
         */
        public var recordsProcessed: kotlin.Int? = null
        /**
         * The total number of deployment attempts that returned a retryable error. For example, a retry is triggered if the attempt to deploy a group returns a throttling error. ''StartBulkDeployment'' retries a group deployment up to five times.
         */
        public var retryAttempts: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.greengrass.model.BulkDeploymentMetrics) : this() {
            this.invalidInputRecords = x.invalidInputRecords
            this.recordsProcessed = x.recordsProcessed
            this.retryAttempts = x.retryAttempts
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.greengrass.model.BulkDeploymentMetrics = BulkDeploymentMetrics(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
