// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.greengrass

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.greengrass.auth.DefaultGreengrassAuthSchemeProvider
import aws.sdk.kotlin.services.greengrass.auth.GreengrassAuthSchemeProvider
import aws.sdk.kotlin.services.greengrass.endpoints.DefaultGreengrassEndpointProvider
import aws.sdk.kotlin.services.greengrass.endpoints.GreengrassEndpointParameters
import aws.sdk.kotlin.services.greengrass.endpoints.GreengrassEndpointProvider
import aws.sdk.kotlin.services.greengrass.model.AssociateRoleToGroupRequest
import aws.sdk.kotlin.services.greengrass.model.AssociateRoleToGroupResponse
import aws.sdk.kotlin.services.greengrass.model.AssociateServiceRoleToAccountRequest
import aws.sdk.kotlin.services.greengrass.model.AssociateServiceRoleToAccountResponse
import aws.sdk.kotlin.services.greengrass.model.CreateConnectorDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.CreateConnectorDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.CreateConnectorDefinitionVersionRequest
import aws.sdk.kotlin.services.greengrass.model.CreateConnectorDefinitionVersionResponse
import aws.sdk.kotlin.services.greengrass.model.CreateCoreDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.CreateCoreDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.CreateCoreDefinitionVersionRequest
import aws.sdk.kotlin.services.greengrass.model.CreateCoreDefinitionVersionResponse
import aws.sdk.kotlin.services.greengrass.model.CreateDeploymentRequest
import aws.sdk.kotlin.services.greengrass.model.CreateDeploymentResponse
import aws.sdk.kotlin.services.greengrass.model.CreateDeviceDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.CreateDeviceDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.CreateDeviceDefinitionVersionRequest
import aws.sdk.kotlin.services.greengrass.model.CreateDeviceDefinitionVersionResponse
import aws.sdk.kotlin.services.greengrass.model.CreateFunctionDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.CreateFunctionDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.CreateFunctionDefinitionVersionRequest
import aws.sdk.kotlin.services.greengrass.model.CreateFunctionDefinitionVersionResponse
import aws.sdk.kotlin.services.greengrass.model.CreateGroupCertificateAuthorityRequest
import aws.sdk.kotlin.services.greengrass.model.CreateGroupCertificateAuthorityResponse
import aws.sdk.kotlin.services.greengrass.model.CreateGroupRequest
import aws.sdk.kotlin.services.greengrass.model.CreateGroupResponse
import aws.sdk.kotlin.services.greengrass.model.CreateGroupVersionRequest
import aws.sdk.kotlin.services.greengrass.model.CreateGroupVersionResponse
import aws.sdk.kotlin.services.greengrass.model.CreateLoggerDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.CreateLoggerDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.CreateLoggerDefinitionVersionRequest
import aws.sdk.kotlin.services.greengrass.model.CreateLoggerDefinitionVersionResponse
import aws.sdk.kotlin.services.greengrass.model.CreateResourceDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.CreateResourceDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.CreateResourceDefinitionVersionRequest
import aws.sdk.kotlin.services.greengrass.model.CreateResourceDefinitionVersionResponse
import aws.sdk.kotlin.services.greengrass.model.CreateSoftwareUpdateJobRequest
import aws.sdk.kotlin.services.greengrass.model.CreateSoftwareUpdateJobResponse
import aws.sdk.kotlin.services.greengrass.model.CreateSubscriptionDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.CreateSubscriptionDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.CreateSubscriptionDefinitionVersionRequest
import aws.sdk.kotlin.services.greengrass.model.CreateSubscriptionDefinitionVersionResponse
import aws.sdk.kotlin.services.greengrass.model.DeleteConnectorDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.DeleteConnectorDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.DeleteCoreDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.DeleteCoreDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.DeleteDeviceDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.DeleteDeviceDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.DeleteFunctionDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.DeleteFunctionDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.DeleteGroupRequest
import aws.sdk.kotlin.services.greengrass.model.DeleteGroupResponse
import aws.sdk.kotlin.services.greengrass.model.DeleteLoggerDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.DeleteLoggerDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.DeleteResourceDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.DeleteResourceDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.DeleteSubscriptionDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.DeleteSubscriptionDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.DisassociateRoleFromGroupRequest
import aws.sdk.kotlin.services.greengrass.model.DisassociateRoleFromGroupResponse
import aws.sdk.kotlin.services.greengrass.model.DisassociateServiceRoleFromAccountRequest
import aws.sdk.kotlin.services.greengrass.model.DisassociateServiceRoleFromAccountResponse
import aws.sdk.kotlin.services.greengrass.model.GetAssociatedRoleRequest
import aws.sdk.kotlin.services.greengrass.model.GetAssociatedRoleResponse
import aws.sdk.kotlin.services.greengrass.model.GetBulkDeploymentStatusRequest
import aws.sdk.kotlin.services.greengrass.model.GetBulkDeploymentStatusResponse
import aws.sdk.kotlin.services.greengrass.model.GetConnectivityInfoRequest
import aws.sdk.kotlin.services.greengrass.model.GetConnectivityInfoResponse
import aws.sdk.kotlin.services.greengrass.model.GetConnectorDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.GetConnectorDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.GetConnectorDefinitionVersionRequest
import aws.sdk.kotlin.services.greengrass.model.GetConnectorDefinitionVersionResponse
import aws.sdk.kotlin.services.greengrass.model.GetCoreDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.GetCoreDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.GetCoreDefinitionVersionRequest
import aws.sdk.kotlin.services.greengrass.model.GetCoreDefinitionVersionResponse
import aws.sdk.kotlin.services.greengrass.model.GetDeploymentStatusRequest
import aws.sdk.kotlin.services.greengrass.model.GetDeploymentStatusResponse
import aws.sdk.kotlin.services.greengrass.model.GetDeviceDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.GetDeviceDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.GetDeviceDefinitionVersionRequest
import aws.sdk.kotlin.services.greengrass.model.GetDeviceDefinitionVersionResponse
import aws.sdk.kotlin.services.greengrass.model.GetFunctionDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.GetFunctionDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.GetFunctionDefinitionVersionRequest
import aws.sdk.kotlin.services.greengrass.model.GetFunctionDefinitionVersionResponse
import aws.sdk.kotlin.services.greengrass.model.GetGroupCertificateAuthorityRequest
import aws.sdk.kotlin.services.greengrass.model.GetGroupCertificateAuthorityResponse
import aws.sdk.kotlin.services.greengrass.model.GetGroupCertificateConfigurationRequest
import aws.sdk.kotlin.services.greengrass.model.GetGroupCertificateConfigurationResponse
import aws.sdk.kotlin.services.greengrass.model.GetGroupRequest
import aws.sdk.kotlin.services.greengrass.model.GetGroupResponse
import aws.sdk.kotlin.services.greengrass.model.GetGroupVersionRequest
import aws.sdk.kotlin.services.greengrass.model.GetGroupVersionResponse
import aws.sdk.kotlin.services.greengrass.model.GetLoggerDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.GetLoggerDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.GetLoggerDefinitionVersionRequest
import aws.sdk.kotlin.services.greengrass.model.GetLoggerDefinitionVersionResponse
import aws.sdk.kotlin.services.greengrass.model.GetResourceDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.GetResourceDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.GetResourceDefinitionVersionRequest
import aws.sdk.kotlin.services.greengrass.model.GetResourceDefinitionVersionResponse
import aws.sdk.kotlin.services.greengrass.model.GetServiceRoleForAccountRequest
import aws.sdk.kotlin.services.greengrass.model.GetServiceRoleForAccountResponse
import aws.sdk.kotlin.services.greengrass.model.GetSubscriptionDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.GetSubscriptionDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.GetSubscriptionDefinitionVersionRequest
import aws.sdk.kotlin.services.greengrass.model.GetSubscriptionDefinitionVersionResponse
import aws.sdk.kotlin.services.greengrass.model.GetThingRuntimeConfigurationRequest
import aws.sdk.kotlin.services.greengrass.model.GetThingRuntimeConfigurationResponse
import aws.sdk.kotlin.services.greengrass.model.ListBulkDeploymentDetailedReportsRequest
import aws.sdk.kotlin.services.greengrass.model.ListBulkDeploymentDetailedReportsResponse
import aws.sdk.kotlin.services.greengrass.model.ListBulkDeploymentsRequest
import aws.sdk.kotlin.services.greengrass.model.ListBulkDeploymentsResponse
import aws.sdk.kotlin.services.greengrass.model.ListConnectorDefinitionVersionsRequest
import aws.sdk.kotlin.services.greengrass.model.ListConnectorDefinitionVersionsResponse
import aws.sdk.kotlin.services.greengrass.model.ListConnectorDefinitionsRequest
import aws.sdk.kotlin.services.greengrass.model.ListConnectorDefinitionsResponse
import aws.sdk.kotlin.services.greengrass.model.ListCoreDefinitionVersionsRequest
import aws.sdk.kotlin.services.greengrass.model.ListCoreDefinitionVersionsResponse
import aws.sdk.kotlin.services.greengrass.model.ListCoreDefinitionsRequest
import aws.sdk.kotlin.services.greengrass.model.ListCoreDefinitionsResponse
import aws.sdk.kotlin.services.greengrass.model.ListDeploymentsRequest
import aws.sdk.kotlin.services.greengrass.model.ListDeploymentsResponse
import aws.sdk.kotlin.services.greengrass.model.ListDeviceDefinitionVersionsRequest
import aws.sdk.kotlin.services.greengrass.model.ListDeviceDefinitionVersionsResponse
import aws.sdk.kotlin.services.greengrass.model.ListDeviceDefinitionsRequest
import aws.sdk.kotlin.services.greengrass.model.ListDeviceDefinitionsResponse
import aws.sdk.kotlin.services.greengrass.model.ListFunctionDefinitionVersionsRequest
import aws.sdk.kotlin.services.greengrass.model.ListFunctionDefinitionVersionsResponse
import aws.sdk.kotlin.services.greengrass.model.ListFunctionDefinitionsRequest
import aws.sdk.kotlin.services.greengrass.model.ListFunctionDefinitionsResponse
import aws.sdk.kotlin.services.greengrass.model.ListGroupCertificateAuthoritiesRequest
import aws.sdk.kotlin.services.greengrass.model.ListGroupCertificateAuthoritiesResponse
import aws.sdk.kotlin.services.greengrass.model.ListGroupVersionsRequest
import aws.sdk.kotlin.services.greengrass.model.ListGroupVersionsResponse
import aws.sdk.kotlin.services.greengrass.model.ListGroupsRequest
import aws.sdk.kotlin.services.greengrass.model.ListGroupsResponse
import aws.sdk.kotlin.services.greengrass.model.ListLoggerDefinitionVersionsRequest
import aws.sdk.kotlin.services.greengrass.model.ListLoggerDefinitionVersionsResponse
import aws.sdk.kotlin.services.greengrass.model.ListLoggerDefinitionsRequest
import aws.sdk.kotlin.services.greengrass.model.ListLoggerDefinitionsResponse
import aws.sdk.kotlin.services.greengrass.model.ListResourceDefinitionVersionsRequest
import aws.sdk.kotlin.services.greengrass.model.ListResourceDefinitionVersionsResponse
import aws.sdk.kotlin.services.greengrass.model.ListResourceDefinitionsRequest
import aws.sdk.kotlin.services.greengrass.model.ListResourceDefinitionsResponse
import aws.sdk.kotlin.services.greengrass.model.ListSubscriptionDefinitionVersionsRequest
import aws.sdk.kotlin.services.greengrass.model.ListSubscriptionDefinitionVersionsResponse
import aws.sdk.kotlin.services.greengrass.model.ListSubscriptionDefinitionsRequest
import aws.sdk.kotlin.services.greengrass.model.ListSubscriptionDefinitionsResponse
import aws.sdk.kotlin.services.greengrass.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.greengrass.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.greengrass.model.ResetDeploymentsRequest
import aws.sdk.kotlin.services.greengrass.model.ResetDeploymentsResponse
import aws.sdk.kotlin.services.greengrass.model.StartBulkDeploymentRequest
import aws.sdk.kotlin.services.greengrass.model.StartBulkDeploymentResponse
import aws.sdk.kotlin.services.greengrass.model.StopBulkDeploymentRequest
import aws.sdk.kotlin.services.greengrass.model.StopBulkDeploymentResponse
import aws.sdk.kotlin.services.greengrass.model.TagResourceRequest
import aws.sdk.kotlin.services.greengrass.model.TagResourceResponse
import aws.sdk.kotlin.services.greengrass.model.UntagResourceRequest
import aws.sdk.kotlin.services.greengrass.model.UntagResourceResponse
import aws.sdk.kotlin.services.greengrass.model.UpdateConnectivityInfoRequest
import aws.sdk.kotlin.services.greengrass.model.UpdateConnectivityInfoResponse
import aws.sdk.kotlin.services.greengrass.model.UpdateConnectorDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.UpdateConnectorDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.UpdateCoreDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.UpdateCoreDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.UpdateDeviceDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.UpdateDeviceDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.UpdateFunctionDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.UpdateFunctionDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.UpdateGroupCertificateConfigurationRequest
import aws.sdk.kotlin.services.greengrass.model.UpdateGroupCertificateConfigurationResponse
import aws.sdk.kotlin.services.greengrass.model.UpdateGroupRequest
import aws.sdk.kotlin.services.greengrass.model.UpdateGroupResponse
import aws.sdk.kotlin.services.greengrass.model.UpdateLoggerDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.UpdateLoggerDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.UpdateResourceDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.UpdateResourceDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.UpdateSubscriptionDefinitionRequest
import aws.sdk.kotlin.services.greengrass.model.UpdateSubscriptionDefinitionResponse
import aws.sdk.kotlin.services.greengrass.model.UpdateThingRuntimeConfigurationRequest
import aws.sdk.kotlin.services.greengrass.model.UpdateThingRuntimeConfigurationResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "Greengrass"
public const val SdkVersion: String = "1.5.14"
public const val ServiceApiVersion: String = "2017-06-07"

/**
 * AWS IoT Greengrass seamlessly extends AWS onto physical devices so they can act locally on the data they generate, while still using the cloud for management, analytics, and durable storage. AWS IoT Greengrass ensures your devices can respond quickly to local events and operate with intermittent connectivity. AWS IoT Greengrass minimizes the cost of transmitting data to the cloud by allowing you to author AWS Lambda functions that execute locally.
 */
public interface GreengrassClient : SdkClient {
    /**
     * GreengrassClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, GreengrassClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Greengrass",
                "GREENGRASS",
                "greengrass",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, GreengrassClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): GreengrassClient = DefaultGreengrassClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: GreengrassEndpointProvider = builder.endpointProvider ?: DefaultGreengrassEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: GreengrassAuthSchemeProvider = builder.authSchemeProvider ?: DefaultGreengrassAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Greengrass"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: GreengrassEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: GreengrassAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associates a role with a group. Your Greengrass core will use the role to access AWS cloud services. The role's permissions should allow Greengrass core Lambda functions to perform actions against the cloud.
     */
    public suspend fun associateRoleToGroup(input: AssociateRoleToGroupRequest): AssociateRoleToGroupResponse

    /**
     * Associates a role with your account. AWS IoT Greengrass will use the role to access your Lambda functions and AWS IoT resources. This is necessary for deployments to succeed. The role must have at least minimum permissions in the policy ''AWSGreengrassResourceAccessRolePolicy''.
     */
    public suspend fun associateServiceRoleToAccount(input: AssociateServiceRoleToAccountRequest): AssociateServiceRoleToAccountResponse

    /**
     * Creates a connector definition. You may provide the initial version of the connector definition now or use ''CreateConnectorDefinitionVersion'' at a later time.
     */
    public suspend fun createConnectorDefinition(input: CreateConnectorDefinitionRequest = CreateConnectorDefinitionRequest { }): CreateConnectorDefinitionResponse

    /**
     * Creates a version of a connector definition which has already been defined.
     */
    public suspend fun createConnectorDefinitionVersion(input: CreateConnectorDefinitionVersionRequest): CreateConnectorDefinitionVersionResponse

    /**
     * Creates a core definition. You may provide the initial version of the core definition now or use ''CreateCoreDefinitionVersion'' at a later time. Greengrass groups must each contain exactly one Greengrass core.
     */
    public suspend fun createCoreDefinition(input: CreateCoreDefinitionRequest = CreateCoreDefinitionRequest { }): CreateCoreDefinitionResponse

    /**
     * Creates a version of a core definition that has already been defined. Greengrass groups must each contain exactly one Greengrass core.
     */
    public suspend fun createCoreDefinitionVersion(input: CreateCoreDefinitionVersionRequest): CreateCoreDefinitionVersionResponse

    /**
     * Creates a deployment. ''CreateDeployment'' requests are idempotent with respect to the ''X-Amzn-Client-Token'' token and the request parameters.
     */
    public suspend fun createDeployment(input: CreateDeploymentRequest): CreateDeploymentResponse

    /**
     * Creates a device definition. You may provide the initial version of the device definition now or use ''CreateDeviceDefinitionVersion'' at a later time.
     */
    public suspend fun createDeviceDefinition(input: CreateDeviceDefinitionRequest = CreateDeviceDefinitionRequest { }): CreateDeviceDefinitionResponse

    /**
     * Creates a version of a device definition that has already been defined.
     */
    public suspend fun createDeviceDefinitionVersion(input: CreateDeviceDefinitionVersionRequest): CreateDeviceDefinitionVersionResponse

    /**
     * Creates a Lambda function definition which contains a list of Lambda functions and their configurations to be used in a group. You can create an initial version of the definition by providing a list of Lambda functions and their configurations now, or use ''CreateFunctionDefinitionVersion'' later.
     */
    public suspend fun createFunctionDefinition(input: CreateFunctionDefinitionRequest = CreateFunctionDefinitionRequest { }): CreateFunctionDefinitionResponse

    /**
     * Creates a version of a Lambda function definition that has already been defined.
     */
    public suspend fun createFunctionDefinitionVersion(input: CreateFunctionDefinitionVersionRequest): CreateFunctionDefinitionVersionResponse

    /**
     * Creates a group. You may provide the initial version of the group or use ''CreateGroupVersion'' at a later time. Tip: You can use the ''gg_group_setup'' package (https://github.com/awslabs/aws-greengrass-group-setup) as a library or command-line application to create and deploy Greengrass groups.
     */
    public suspend fun createGroup(input: CreateGroupRequest): CreateGroupResponse

    /**
     * Creates a CA for the group. If a CA already exists, it will rotate the existing CA.
     */
    public suspend fun createGroupCertificateAuthority(input: CreateGroupCertificateAuthorityRequest): CreateGroupCertificateAuthorityResponse

    /**
     * Creates a version of a group which has already been defined.
     */
    public suspend fun createGroupVersion(input: CreateGroupVersionRequest): CreateGroupVersionResponse

    /**
     * Creates a logger definition. You may provide the initial version of the logger definition now or use ''CreateLoggerDefinitionVersion'' at a later time.
     */
    public suspend fun createLoggerDefinition(input: CreateLoggerDefinitionRequest = CreateLoggerDefinitionRequest { }): CreateLoggerDefinitionResponse

    /**
     * Creates a version of a logger definition that has already been defined.
     */
    public suspend fun createLoggerDefinitionVersion(input: CreateLoggerDefinitionVersionRequest): CreateLoggerDefinitionVersionResponse

    /**
     * Creates a resource definition which contains a list of resources to be used in a group. You can create an initial version of the definition by providing a list of resources now, or use ''CreateResourceDefinitionVersion'' later.
     */
    public suspend fun createResourceDefinition(input: CreateResourceDefinitionRequest = CreateResourceDefinitionRequest { }): CreateResourceDefinitionResponse

    /**
     * Creates a version of a resource definition that has already been defined.
     */
    public suspend fun createResourceDefinitionVersion(input: CreateResourceDefinitionVersionRequest): CreateResourceDefinitionVersionResponse

    /**
     * Creates a software update for a core or group of cores (specified as an IoT thing group.) Use this to update the OTA Agent as well as the Greengrass core software. It makes use of the IoT Jobs feature which provides additional commands to manage a Greengrass core software update job.
     */
    public suspend fun createSoftwareUpdateJob(input: CreateSoftwareUpdateJobRequest): CreateSoftwareUpdateJobResponse

    /**
     * Creates a subscription definition. You may provide the initial version of the subscription definition now or use ''CreateSubscriptionDefinitionVersion'' at a later time.
     */
    public suspend fun createSubscriptionDefinition(input: CreateSubscriptionDefinitionRequest = CreateSubscriptionDefinitionRequest { }): CreateSubscriptionDefinitionResponse

    /**
     * Creates a version of a subscription definition which has already been defined.
     */
    public suspend fun createSubscriptionDefinitionVersion(input: CreateSubscriptionDefinitionVersionRequest): CreateSubscriptionDefinitionVersionResponse

    /**
     * Deletes a connector definition.
     */
    public suspend fun deleteConnectorDefinition(input: DeleteConnectorDefinitionRequest): DeleteConnectorDefinitionResponse

    /**
     * Deletes a core definition.
     */
    public suspend fun deleteCoreDefinition(input: DeleteCoreDefinitionRequest): DeleteCoreDefinitionResponse

    /**
     * Deletes a device definition.
     */
    public suspend fun deleteDeviceDefinition(input: DeleteDeviceDefinitionRequest): DeleteDeviceDefinitionResponse

    /**
     * Deletes a Lambda function definition.
     */
    public suspend fun deleteFunctionDefinition(input: DeleteFunctionDefinitionRequest): DeleteFunctionDefinitionResponse

    /**
     * Deletes a group.
     */
    public suspend fun deleteGroup(input: DeleteGroupRequest): DeleteGroupResponse

    /**
     * Deletes a logger definition.
     */
    public suspend fun deleteLoggerDefinition(input: DeleteLoggerDefinitionRequest): DeleteLoggerDefinitionResponse

    /**
     * Deletes a resource definition.
     */
    public suspend fun deleteResourceDefinition(input: DeleteResourceDefinitionRequest): DeleteResourceDefinitionResponse

    /**
     * Deletes a subscription definition.
     */
    public suspend fun deleteSubscriptionDefinition(input: DeleteSubscriptionDefinitionRequest): DeleteSubscriptionDefinitionResponse

    /**
     * Disassociates the role from a group.
     */
    public suspend fun disassociateRoleFromGroup(input: DisassociateRoleFromGroupRequest): DisassociateRoleFromGroupResponse

    /**
     * Disassociates the service role from your account. Without a service role, deployments will not work.
     */
    public suspend fun disassociateServiceRoleFromAccount(input: DisassociateServiceRoleFromAccountRequest = DisassociateServiceRoleFromAccountRequest { }): DisassociateServiceRoleFromAccountResponse

    /**
     * Retrieves the role associated with a particular group.
     */
    public suspend fun getAssociatedRole(input: GetAssociatedRoleRequest): GetAssociatedRoleResponse

    /**
     * Returns the status of a bulk deployment.
     */
    public suspend fun getBulkDeploymentStatus(input: GetBulkDeploymentStatusRequest): GetBulkDeploymentStatusResponse

    /**
     * Retrieves the connectivity information for a core.
     */
    public suspend fun getConnectivityInfo(input: GetConnectivityInfoRequest): GetConnectivityInfoResponse

    /**
     * Retrieves information about a connector definition.
     */
    public suspend fun getConnectorDefinition(input: GetConnectorDefinitionRequest): GetConnectorDefinitionResponse

    /**
     * Retrieves information about a connector definition version, including the connectors that the version contains. Connectors are prebuilt modules that interact with local infrastructure, device protocols, AWS, and other cloud services.
     */
    public suspend fun getConnectorDefinitionVersion(input: GetConnectorDefinitionVersionRequest): GetConnectorDefinitionVersionResponse

    /**
     * Retrieves information about a core definition version.
     */
    public suspend fun getCoreDefinition(input: GetCoreDefinitionRequest): GetCoreDefinitionResponse

    /**
     * Retrieves information about a core definition version.
     */
    public suspend fun getCoreDefinitionVersion(input: GetCoreDefinitionVersionRequest): GetCoreDefinitionVersionResponse

    /**
     * Returns the status of a deployment.
     */
    public suspend fun getDeploymentStatus(input: GetDeploymentStatusRequest): GetDeploymentStatusResponse

    /**
     * Retrieves information about a device definition.
     */
    public suspend fun getDeviceDefinition(input: GetDeviceDefinitionRequest): GetDeviceDefinitionResponse

    /**
     * Retrieves information about a device definition version.
     */
    public suspend fun getDeviceDefinitionVersion(input: GetDeviceDefinitionVersionRequest): GetDeviceDefinitionVersionResponse

    /**
     * Retrieves information about a Lambda function definition, including its creation time and latest version.
     */
    public suspend fun getFunctionDefinition(input: GetFunctionDefinitionRequest): GetFunctionDefinitionResponse

    /**
     * Retrieves information about a Lambda function definition version, including which Lambda functions are included in the version and their configurations.
     */
    public suspend fun getFunctionDefinitionVersion(input: GetFunctionDefinitionVersionRequest): GetFunctionDefinitionVersionResponse

    /**
     * Retrieves information about a group.
     */
    public suspend fun getGroup(input: GetGroupRequest): GetGroupResponse

    /**
     * Retreives the CA associated with a group. Returns the public key of the CA.
     */
    public suspend fun getGroupCertificateAuthority(input: GetGroupCertificateAuthorityRequest): GetGroupCertificateAuthorityResponse

    /**
     * Retrieves the current configuration for the CA used by the group.
     */
    public suspend fun getGroupCertificateConfiguration(input: GetGroupCertificateConfigurationRequest): GetGroupCertificateConfigurationResponse

    /**
     * Retrieves information about a group version.
     */
    public suspend fun getGroupVersion(input: GetGroupVersionRequest): GetGroupVersionResponse

    /**
     * Retrieves information about a logger definition.
     */
    public suspend fun getLoggerDefinition(input: GetLoggerDefinitionRequest): GetLoggerDefinitionResponse

    /**
     * Retrieves information about a logger definition version.
     */
    public suspend fun getLoggerDefinitionVersion(input: GetLoggerDefinitionVersionRequest): GetLoggerDefinitionVersionResponse

    /**
     * Retrieves information about a resource definition, including its creation time and latest version.
     */
    public suspend fun getResourceDefinition(input: GetResourceDefinitionRequest): GetResourceDefinitionResponse

    /**
     * Retrieves information about a resource definition version, including which resources are included in the version.
     */
    public suspend fun getResourceDefinitionVersion(input: GetResourceDefinitionVersionRequest): GetResourceDefinitionVersionResponse

    /**
     * Retrieves the service role that is attached to your account.
     */
    public suspend fun getServiceRoleForAccount(input: GetServiceRoleForAccountRequest = GetServiceRoleForAccountRequest { }): GetServiceRoleForAccountResponse

    /**
     * Retrieves information about a subscription definition.
     */
    public suspend fun getSubscriptionDefinition(input: GetSubscriptionDefinitionRequest): GetSubscriptionDefinitionResponse

    /**
     * Retrieves information about a subscription definition version.
     */
    public suspend fun getSubscriptionDefinitionVersion(input: GetSubscriptionDefinitionVersionRequest): GetSubscriptionDefinitionVersionResponse

    /**
     * Get the runtime configuration of a thing.
     */
    public suspend fun getThingRuntimeConfiguration(input: GetThingRuntimeConfigurationRequest): GetThingRuntimeConfigurationResponse

    /**
     * Gets a paginated list of the deployments that have been started in a bulk deployment operation, and their current deployment status.
     */
    public suspend fun listBulkDeploymentDetailedReports(input: ListBulkDeploymentDetailedReportsRequest): ListBulkDeploymentDetailedReportsResponse

    /**
     * Returns a list of bulk deployments.
     */
    public suspend fun listBulkDeployments(input: ListBulkDeploymentsRequest = ListBulkDeploymentsRequest { }): ListBulkDeploymentsResponse

    /**
     * Lists the versions of a connector definition, which are containers for connectors. Connectors run on the Greengrass core and contain built-in integration with local infrastructure, device protocols, AWS, and other cloud services.
     */
    public suspend fun listConnectorDefinitionVersions(input: ListConnectorDefinitionVersionsRequest): ListConnectorDefinitionVersionsResponse

    /**
     * Retrieves a list of connector definitions.
     */
    public suspend fun listConnectorDefinitions(input: ListConnectorDefinitionsRequest = ListConnectorDefinitionsRequest { }): ListConnectorDefinitionsResponse

    /**
     * Lists the versions of a core definition.
     */
    public suspend fun listCoreDefinitionVersions(input: ListCoreDefinitionVersionsRequest): ListCoreDefinitionVersionsResponse

    /**
     * Retrieves a list of core definitions.
     */
    public suspend fun listCoreDefinitions(input: ListCoreDefinitionsRequest = ListCoreDefinitionsRequest { }): ListCoreDefinitionsResponse

    /**
     * Returns a history of deployments for the group.
     */
    public suspend fun listDeployments(input: ListDeploymentsRequest): ListDeploymentsResponse

    /**
     * Lists the versions of a device definition.
     */
    public suspend fun listDeviceDefinitionVersions(input: ListDeviceDefinitionVersionsRequest): ListDeviceDefinitionVersionsResponse

    /**
     * Retrieves a list of device definitions.
     */
    public suspend fun listDeviceDefinitions(input: ListDeviceDefinitionsRequest = ListDeviceDefinitionsRequest { }): ListDeviceDefinitionsResponse

    /**
     * Lists the versions of a Lambda function definition.
     */
    public suspend fun listFunctionDefinitionVersions(input: ListFunctionDefinitionVersionsRequest): ListFunctionDefinitionVersionsResponse

    /**
     * Retrieves a list of Lambda function definitions.
     */
    public suspend fun listFunctionDefinitions(input: ListFunctionDefinitionsRequest = ListFunctionDefinitionsRequest { }): ListFunctionDefinitionsResponse

    /**
     * Retrieves the current CAs for a group.
     */
    public suspend fun listGroupCertificateAuthorities(input: ListGroupCertificateAuthoritiesRequest): ListGroupCertificateAuthoritiesResponse

    /**
     * Lists the versions of a group.
     */
    public suspend fun listGroupVersions(input: ListGroupVersionsRequest): ListGroupVersionsResponse

    /**
     * Retrieves a list of groups.
     */
    public suspend fun listGroups(input: ListGroupsRequest = ListGroupsRequest { }): ListGroupsResponse

    /**
     * Lists the versions of a logger definition.
     */
    public suspend fun listLoggerDefinitionVersions(input: ListLoggerDefinitionVersionsRequest): ListLoggerDefinitionVersionsResponse

    /**
     * Retrieves a list of logger definitions.
     */
    public suspend fun listLoggerDefinitions(input: ListLoggerDefinitionsRequest = ListLoggerDefinitionsRequest { }): ListLoggerDefinitionsResponse

    /**
     * Lists the versions of a resource definition.
     */
    public suspend fun listResourceDefinitionVersions(input: ListResourceDefinitionVersionsRequest): ListResourceDefinitionVersionsResponse

    /**
     * Retrieves a list of resource definitions.
     */
    public suspend fun listResourceDefinitions(input: ListResourceDefinitionsRequest = ListResourceDefinitionsRequest { }): ListResourceDefinitionsResponse

    /**
     * Lists the versions of a subscription definition.
     */
    public suspend fun listSubscriptionDefinitionVersions(input: ListSubscriptionDefinitionVersionsRequest): ListSubscriptionDefinitionVersionsResponse

    /**
     * Retrieves a list of subscription definitions.
     */
    public suspend fun listSubscriptionDefinitions(input: ListSubscriptionDefinitionsRequest = ListSubscriptionDefinitionsRequest { }): ListSubscriptionDefinitionsResponse

    /**
     * Retrieves a list of resource tags for a resource arn.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Resets a group's deployments.
     */
    public suspend fun resetDeployments(input: ResetDeploymentsRequest): ResetDeploymentsResponse

    /**
     * Deploys multiple groups in one operation. This action starts the bulk deployment of a specified set of group versions. Each group version deployment will be triggered with an adaptive rate that has a fixed upper limit. We recommend that you include an ''X-Amzn-Client-Token'' token in every ''StartBulkDeployment'' request. These requests are idempotent with respect to the token and the request parameters.
     */
    public suspend fun startBulkDeployment(input: StartBulkDeploymentRequest): StartBulkDeploymentResponse

    /**
     * Stops the execution of a bulk deployment. This action returns a status of ''Stopping'' until the deployment is stopped. You cannot start a new bulk deployment while a previous deployment is in the ''Stopping'' state. This action doesn't rollback completed deployments or cancel pending deployments.
     */
    public suspend fun stopBulkDeployment(input: StopBulkDeploymentRequest): StopBulkDeploymentResponse

    /**
     * Adds tags to a Greengrass resource. Valid resources are 'Group', 'ConnectorDefinition', 'CoreDefinition', 'DeviceDefinition', 'FunctionDefinition', 'LoggerDefinition', 'SubscriptionDefinition', 'ResourceDefinition', and 'BulkDeployment'.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Remove resource tags from a Greengrass Resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates the connectivity information for the core. Any devices that belong to the group which has this core will receive this information in order to find the location of the core and connect to it.
     */
    public suspend fun updateConnectivityInfo(input: UpdateConnectivityInfoRequest): UpdateConnectivityInfoResponse

    /**
     * Updates a connector definition.
     */
    public suspend fun updateConnectorDefinition(input: UpdateConnectorDefinitionRequest): UpdateConnectorDefinitionResponse

    /**
     * Updates a core definition.
     */
    public suspend fun updateCoreDefinition(input: UpdateCoreDefinitionRequest): UpdateCoreDefinitionResponse

    /**
     * Updates a device definition.
     */
    public suspend fun updateDeviceDefinition(input: UpdateDeviceDefinitionRequest): UpdateDeviceDefinitionResponse

    /**
     * Updates a Lambda function definition.
     */
    public suspend fun updateFunctionDefinition(input: UpdateFunctionDefinitionRequest): UpdateFunctionDefinitionResponse

    /**
     * Updates a group.
     */
    public suspend fun updateGroup(input: UpdateGroupRequest): UpdateGroupResponse

    /**
     * Updates the Certificate expiry time for a group.
     */
    public suspend fun updateGroupCertificateConfiguration(input: UpdateGroupCertificateConfigurationRequest): UpdateGroupCertificateConfigurationResponse

    /**
     * Updates a logger definition.
     */
    public suspend fun updateLoggerDefinition(input: UpdateLoggerDefinitionRequest): UpdateLoggerDefinitionResponse

    /**
     * Updates a resource definition.
     */
    public suspend fun updateResourceDefinition(input: UpdateResourceDefinitionRequest): UpdateResourceDefinitionResponse

    /**
     * Updates a subscription definition.
     */
    public suspend fun updateSubscriptionDefinition(input: UpdateSubscriptionDefinitionRequest): UpdateSubscriptionDefinitionResponse

    /**
     * Updates the runtime configuration of a thing.
     */
    public suspend fun updateThingRuntimeConfiguration(input: UpdateThingRuntimeConfigurationRequest): UpdateThingRuntimeConfigurationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun GreengrassClient.withConfig(block: GreengrassClient.Config.Builder.() -> Unit): GreengrassClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultGreengrassClient(newConfig)
}

/**
 * Associates a role with a group. Your Greengrass core will use the role to access AWS cloud services. The role's permissions should allow Greengrass core Lambda functions to perform actions against the cloud.
 */
public suspend inline fun GreengrassClient.associateRoleToGroup(crossinline block: AssociateRoleToGroupRequest.Builder.() -> Unit): AssociateRoleToGroupResponse = associateRoleToGroup(AssociateRoleToGroupRequest.Builder().apply(block).build())

/**
 * Associates a role with your account. AWS IoT Greengrass will use the role to access your Lambda functions and AWS IoT resources. This is necessary for deployments to succeed. The role must have at least minimum permissions in the policy ''AWSGreengrassResourceAccessRolePolicy''.
 */
public suspend inline fun GreengrassClient.associateServiceRoleToAccount(crossinline block: AssociateServiceRoleToAccountRequest.Builder.() -> Unit): AssociateServiceRoleToAccountResponse = associateServiceRoleToAccount(AssociateServiceRoleToAccountRequest.Builder().apply(block).build())

/**
 * Creates a connector definition. You may provide the initial version of the connector definition now or use ''CreateConnectorDefinitionVersion'' at a later time.
 */
public suspend inline fun GreengrassClient.createConnectorDefinition(crossinline block: CreateConnectorDefinitionRequest.Builder.() -> Unit): CreateConnectorDefinitionResponse = createConnectorDefinition(CreateConnectorDefinitionRequest.Builder().apply(block).build())

/**
 * Creates a version of a connector definition which has already been defined.
 */
public suspend inline fun GreengrassClient.createConnectorDefinitionVersion(crossinline block: CreateConnectorDefinitionVersionRequest.Builder.() -> Unit): CreateConnectorDefinitionVersionResponse = createConnectorDefinitionVersion(CreateConnectorDefinitionVersionRequest.Builder().apply(block).build())

/**
 * Creates a core definition. You may provide the initial version of the core definition now or use ''CreateCoreDefinitionVersion'' at a later time. Greengrass groups must each contain exactly one Greengrass core.
 */
public suspend inline fun GreengrassClient.createCoreDefinition(crossinline block: CreateCoreDefinitionRequest.Builder.() -> Unit): CreateCoreDefinitionResponse = createCoreDefinition(CreateCoreDefinitionRequest.Builder().apply(block).build())

/**
 * Creates a version of a core definition that has already been defined. Greengrass groups must each contain exactly one Greengrass core.
 */
public suspend inline fun GreengrassClient.createCoreDefinitionVersion(crossinline block: CreateCoreDefinitionVersionRequest.Builder.() -> Unit): CreateCoreDefinitionVersionResponse = createCoreDefinitionVersion(CreateCoreDefinitionVersionRequest.Builder().apply(block).build())

/**
 * Creates a deployment. ''CreateDeployment'' requests are idempotent with respect to the ''X-Amzn-Client-Token'' token and the request parameters.
 */
public suspend inline fun GreengrassClient.createDeployment(crossinline block: CreateDeploymentRequest.Builder.() -> Unit): CreateDeploymentResponse = createDeployment(CreateDeploymentRequest.Builder().apply(block).build())

/**
 * Creates a device definition. You may provide the initial version of the device definition now or use ''CreateDeviceDefinitionVersion'' at a later time.
 */
public suspend inline fun GreengrassClient.createDeviceDefinition(crossinline block: CreateDeviceDefinitionRequest.Builder.() -> Unit): CreateDeviceDefinitionResponse = createDeviceDefinition(CreateDeviceDefinitionRequest.Builder().apply(block).build())

/**
 * Creates a version of a device definition that has already been defined.
 */
public suspend inline fun GreengrassClient.createDeviceDefinitionVersion(crossinline block: CreateDeviceDefinitionVersionRequest.Builder.() -> Unit): CreateDeviceDefinitionVersionResponse = createDeviceDefinitionVersion(CreateDeviceDefinitionVersionRequest.Builder().apply(block).build())

/**
 * Creates a Lambda function definition which contains a list of Lambda functions and their configurations to be used in a group. You can create an initial version of the definition by providing a list of Lambda functions and their configurations now, or use ''CreateFunctionDefinitionVersion'' later.
 */
public suspend inline fun GreengrassClient.createFunctionDefinition(crossinline block: CreateFunctionDefinitionRequest.Builder.() -> Unit): CreateFunctionDefinitionResponse = createFunctionDefinition(CreateFunctionDefinitionRequest.Builder().apply(block).build())

/**
 * Creates a version of a Lambda function definition that has already been defined.
 */
public suspend inline fun GreengrassClient.createFunctionDefinitionVersion(crossinline block: CreateFunctionDefinitionVersionRequest.Builder.() -> Unit): CreateFunctionDefinitionVersionResponse = createFunctionDefinitionVersion(CreateFunctionDefinitionVersionRequest.Builder().apply(block).build())

/**
 * Creates a group. You may provide the initial version of the group or use ''CreateGroupVersion'' at a later time. Tip: You can use the ''gg_group_setup'' package (https://github.com/awslabs/aws-greengrass-group-setup) as a library or command-line application to create and deploy Greengrass groups.
 */
public suspend inline fun GreengrassClient.createGroup(crossinline block: CreateGroupRequest.Builder.() -> Unit): CreateGroupResponse = createGroup(CreateGroupRequest.Builder().apply(block).build())

/**
 * Creates a CA for the group. If a CA already exists, it will rotate the existing CA.
 */
public suspend inline fun GreengrassClient.createGroupCertificateAuthority(crossinline block: CreateGroupCertificateAuthorityRequest.Builder.() -> Unit): CreateGroupCertificateAuthorityResponse = createGroupCertificateAuthority(CreateGroupCertificateAuthorityRequest.Builder().apply(block).build())

/**
 * Creates a version of a group which has already been defined.
 */
public suspend inline fun GreengrassClient.createGroupVersion(crossinline block: CreateGroupVersionRequest.Builder.() -> Unit): CreateGroupVersionResponse = createGroupVersion(CreateGroupVersionRequest.Builder().apply(block).build())

/**
 * Creates a logger definition. You may provide the initial version of the logger definition now or use ''CreateLoggerDefinitionVersion'' at a later time.
 */
public suspend inline fun GreengrassClient.createLoggerDefinition(crossinline block: CreateLoggerDefinitionRequest.Builder.() -> Unit): CreateLoggerDefinitionResponse = createLoggerDefinition(CreateLoggerDefinitionRequest.Builder().apply(block).build())

/**
 * Creates a version of a logger definition that has already been defined.
 */
public suspend inline fun GreengrassClient.createLoggerDefinitionVersion(crossinline block: CreateLoggerDefinitionVersionRequest.Builder.() -> Unit): CreateLoggerDefinitionVersionResponse = createLoggerDefinitionVersion(CreateLoggerDefinitionVersionRequest.Builder().apply(block).build())

/**
 * Creates a resource definition which contains a list of resources to be used in a group. You can create an initial version of the definition by providing a list of resources now, or use ''CreateResourceDefinitionVersion'' later.
 */
public suspend inline fun GreengrassClient.createResourceDefinition(crossinline block: CreateResourceDefinitionRequest.Builder.() -> Unit): CreateResourceDefinitionResponse = createResourceDefinition(CreateResourceDefinitionRequest.Builder().apply(block).build())

/**
 * Creates a version of a resource definition that has already been defined.
 */
public suspend inline fun GreengrassClient.createResourceDefinitionVersion(crossinline block: CreateResourceDefinitionVersionRequest.Builder.() -> Unit): CreateResourceDefinitionVersionResponse = createResourceDefinitionVersion(CreateResourceDefinitionVersionRequest.Builder().apply(block).build())

/**
 * Creates a software update for a core or group of cores (specified as an IoT thing group.) Use this to update the OTA Agent as well as the Greengrass core software. It makes use of the IoT Jobs feature which provides additional commands to manage a Greengrass core software update job.
 */
public suspend inline fun GreengrassClient.createSoftwareUpdateJob(crossinline block: CreateSoftwareUpdateJobRequest.Builder.() -> Unit): CreateSoftwareUpdateJobResponse = createSoftwareUpdateJob(CreateSoftwareUpdateJobRequest.Builder().apply(block).build())

/**
 * Creates a subscription definition. You may provide the initial version of the subscription definition now or use ''CreateSubscriptionDefinitionVersion'' at a later time.
 */
public suspend inline fun GreengrassClient.createSubscriptionDefinition(crossinline block: CreateSubscriptionDefinitionRequest.Builder.() -> Unit): CreateSubscriptionDefinitionResponse = createSubscriptionDefinition(CreateSubscriptionDefinitionRequest.Builder().apply(block).build())

/**
 * Creates a version of a subscription definition which has already been defined.
 */
public suspend inline fun GreengrassClient.createSubscriptionDefinitionVersion(crossinline block: CreateSubscriptionDefinitionVersionRequest.Builder.() -> Unit): CreateSubscriptionDefinitionVersionResponse = createSubscriptionDefinitionVersion(CreateSubscriptionDefinitionVersionRequest.Builder().apply(block).build())

/**
 * Deletes a connector definition.
 */
public suspend inline fun GreengrassClient.deleteConnectorDefinition(crossinline block: DeleteConnectorDefinitionRequest.Builder.() -> Unit): DeleteConnectorDefinitionResponse = deleteConnectorDefinition(DeleteConnectorDefinitionRequest.Builder().apply(block).build())

/**
 * Deletes a core definition.
 */
public suspend inline fun GreengrassClient.deleteCoreDefinition(crossinline block: DeleteCoreDefinitionRequest.Builder.() -> Unit): DeleteCoreDefinitionResponse = deleteCoreDefinition(DeleteCoreDefinitionRequest.Builder().apply(block).build())

/**
 * Deletes a device definition.
 */
public suspend inline fun GreengrassClient.deleteDeviceDefinition(crossinline block: DeleteDeviceDefinitionRequest.Builder.() -> Unit): DeleteDeviceDefinitionResponse = deleteDeviceDefinition(DeleteDeviceDefinitionRequest.Builder().apply(block).build())

/**
 * Deletes a Lambda function definition.
 */
public suspend inline fun GreengrassClient.deleteFunctionDefinition(crossinline block: DeleteFunctionDefinitionRequest.Builder.() -> Unit): DeleteFunctionDefinitionResponse = deleteFunctionDefinition(DeleteFunctionDefinitionRequest.Builder().apply(block).build())

/**
 * Deletes a group.
 */
public suspend inline fun GreengrassClient.deleteGroup(crossinline block: DeleteGroupRequest.Builder.() -> Unit): DeleteGroupResponse = deleteGroup(DeleteGroupRequest.Builder().apply(block).build())

/**
 * Deletes a logger definition.
 */
public suspend inline fun GreengrassClient.deleteLoggerDefinition(crossinline block: DeleteLoggerDefinitionRequest.Builder.() -> Unit): DeleteLoggerDefinitionResponse = deleteLoggerDefinition(DeleteLoggerDefinitionRequest.Builder().apply(block).build())

/**
 * Deletes a resource definition.
 */
public suspend inline fun GreengrassClient.deleteResourceDefinition(crossinline block: DeleteResourceDefinitionRequest.Builder.() -> Unit): DeleteResourceDefinitionResponse = deleteResourceDefinition(DeleteResourceDefinitionRequest.Builder().apply(block).build())

/**
 * Deletes a subscription definition.
 */
public suspend inline fun GreengrassClient.deleteSubscriptionDefinition(crossinline block: DeleteSubscriptionDefinitionRequest.Builder.() -> Unit): DeleteSubscriptionDefinitionResponse = deleteSubscriptionDefinition(DeleteSubscriptionDefinitionRequest.Builder().apply(block).build())

/**
 * Disassociates the role from a group.
 */
public suspend inline fun GreengrassClient.disassociateRoleFromGroup(crossinline block: DisassociateRoleFromGroupRequest.Builder.() -> Unit): DisassociateRoleFromGroupResponse = disassociateRoleFromGroup(DisassociateRoleFromGroupRequest.Builder().apply(block).build())

/**
 * Disassociates the service role from your account. Without a service role, deployments will not work.
 */
public suspend inline fun GreengrassClient.disassociateServiceRoleFromAccount(crossinline block: DisassociateServiceRoleFromAccountRequest.Builder.() -> Unit): DisassociateServiceRoleFromAccountResponse = disassociateServiceRoleFromAccount(DisassociateServiceRoleFromAccountRequest.Builder().apply(block).build())

/**
 * Retrieves the role associated with a particular group.
 */
public suspend inline fun GreengrassClient.getAssociatedRole(crossinline block: GetAssociatedRoleRequest.Builder.() -> Unit): GetAssociatedRoleResponse = getAssociatedRole(GetAssociatedRoleRequest.Builder().apply(block).build())

/**
 * Returns the status of a bulk deployment.
 */
public suspend inline fun GreengrassClient.getBulkDeploymentStatus(crossinline block: GetBulkDeploymentStatusRequest.Builder.() -> Unit): GetBulkDeploymentStatusResponse = getBulkDeploymentStatus(GetBulkDeploymentStatusRequest.Builder().apply(block).build())

/**
 * Retrieves the connectivity information for a core.
 */
public suspend inline fun GreengrassClient.getConnectivityInfo(crossinline block: GetConnectivityInfoRequest.Builder.() -> Unit): GetConnectivityInfoResponse = getConnectivityInfo(GetConnectivityInfoRequest.Builder().apply(block).build())

/**
 * Retrieves information about a connector definition.
 */
public suspend inline fun GreengrassClient.getConnectorDefinition(crossinline block: GetConnectorDefinitionRequest.Builder.() -> Unit): GetConnectorDefinitionResponse = getConnectorDefinition(GetConnectorDefinitionRequest.Builder().apply(block).build())

/**
 * Retrieves information about a connector definition version, including the connectors that the version contains. Connectors are prebuilt modules that interact with local infrastructure, device protocols, AWS, and other cloud services.
 */
public suspend inline fun GreengrassClient.getConnectorDefinitionVersion(crossinline block: GetConnectorDefinitionVersionRequest.Builder.() -> Unit): GetConnectorDefinitionVersionResponse = getConnectorDefinitionVersion(GetConnectorDefinitionVersionRequest.Builder().apply(block).build())

/**
 * Retrieves information about a core definition version.
 */
public suspend inline fun GreengrassClient.getCoreDefinition(crossinline block: GetCoreDefinitionRequest.Builder.() -> Unit): GetCoreDefinitionResponse = getCoreDefinition(GetCoreDefinitionRequest.Builder().apply(block).build())

/**
 * Retrieves information about a core definition version.
 */
public suspend inline fun GreengrassClient.getCoreDefinitionVersion(crossinline block: GetCoreDefinitionVersionRequest.Builder.() -> Unit): GetCoreDefinitionVersionResponse = getCoreDefinitionVersion(GetCoreDefinitionVersionRequest.Builder().apply(block).build())

/**
 * Returns the status of a deployment.
 */
public suspend inline fun GreengrassClient.getDeploymentStatus(crossinline block: GetDeploymentStatusRequest.Builder.() -> Unit): GetDeploymentStatusResponse = getDeploymentStatus(GetDeploymentStatusRequest.Builder().apply(block).build())

/**
 * Retrieves information about a device definition.
 */
public suspend inline fun GreengrassClient.getDeviceDefinition(crossinline block: GetDeviceDefinitionRequest.Builder.() -> Unit): GetDeviceDefinitionResponse = getDeviceDefinition(GetDeviceDefinitionRequest.Builder().apply(block).build())

/**
 * Retrieves information about a device definition version.
 */
public suspend inline fun GreengrassClient.getDeviceDefinitionVersion(crossinline block: GetDeviceDefinitionVersionRequest.Builder.() -> Unit): GetDeviceDefinitionVersionResponse = getDeviceDefinitionVersion(GetDeviceDefinitionVersionRequest.Builder().apply(block).build())

/**
 * Retrieves information about a Lambda function definition, including its creation time and latest version.
 */
public suspend inline fun GreengrassClient.getFunctionDefinition(crossinline block: GetFunctionDefinitionRequest.Builder.() -> Unit): GetFunctionDefinitionResponse = getFunctionDefinition(GetFunctionDefinitionRequest.Builder().apply(block).build())

/**
 * Retrieves information about a Lambda function definition version, including which Lambda functions are included in the version and their configurations.
 */
public suspend inline fun GreengrassClient.getFunctionDefinitionVersion(crossinline block: GetFunctionDefinitionVersionRequest.Builder.() -> Unit): GetFunctionDefinitionVersionResponse = getFunctionDefinitionVersion(GetFunctionDefinitionVersionRequest.Builder().apply(block).build())

/**
 * Retrieves information about a group.
 */
public suspend inline fun GreengrassClient.getGroup(crossinline block: GetGroupRequest.Builder.() -> Unit): GetGroupResponse = getGroup(GetGroupRequest.Builder().apply(block).build())

/**
 * Retreives the CA associated with a group. Returns the public key of the CA.
 */
public suspend inline fun GreengrassClient.getGroupCertificateAuthority(crossinline block: GetGroupCertificateAuthorityRequest.Builder.() -> Unit): GetGroupCertificateAuthorityResponse = getGroupCertificateAuthority(GetGroupCertificateAuthorityRequest.Builder().apply(block).build())

/**
 * Retrieves the current configuration for the CA used by the group.
 */
public suspend inline fun GreengrassClient.getGroupCertificateConfiguration(crossinline block: GetGroupCertificateConfigurationRequest.Builder.() -> Unit): GetGroupCertificateConfigurationResponse = getGroupCertificateConfiguration(GetGroupCertificateConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves information about a group version.
 */
public suspend inline fun GreengrassClient.getGroupVersion(crossinline block: GetGroupVersionRequest.Builder.() -> Unit): GetGroupVersionResponse = getGroupVersion(GetGroupVersionRequest.Builder().apply(block).build())

/**
 * Retrieves information about a logger definition.
 */
public suspend inline fun GreengrassClient.getLoggerDefinition(crossinline block: GetLoggerDefinitionRequest.Builder.() -> Unit): GetLoggerDefinitionResponse = getLoggerDefinition(GetLoggerDefinitionRequest.Builder().apply(block).build())

/**
 * Retrieves information about a logger definition version.
 */
public suspend inline fun GreengrassClient.getLoggerDefinitionVersion(crossinline block: GetLoggerDefinitionVersionRequest.Builder.() -> Unit): GetLoggerDefinitionVersionResponse = getLoggerDefinitionVersion(GetLoggerDefinitionVersionRequest.Builder().apply(block).build())

/**
 * Retrieves information about a resource definition, including its creation time and latest version.
 */
public suspend inline fun GreengrassClient.getResourceDefinition(crossinline block: GetResourceDefinitionRequest.Builder.() -> Unit): GetResourceDefinitionResponse = getResourceDefinition(GetResourceDefinitionRequest.Builder().apply(block).build())

/**
 * Retrieves information about a resource definition version, including which resources are included in the version.
 */
public suspend inline fun GreengrassClient.getResourceDefinitionVersion(crossinline block: GetResourceDefinitionVersionRequest.Builder.() -> Unit): GetResourceDefinitionVersionResponse = getResourceDefinitionVersion(GetResourceDefinitionVersionRequest.Builder().apply(block).build())

/**
 * Retrieves the service role that is attached to your account.
 */
public suspend inline fun GreengrassClient.getServiceRoleForAccount(crossinline block: GetServiceRoleForAccountRequest.Builder.() -> Unit): GetServiceRoleForAccountResponse = getServiceRoleForAccount(GetServiceRoleForAccountRequest.Builder().apply(block).build())

/**
 * Retrieves information about a subscription definition.
 */
public suspend inline fun GreengrassClient.getSubscriptionDefinition(crossinline block: GetSubscriptionDefinitionRequest.Builder.() -> Unit): GetSubscriptionDefinitionResponse = getSubscriptionDefinition(GetSubscriptionDefinitionRequest.Builder().apply(block).build())

/**
 * Retrieves information about a subscription definition version.
 */
public suspend inline fun GreengrassClient.getSubscriptionDefinitionVersion(crossinline block: GetSubscriptionDefinitionVersionRequest.Builder.() -> Unit): GetSubscriptionDefinitionVersionResponse = getSubscriptionDefinitionVersion(GetSubscriptionDefinitionVersionRequest.Builder().apply(block).build())

/**
 * Get the runtime configuration of a thing.
 */
public suspend inline fun GreengrassClient.getThingRuntimeConfiguration(crossinline block: GetThingRuntimeConfigurationRequest.Builder.() -> Unit): GetThingRuntimeConfigurationResponse = getThingRuntimeConfiguration(GetThingRuntimeConfigurationRequest.Builder().apply(block).build())

/**
 * Gets a paginated list of the deployments that have been started in a bulk deployment operation, and their current deployment status.
 */
public suspend inline fun GreengrassClient.listBulkDeploymentDetailedReports(crossinline block: ListBulkDeploymentDetailedReportsRequest.Builder.() -> Unit): ListBulkDeploymentDetailedReportsResponse = listBulkDeploymentDetailedReports(ListBulkDeploymentDetailedReportsRequest.Builder().apply(block).build())

/**
 * Returns a list of bulk deployments.
 */
public suspend inline fun GreengrassClient.listBulkDeployments(crossinline block: ListBulkDeploymentsRequest.Builder.() -> Unit): ListBulkDeploymentsResponse = listBulkDeployments(ListBulkDeploymentsRequest.Builder().apply(block).build())

/**
 * Lists the versions of a connector definition, which are containers for connectors. Connectors run on the Greengrass core and contain built-in integration with local infrastructure, device protocols, AWS, and other cloud services.
 */
public suspend inline fun GreengrassClient.listConnectorDefinitionVersions(crossinline block: ListConnectorDefinitionVersionsRequest.Builder.() -> Unit): ListConnectorDefinitionVersionsResponse = listConnectorDefinitionVersions(ListConnectorDefinitionVersionsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of connector definitions.
 */
public suspend inline fun GreengrassClient.listConnectorDefinitions(crossinline block: ListConnectorDefinitionsRequest.Builder.() -> Unit): ListConnectorDefinitionsResponse = listConnectorDefinitions(ListConnectorDefinitionsRequest.Builder().apply(block).build())

/**
 * Lists the versions of a core definition.
 */
public suspend inline fun GreengrassClient.listCoreDefinitionVersions(crossinline block: ListCoreDefinitionVersionsRequest.Builder.() -> Unit): ListCoreDefinitionVersionsResponse = listCoreDefinitionVersions(ListCoreDefinitionVersionsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of core definitions.
 */
public suspend inline fun GreengrassClient.listCoreDefinitions(crossinline block: ListCoreDefinitionsRequest.Builder.() -> Unit): ListCoreDefinitionsResponse = listCoreDefinitions(ListCoreDefinitionsRequest.Builder().apply(block).build())

/**
 * Returns a history of deployments for the group.
 */
public suspend inline fun GreengrassClient.listDeployments(crossinline block: ListDeploymentsRequest.Builder.() -> Unit): ListDeploymentsResponse = listDeployments(ListDeploymentsRequest.Builder().apply(block).build())

/**
 * Lists the versions of a device definition.
 */
public suspend inline fun GreengrassClient.listDeviceDefinitionVersions(crossinline block: ListDeviceDefinitionVersionsRequest.Builder.() -> Unit): ListDeviceDefinitionVersionsResponse = listDeviceDefinitionVersions(ListDeviceDefinitionVersionsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of device definitions.
 */
public suspend inline fun GreengrassClient.listDeviceDefinitions(crossinline block: ListDeviceDefinitionsRequest.Builder.() -> Unit): ListDeviceDefinitionsResponse = listDeviceDefinitions(ListDeviceDefinitionsRequest.Builder().apply(block).build())

/**
 * Lists the versions of a Lambda function definition.
 */
public suspend inline fun GreengrassClient.listFunctionDefinitionVersions(crossinline block: ListFunctionDefinitionVersionsRequest.Builder.() -> Unit): ListFunctionDefinitionVersionsResponse = listFunctionDefinitionVersions(ListFunctionDefinitionVersionsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of Lambda function definitions.
 */
public suspend inline fun GreengrassClient.listFunctionDefinitions(crossinline block: ListFunctionDefinitionsRequest.Builder.() -> Unit): ListFunctionDefinitionsResponse = listFunctionDefinitions(ListFunctionDefinitionsRequest.Builder().apply(block).build())

/**
 * Retrieves the current CAs for a group.
 */
public suspend inline fun GreengrassClient.listGroupCertificateAuthorities(crossinline block: ListGroupCertificateAuthoritiesRequest.Builder.() -> Unit): ListGroupCertificateAuthoritiesResponse = listGroupCertificateAuthorities(ListGroupCertificateAuthoritiesRequest.Builder().apply(block).build())

/**
 * Lists the versions of a group.
 */
public suspend inline fun GreengrassClient.listGroupVersions(crossinline block: ListGroupVersionsRequest.Builder.() -> Unit): ListGroupVersionsResponse = listGroupVersions(ListGroupVersionsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of groups.
 */
public suspend inline fun GreengrassClient.listGroups(crossinline block: ListGroupsRequest.Builder.() -> Unit): ListGroupsResponse = listGroups(ListGroupsRequest.Builder().apply(block).build())

/**
 * Lists the versions of a logger definition.
 */
public suspend inline fun GreengrassClient.listLoggerDefinitionVersions(crossinline block: ListLoggerDefinitionVersionsRequest.Builder.() -> Unit): ListLoggerDefinitionVersionsResponse = listLoggerDefinitionVersions(ListLoggerDefinitionVersionsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of logger definitions.
 */
public suspend inline fun GreengrassClient.listLoggerDefinitions(crossinline block: ListLoggerDefinitionsRequest.Builder.() -> Unit): ListLoggerDefinitionsResponse = listLoggerDefinitions(ListLoggerDefinitionsRequest.Builder().apply(block).build())

/**
 * Lists the versions of a resource definition.
 */
public suspend inline fun GreengrassClient.listResourceDefinitionVersions(crossinline block: ListResourceDefinitionVersionsRequest.Builder.() -> Unit): ListResourceDefinitionVersionsResponse = listResourceDefinitionVersions(ListResourceDefinitionVersionsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of resource definitions.
 */
public suspend inline fun GreengrassClient.listResourceDefinitions(crossinline block: ListResourceDefinitionsRequest.Builder.() -> Unit): ListResourceDefinitionsResponse = listResourceDefinitions(ListResourceDefinitionsRequest.Builder().apply(block).build())

/**
 * Lists the versions of a subscription definition.
 */
public suspend inline fun GreengrassClient.listSubscriptionDefinitionVersions(crossinline block: ListSubscriptionDefinitionVersionsRequest.Builder.() -> Unit): ListSubscriptionDefinitionVersionsResponse = listSubscriptionDefinitionVersions(ListSubscriptionDefinitionVersionsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of subscription definitions.
 */
public suspend inline fun GreengrassClient.listSubscriptionDefinitions(crossinline block: ListSubscriptionDefinitionsRequest.Builder.() -> Unit): ListSubscriptionDefinitionsResponse = listSubscriptionDefinitions(ListSubscriptionDefinitionsRequest.Builder().apply(block).build())

/**
 * Retrieves a list of resource tags for a resource arn.
 */
public suspend inline fun GreengrassClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Resets a group's deployments.
 */
public suspend inline fun GreengrassClient.resetDeployments(crossinline block: ResetDeploymentsRequest.Builder.() -> Unit): ResetDeploymentsResponse = resetDeployments(ResetDeploymentsRequest.Builder().apply(block).build())

/**
 * Deploys multiple groups in one operation. This action starts the bulk deployment of a specified set of group versions. Each group version deployment will be triggered with an adaptive rate that has a fixed upper limit. We recommend that you include an ''X-Amzn-Client-Token'' token in every ''StartBulkDeployment'' request. These requests are idempotent with respect to the token and the request parameters.
 */
public suspend inline fun GreengrassClient.startBulkDeployment(crossinline block: StartBulkDeploymentRequest.Builder.() -> Unit): StartBulkDeploymentResponse = startBulkDeployment(StartBulkDeploymentRequest.Builder().apply(block).build())

/**
 * Stops the execution of a bulk deployment. This action returns a status of ''Stopping'' until the deployment is stopped. You cannot start a new bulk deployment while a previous deployment is in the ''Stopping'' state. This action doesn't rollback completed deployments or cancel pending deployments.
 */
public suspend inline fun GreengrassClient.stopBulkDeployment(crossinline block: StopBulkDeploymentRequest.Builder.() -> Unit): StopBulkDeploymentResponse = stopBulkDeployment(StopBulkDeploymentRequest.Builder().apply(block).build())

/**
 * Adds tags to a Greengrass resource. Valid resources are 'Group', 'ConnectorDefinition', 'CoreDefinition', 'DeviceDefinition', 'FunctionDefinition', 'LoggerDefinition', 'SubscriptionDefinition', 'ResourceDefinition', and 'BulkDeployment'.
 */
public suspend inline fun GreengrassClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Remove resource tags from a Greengrass Resource.
 */
public suspend inline fun GreengrassClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates the connectivity information for the core. Any devices that belong to the group which has this core will receive this information in order to find the location of the core and connect to it.
 */
public suspend inline fun GreengrassClient.updateConnectivityInfo(crossinline block: UpdateConnectivityInfoRequest.Builder.() -> Unit): UpdateConnectivityInfoResponse = updateConnectivityInfo(UpdateConnectivityInfoRequest.Builder().apply(block).build())

/**
 * Updates a connector definition.
 */
public suspend inline fun GreengrassClient.updateConnectorDefinition(crossinline block: UpdateConnectorDefinitionRequest.Builder.() -> Unit): UpdateConnectorDefinitionResponse = updateConnectorDefinition(UpdateConnectorDefinitionRequest.Builder().apply(block).build())

/**
 * Updates a core definition.
 */
public suspend inline fun GreengrassClient.updateCoreDefinition(crossinline block: UpdateCoreDefinitionRequest.Builder.() -> Unit): UpdateCoreDefinitionResponse = updateCoreDefinition(UpdateCoreDefinitionRequest.Builder().apply(block).build())

/**
 * Updates a device definition.
 */
public suspend inline fun GreengrassClient.updateDeviceDefinition(crossinline block: UpdateDeviceDefinitionRequest.Builder.() -> Unit): UpdateDeviceDefinitionResponse = updateDeviceDefinition(UpdateDeviceDefinitionRequest.Builder().apply(block).build())

/**
 * Updates a Lambda function definition.
 */
public suspend inline fun GreengrassClient.updateFunctionDefinition(crossinline block: UpdateFunctionDefinitionRequest.Builder.() -> Unit): UpdateFunctionDefinitionResponse = updateFunctionDefinition(UpdateFunctionDefinitionRequest.Builder().apply(block).build())

/**
 * Updates a group.
 */
public suspend inline fun GreengrassClient.updateGroup(crossinline block: UpdateGroupRequest.Builder.() -> Unit): UpdateGroupResponse = updateGroup(UpdateGroupRequest.Builder().apply(block).build())

/**
 * Updates the Certificate expiry time for a group.
 */
public suspend inline fun GreengrassClient.updateGroupCertificateConfiguration(crossinline block: UpdateGroupCertificateConfigurationRequest.Builder.() -> Unit): UpdateGroupCertificateConfigurationResponse = updateGroupCertificateConfiguration(UpdateGroupCertificateConfigurationRequest.Builder().apply(block).build())

/**
 * Updates a logger definition.
 */
public suspend inline fun GreengrassClient.updateLoggerDefinition(crossinline block: UpdateLoggerDefinitionRequest.Builder.() -> Unit): UpdateLoggerDefinitionResponse = updateLoggerDefinition(UpdateLoggerDefinitionRequest.Builder().apply(block).build())

/**
 * Updates a resource definition.
 */
public suspend inline fun GreengrassClient.updateResourceDefinition(crossinline block: UpdateResourceDefinitionRequest.Builder.() -> Unit): UpdateResourceDefinitionResponse = updateResourceDefinition(UpdateResourceDefinitionRequest.Builder().apply(block).build())

/**
 * Updates a subscription definition.
 */
public suspend inline fun GreengrassClient.updateSubscriptionDefinition(crossinline block: UpdateSubscriptionDefinitionRequest.Builder.() -> Unit): UpdateSubscriptionDefinitionResponse = updateSubscriptionDefinition(UpdateSubscriptionDefinitionRequest.Builder().apply(block).build())

/**
 * Updates the runtime configuration of a thing.
 */
public suspend inline fun GreengrassClient.updateThingRuntimeConfiguration(crossinline block: UpdateThingRuntimeConfigurationRequest.Builder.() -> Unit): UpdateThingRuntimeConfigurationResponse = updateThingRuntimeConfiguration(UpdateThingRuntimeConfigurationRequest.Builder().apply(block).build())
