// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.endpoints

import aws.smithy.kotlin.runtime.client.endpoints.Endpoint
import aws.smithy.kotlin.runtime.client.endpoints.EndpointProviderException
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.net.UrlDecoding
import kotlin.test.*
import kotlinx.coroutines.test.runTest

public class DefaultEndpointProviderTest {
    // For region ap-northeast-1 with FIPS disabled and DualStack disabled
    @Test
    fun test0() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-1"
            useFips = false
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana.ap-northeast-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-northeast-2 with FIPS disabled and DualStack disabled
    @Test
    fun test1() = runTest {
        val params = EndpointParameters {
            region = "ap-northeast-2"
            useFips = false
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana.ap-northeast-2.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-1 with FIPS disabled and DualStack disabled
    @Test
    fun test2() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-1"
            useFips = false
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana.ap-southeast-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region ap-southeast-2 with FIPS disabled and DualStack disabled
    @Test
    fun test3() = runTest {
        val params = EndpointParameters {
            region = "ap-southeast-2"
            useFips = false
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana.ap-southeast-2.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-central-1 with FIPS disabled and DualStack disabled
    @Test
    fun test4() = runTest {
        val params = EndpointParameters {
            region = "eu-central-1"
            useFips = false
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana.eu-central-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-1 with FIPS disabled and DualStack disabled
    @Test
    fun test5() = runTest {
        val params = EndpointParameters {
            region = "eu-west-1"
            useFips = false
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana.eu-west-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region eu-west-2 with FIPS disabled and DualStack disabled
    @Test
    fun test6() = runTest {
        val params = EndpointParameters {
            region = "eu-west-2"
            useFips = false
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana.eu-west-2.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test7() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useFips = false
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana.us-east-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-2 with FIPS disabled and DualStack disabled
    @Test
    fun test8() = runTest {
        val params = EndpointParameters {
            region = "us-east-2"
            useFips = false
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana.us-east-2.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-west-2 with FIPS disabled and DualStack disabled
    @Test
    fun test9() = runTest {
        val params = EndpointParameters {
            region = "us-west-2"
            useFips = false
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana.us-west-2.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test10() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useFips = true
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana-fips.us-east-1.api.aws", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test11() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useFips = true
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana-fips.us-east-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test12() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useFips = false
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana.us-east-1.api.aws", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS enabled and DualStack enabled
    @Test
    fun test13() = runTest {
        val params = EndpointParameters {
            region = "cn-north-1"
            useFips = true
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana-fips.cn-north-1.api.amazonwebservices.com.cn", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS enabled and DualStack disabled
    @Test
    fun test14() = runTest {
        val params = EndpointParameters {
            region = "cn-north-1"
            useFips = true
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana-fips.cn-north-1.amazonaws.com.cn", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS disabled and DualStack enabled
    @Test
    fun test15() = runTest {
        val params = EndpointParameters {
            region = "cn-north-1"
            useFips = false
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana.cn-north-1.api.amazonwebservices.com.cn", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region cn-north-1 with FIPS disabled and DualStack disabled
    @Test
    fun test16() = runTest {
        val params = EndpointParameters {
            region = "cn-north-1"
            useFips = false
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana.cn-north-1.amazonaws.com.cn", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test17() = runTest {
        val params = EndpointParameters {
            region = "us-gov-east-1"
            useFips = true
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana-fips.us-gov-east-1.api.aws", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test18() = runTest {
        val params = EndpointParameters {
            region = "us-gov-east-1"
            useFips = true
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana-fips.us-gov-east-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test19() = runTest {
        val params = EndpointParameters {
            region = "us-gov-east-1"
            useFips = false
            useDualStack = true
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana.us-gov-east-1.api.aws", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-gov-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test20() = runTest {
        val params = EndpointParameters {
            region = "us-gov-east-1"
            useFips = false
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana.us-gov-east-1.amazonaws.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-iso-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test21() = runTest {
        val params = EndpointParameters {
            region = "us-iso-east-1"
            useFips = true
            useDualStack = true
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("FIPS and DualStack are enabled, but this partition does not support one or both", ex.message)
    }

    // For region us-iso-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test22() = runTest {
        val params = EndpointParameters {
            region = "us-iso-east-1"
            useFips = true
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana-fips.us-iso-east-1.c2s.ic.gov", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-iso-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test23() = runTest {
        val params = EndpointParameters {
            region = "us-iso-east-1"
            useFips = false
            useDualStack = true
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("DualStack is enabled but this partition does not support DualStack", ex.message)
    }

    // For region us-iso-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test24() = runTest {
        val params = EndpointParameters {
            region = "us-iso-east-1"
            useFips = false
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana.us-iso-east-1.c2s.ic.gov", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-isob-east-1 with FIPS enabled and DualStack enabled
    @Test
    fun test25() = runTest {
        val params = EndpointParameters {
            region = "us-isob-east-1"
            useFips = true
            useDualStack = true
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("FIPS and DualStack are enabled, but this partition does not support one or both", ex.message)
    }

    // For region us-isob-east-1 with FIPS enabled and DualStack disabled
    @Test
    fun test26() = runTest {
        val params = EndpointParameters {
            region = "us-isob-east-1"
            useFips = true
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana-fips.us-isob-east-1.sc2s.sgov.gov", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For region us-isob-east-1 with FIPS disabled and DualStack enabled
    @Test
    fun test27() = runTest {
        val params = EndpointParameters {
            region = "us-isob-east-1"
            useFips = false
            useDualStack = true
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("DualStack is enabled but this partition does not support DualStack", ex.message)
    }

    // For region us-isob-east-1 with FIPS disabled and DualStack disabled
    @Test
    fun test28() = runTest {
        val params = EndpointParameters {
            region = "us-isob-east-1"
            useFips = false
            useDualStack = false
        }
        val expected = Endpoint(
            uri = Url.parse("https://grafana.us-isob-east-1.sc2s.sgov.gov", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with region set and fips disabled and dualstack disabled
    @Test
    fun test29() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useFips = false
            useDualStack = false
            endpoint = "https://example.com"
        }
        val expected = Endpoint(
            uri = Url.parse("https://example.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with region not set and fips disabled and dualstack disabled
    @Test
    fun test30() = runTest {
        val params = EndpointParameters {
            useFips = false
            useDualStack = false
            endpoint = "https://example.com"
        }
        val expected = Endpoint(
            uri = Url.parse("https://example.com", UrlDecoding.DecodeAll - UrlDecoding.DecodePath),
        )
        val actual = DefaultEndpointProvider().resolveEndpoint(params)
        assertEquals(expected, actual)
    }

    // For custom endpoint with fips enabled and dualstack disabled
    @Test
    fun test31() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useFips = true
            useDualStack = false
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: FIPS and custom endpoint are not supported", ex.message)
    }

    // For custom endpoint with fips disabled and dualstack enabled
    @Test
    fun test32() = runTest {
        val params = EndpointParameters {
            region = "us-east-1"
            useFips = false
            useDualStack = true
            endpoint = "https://example.com"
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: Dualstack and custom endpoint are not supported", ex.message)
    }

    // Missing region
    @Test
    fun test33() = runTest {
        val params = EndpointParameters {
        }
        val ex = assertFailsWith<EndpointProviderException> {
            DefaultEndpointProvider().resolveEndpoint(params)
        }
        assertEquals("Invalid Configuration: Missing Region", ex.message)
    }

}
