// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.transform

import aws.sdk.kotlin.services.grafana.model.DeleteWorkspaceApiKeyResponse
import aws.sdk.kotlin.services.grafana.model.GrafanaException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteWorkspaceApiKeyOperationDeserializer: HttpDeserialize<DeleteWorkspaceApiKeyResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteWorkspaceApiKeyResponse {
        if (!response.status.isSuccess()) {
            throwDeleteWorkspaceApiKeyError(context, response)
        }
        val builder = DeleteWorkspaceApiKeyResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeleteWorkspaceApiKeyOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeleteWorkspaceApiKeyError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GrafanaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> GrafanaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteWorkspaceApiKeyOperationBody(builder: DeleteWorkspaceApiKeyResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val KEYNAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("keyName"))
    val WORKSPACEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workspaceId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(KEYNAME_DESCRIPTOR)
        field(WORKSPACEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                KEYNAME_DESCRIPTOR.index -> builder.keyName = deserializeString()
                WORKSPACEID_DESCRIPTOR.index -> builder.workspaceId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
