// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.paginators

import aws.sdk.kotlin.services.grafana.GrafanaClient
import aws.sdk.kotlin.services.grafana.model.ListVersionsRequest
import aws.sdk.kotlin.services.grafana.model.ListVersionsResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVersionsResponse]
 */
public fun GrafanaClient.listVersionsPaginated(initialRequest: ListVersionsRequest): Flow<ListVersionsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listVersionsPaginated.listVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVersionsResponse]
 */
public fun GrafanaClient.listVersionsPaginated(block: ListVersionsRequest.Builder.() -> Unit): Flow<ListVersionsResponse> =
    listVersionsPaginated(ListVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listVersionsPaginated]
 * to access the nested member [GrafanaVersion]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GrafanaVersion]
 */
@JvmName("listVersionsResponseGrafanaVersion")
public fun Flow<ListVersionsResponse>.grafanaVersions(): Flow<String> =
    transform() { response ->
        response.grafanaVersions?.forEach {
            emit(it)
        }
    }
