// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * A structure containing information about an Amazon Managed Grafana workspace in your account.
 */
public class WorkspaceDescription private constructor(builder: Builder) {
    /**
     * Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If this is `ORGANIZATION`, the `workspaceOrganizationalUnits` parameter specifies which organizational units the workspace can access.
     */
    public val accountAccessType: aws.sdk.kotlin.services.grafana.model.AccountAccessType? = builder.accountAccessType
    /**
     * A structure that describes whether the workspace uses SAML, IAM Identity Center, or both methods for user authentication.
     */
    public val authentication: aws.sdk.kotlin.services.grafana.model.AuthenticationSummary? = builder.authentication
    /**
     * The date that the workspace was created.
     */
    public val created: aws.smithy.kotlin.runtime.time.Instant? = builder.created
    /**
     * Specifies the Amazon Web Services data sources that have been configured to have IAM roles and permissions created to allow Amazon Managed Grafana to read data from these sources.
     *
     * This list is only used when the workspace was created through the Amazon Web Services console, and the `permissionType` is `SERVICE_MANAGED`.
     */
    public val dataSources: List<DataSourceType>? = builder.dataSources
    /**
     * The user-defined description of the workspace.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The URL that users can use to access the Grafana console in the workspace.
     */
    public val endpoint: kotlin.String? = builder.endpoint
    /**
     * Specifies whether this workspace has already fully used its free trial for Grafana Enterprise.
     */
    public val freeTrialConsumed: kotlin.Boolean? = builder.freeTrialConsumed
    /**
     * If this workspace is currently in the free trial period for Grafana Enterprise, this value specifies when that free trial ends.
     */
    public val freeTrialExpiration: aws.smithy.kotlin.runtime.time.Instant? = builder.freeTrialExpiration
    /**
     * The version of Grafana supported in this workspace.
     */
    public val grafanaVersion: kotlin.String? = builder.grafanaVersion
    /**
     * The unique ID of this workspace.
     */
    public val id: kotlin.String? = builder.id
    /**
     * If this workspace has a full Grafana Enterprise license, this specifies when the license ends and will need to be renewed.
     */
    public val licenseExpiration: aws.smithy.kotlin.runtime.time.Instant? = builder.licenseExpiration
    /**
     * Specifies whether this workspace has a full Grafana Enterprise license or a free trial license.
     */
    public val licenseType: aws.sdk.kotlin.services.grafana.model.LicenseType? = builder.licenseType
    /**
     * The most recent date that the workspace was modified.
     */
    public val modified: aws.smithy.kotlin.runtime.time.Instant? = builder.modified
    /**
     * The name of the workspace.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The configuration settings for network access to your workspace.
     */
    public val networkAccessControl: aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration? = builder.networkAccessControl
    /**
     * The Amazon Web Services notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, to allow Amazon Managed Grafana to use these channels.
     */
    public val notificationDestinations: List<NotificationDestinationType>? = builder.notificationDestinations
    /**
     * The name of the IAM role that is used to access resources through Organizations.
     */
    public val organizationRoleName: kotlin.String? = builder.organizationRoleName
    /**
     * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.
     */
    public val organizationalUnits: List<String>? = builder.organizationalUnits
    /**
     * If this is `SERVICE_MANAGED`, and the workplace was created through the Amazon Managed Grafana console, then Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification channels.
     *
     * If this is `CUSTOMER_MANAGED`, you must manage those roles and permissions yourself.
     *
     * If you are working with a workspace in a member account of an organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, this parameter must be set to `CUSTOMER_MANAGED`.
     *
     * For more information about converting between customer and service managed, see [Managing permissions for data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-datasource-and-notification.html). For more information about the roles and permissions that must be managed for customer managed workspaces, see [Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html)
     */
    public val permissionType: aws.sdk.kotlin.services.grafana.model.PermissionType? = builder.permissionType
    /**
     * The name of the CloudFormation stack set that is used to generate IAM roles to be used for this workspace.
     */
    public val stackSetName: kotlin.String? = builder.stackSetName
    /**
     * The current status of the workspace.
     */
    public val status: aws.sdk.kotlin.services.grafana.model.WorkspaceStatus? = builder.status
    /**
     * The list of tags associated with the workspace.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * The configuration for connecting to data sources in a private VPC (Amazon Virtual Private Cloud).
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.grafana.model.VpcConfiguration? = builder.vpcConfiguration
    /**
     * The IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from. This role must already exist.
     */
    public val workspaceRoleArn: kotlin.String? = builder.workspaceRoleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.grafana.model.WorkspaceDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorkspaceDescription(")
        append("accountAccessType=$accountAccessType,")
        append("authentication=$authentication,")
        append("created=$created,")
        append("dataSources=$dataSources,")
        append("description=*** Sensitive Data Redacted ***,")
        append("endpoint=$endpoint,")
        append("freeTrialConsumed=$freeTrialConsumed,")
        append("freeTrialExpiration=$freeTrialExpiration,")
        append("grafanaVersion=$grafanaVersion,")
        append("id=$id,")
        append("licenseExpiration=$licenseExpiration,")
        append("licenseType=$licenseType,")
        append("modified=$modified,")
        append("name=*** Sensitive Data Redacted ***,")
        append("networkAccessControl=$networkAccessControl,")
        append("notificationDestinations=$notificationDestinations,")
        append("organizationRoleName=*** Sensitive Data Redacted ***,")
        append("organizationalUnits=*** Sensitive Data Redacted ***,")
        append("permissionType=$permissionType,")
        append("stackSetName=$stackSetName,")
        append("status=$status,")
        append("tags=$tags,")
        append("vpcConfiguration=$vpcConfiguration,")
        append("workspaceRoleArn=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountAccessType?.hashCode() ?: 0
        result = 31 * result + (authentication?.hashCode() ?: 0)
        result = 31 * result + (created?.hashCode() ?: 0)
        result = 31 * result + (dataSources?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (endpoint?.hashCode() ?: 0)
        result = 31 * result + (freeTrialConsumed?.hashCode() ?: 0)
        result = 31 * result + (freeTrialExpiration?.hashCode() ?: 0)
        result = 31 * result + (grafanaVersion?.hashCode() ?: 0)
        result = 31 * result + (id?.hashCode() ?: 0)
        result = 31 * result + (licenseExpiration?.hashCode() ?: 0)
        result = 31 * result + (licenseType?.hashCode() ?: 0)
        result = 31 * result + (modified?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (networkAccessControl?.hashCode() ?: 0)
        result = 31 * result + (notificationDestinations?.hashCode() ?: 0)
        result = 31 * result + (organizationRoleName?.hashCode() ?: 0)
        result = 31 * result + (organizationalUnits?.hashCode() ?: 0)
        result = 31 * result + (permissionType?.hashCode() ?: 0)
        result = 31 * result + (stackSetName?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        result = 31 * result + (workspaceRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorkspaceDescription

        if (accountAccessType != other.accountAccessType) return false
        if (authentication != other.authentication) return false
        if (created != other.created) return false
        if (dataSources != other.dataSources) return false
        if (description != other.description) return false
        if (endpoint != other.endpoint) return false
        if (freeTrialConsumed != other.freeTrialConsumed) return false
        if (freeTrialExpiration != other.freeTrialExpiration) return false
        if (grafanaVersion != other.grafanaVersion) return false
        if (id != other.id) return false
        if (licenseExpiration != other.licenseExpiration) return false
        if (licenseType != other.licenseType) return false
        if (modified != other.modified) return false
        if (name != other.name) return false
        if (networkAccessControl != other.networkAccessControl) return false
        if (notificationDestinations != other.notificationDestinations) return false
        if (organizationRoleName != other.organizationRoleName) return false
        if (organizationalUnits != other.organizationalUnits) return false
        if (permissionType != other.permissionType) return false
        if (stackSetName != other.stackSetName) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (vpcConfiguration != other.vpcConfiguration) return false
        if (workspaceRoleArn != other.workspaceRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.grafana.model.WorkspaceDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If this is `ORGANIZATION`, the `workspaceOrganizationalUnits` parameter specifies which organizational units the workspace can access.
         */
        public var accountAccessType: aws.sdk.kotlin.services.grafana.model.AccountAccessType? = null
        /**
         * A structure that describes whether the workspace uses SAML, IAM Identity Center, or both methods for user authentication.
         */
        public var authentication: aws.sdk.kotlin.services.grafana.model.AuthenticationSummary? = null
        /**
         * The date that the workspace was created.
         */
        public var created: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies the Amazon Web Services data sources that have been configured to have IAM roles and permissions created to allow Amazon Managed Grafana to read data from these sources.
         *
         * This list is only used when the workspace was created through the Amazon Web Services console, and the `permissionType` is `SERVICE_MANAGED`.
         */
        public var dataSources: List<DataSourceType>? = null
        /**
         * The user-defined description of the workspace.
         */
        public var description: kotlin.String? = null
        /**
         * The URL that users can use to access the Grafana console in the workspace.
         */
        public var endpoint: kotlin.String? = null
        /**
         * Specifies whether this workspace has already fully used its free trial for Grafana Enterprise.
         */
        public var freeTrialConsumed: kotlin.Boolean? = null
        /**
         * If this workspace is currently in the free trial period for Grafana Enterprise, this value specifies when that free trial ends.
         */
        public var freeTrialExpiration: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The version of Grafana supported in this workspace.
         */
        public var grafanaVersion: kotlin.String? = null
        /**
         * The unique ID of this workspace.
         */
        public var id: kotlin.String? = null
        /**
         * If this workspace has a full Grafana Enterprise license, this specifies when the license ends and will need to be renewed.
         */
        public var licenseExpiration: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Specifies whether this workspace has a full Grafana Enterprise license or a free trial license.
         */
        public var licenseType: aws.sdk.kotlin.services.grafana.model.LicenseType? = null
        /**
         * The most recent date that the workspace was modified.
         */
        public var modified: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the workspace.
         */
        public var name: kotlin.String? = null
        /**
         * The configuration settings for network access to your workspace.
         */
        public var networkAccessControl: aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration? = null
        /**
         * The Amazon Web Services notification channels that Amazon Managed Grafana can automatically create IAM roles and permissions for, to allow Amazon Managed Grafana to use these channels.
         */
        public var notificationDestinations: List<NotificationDestinationType>? = null
        /**
         * The name of the IAM role that is used to access resources through Organizations.
         */
        public var organizationRoleName: kotlin.String? = null
        /**
         * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.
         */
        public var organizationalUnits: List<String>? = null
        /**
         * If this is `SERVICE_MANAGED`, and the workplace was created through the Amazon Managed Grafana console, then Amazon Managed Grafana automatically creates the IAM roles and provisions the permissions that the workspace needs to use Amazon Web Services data sources and notification channels.
         *
         * If this is `CUSTOMER_MANAGED`, you must manage those roles and permissions yourself.
         *
         * If you are working with a workspace in a member account of an organization and that account is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, this parameter must be set to `CUSTOMER_MANAGED`.
         *
         * For more information about converting between customer and service managed, see [Managing permissions for data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-datasource-and-notification.html). For more information about the roles and permissions that must be managed for customer managed workspaces, see [Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html)
         */
        public var permissionType: aws.sdk.kotlin.services.grafana.model.PermissionType? = null
        /**
         * The name of the CloudFormation stack set that is used to generate IAM roles to be used for this workspace.
         */
        public var stackSetName: kotlin.String? = null
        /**
         * The current status of the workspace.
         */
        public var status: aws.sdk.kotlin.services.grafana.model.WorkspaceStatus? = null
        /**
         * The list of tags associated with the workspace.
         */
        public var tags: Map<String, String>? = null
        /**
         * The configuration for connecting to data sources in a private VPC (Amazon Virtual Private Cloud).
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.grafana.model.VpcConfiguration? = null
        /**
         * The IAM role that grants permissions to the Amazon Web Services resources that the workspace will view data from. This role must already exist.
         */
        public var workspaceRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.grafana.model.WorkspaceDescription) : this() {
            this.accountAccessType = x.accountAccessType
            this.authentication = x.authentication
            this.created = x.created
            this.dataSources = x.dataSources
            this.description = x.description
            this.endpoint = x.endpoint
            this.freeTrialConsumed = x.freeTrialConsumed
            this.freeTrialExpiration = x.freeTrialExpiration
            this.grafanaVersion = x.grafanaVersion
            this.id = x.id
            this.licenseExpiration = x.licenseExpiration
            this.licenseType = x.licenseType
            this.modified = x.modified
            this.name = x.name
            this.networkAccessControl = x.networkAccessControl
            this.notificationDestinations = x.notificationDestinations
            this.organizationRoleName = x.organizationRoleName
            this.organizationalUnits = x.organizationalUnits
            this.permissionType = x.permissionType
            this.stackSetName = x.stackSetName
            this.status = x.status
            this.tags = x.tags
            this.vpcConfiguration = x.vpcConfiguration
            this.workspaceRoleArn = x.workspaceRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.grafana.model.WorkspaceDescription = WorkspaceDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.grafana.model.AuthenticationSummary] inside the given [block]
         */
        public fun authentication(block: aws.sdk.kotlin.services.grafana.model.AuthenticationSummary.Builder.() -> kotlin.Unit) {
            this.authentication = aws.sdk.kotlin.services.grafana.model.AuthenticationSummary.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration] inside the given [block]
         */
        public fun networkAccessControl(block: aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration.Builder.() -> kotlin.Unit) {
            this.networkAccessControl = aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.grafana.model.VpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.grafana.model.VpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.grafana.model.VpcConfiguration.invoke(block)
        }
    }
}
