// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.model



public class UpdateWorkspaceAuthenticationRequest private constructor(builder: Builder) {
    /**
     * Specifies whether this workspace uses SAML 2.0, IAM Identity Center (successor to Single Sign-On), or both to authenticate users for using the Grafana console within a workspace. For more information, see [User authentication in Amazon Managed Grafana](https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html).
     */
    public val authenticationProviders: List<AuthenticationProviderTypes>? = builder.authenticationProviders
    /**
     * If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the `Admin` and `Editor` roles in the workspace.
     */
    public val samlConfiguration: aws.sdk.kotlin.services.grafana.model.SamlConfiguration? = builder.samlConfiguration
    /**
     * The ID of the workspace to update the authentication for.
     */
    public val workspaceId: kotlin.String? = requireNotNull(builder.workspaceId) { "A non-null value must be provided for workspaceId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceAuthenticationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateWorkspaceAuthenticationRequest(")
        append("authenticationProviders=$authenticationProviders,")
        append("samlConfiguration=$samlConfiguration,")
        append("workspaceId=$workspaceId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = authenticationProviders?.hashCode() ?: 0
        result = 31 * result + (samlConfiguration?.hashCode() ?: 0)
        result = 31 * result + (workspaceId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateWorkspaceAuthenticationRequest

        if (authenticationProviders != other.authenticationProviders) return false
        if (samlConfiguration != other.samlConfiguration) return false
        if (workspaceId != other.workspaceId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceAuthenticationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies whether this workspace uses SAML 2.0, IAM Identity Center (successor to Single Sign-On), or both to authenticate users for using the Grafana console within a workspace. For more information, see [User authentication in Amazon Managed Grafana](https://docs.aws.amazon.com/grafana/latest/userguide/authentication-in-AMG.html).
         */
        public var authenticationProviders: List<AuthenticationProviderTypes>? = null
        /**
         * If the workspace uses SAML, use this structure to map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the `Admin` and `Editor` roles in the workspace.
         */
        public var samlConfiguration: aws.sdk.kotlin.services.grafana.model.SamlConfiguration? = null
        /**
         * The ID of the workspace to update the authentication for.
         */
        public var workspaceId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceAuthenticationRequest) : this() {
            this.authenticationProviders = x.authenticationProviders
            this.samlConfiguration = x.samlConfiguration
            this.workspaceId = x.workspaceId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceAuthenticationRequest = UpdateWorkspaceAuthenticationRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.grafana.model.SamlConfiguration] inside the given [block]
         */
        public fun samlConfiguration(block: aws.sdk.kotlin.services.grafana.model.SamlConfiguration.Builder.() -> kotlin.Unit) {
            this.samlConfiguration = aws.sdk.kotlin.services.grafana.model.SamlConfiguration.invoke(block)
        }
    }
}
