// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.grafana.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.grafana.endpoints.EndpointParameters
import aws.sdk.kotlin.services.grafana.endpoints.EndpointProvider
import aws.sdk.kotlin.services.grafana.model.AssociateLicenseRequest
import aws.sdk.kotlin.services.grafana.model.AssociateLicenseResponse
import aws.sdk.kotlin.services.grafana.model.CreateWorkspaceApiKeyRequest
import aws.sdk.kotlin.services.grafana.model.CreateWorkspaceApiKeyResponse
import aws.sdk.kotlin.services.grafana.model.CreateWorkspaceRequest
import aws.sdk.kotlin.services.grafana.model.CreateWorkspaceResponse
import aws.sdk.kotlin.services.grafana.model.DeleteWorkspaceApiKeyRequest
import aws.sdk.kotlin.services.grafana.model.DeleteWorkspaceApiKeyResponse
import aws.sdk.kotlin.services.grafana.model.DeleteWorkspaceRequest
import aws.sdk.kotlin.services.grafana.model.DeleteWorkspaceResponse
import aws.sdk.kotlin.services.grafana.model.DescribeWorkspaceAuthenticationRequest
import aws.sdk.kotlin.services.grafana.model.DescribeWorkspaceAuthenticationResponse
import aws.sdk.kotlin.services.grafana.model.DescribeWorkspaceConfigurationRequest
import aws.sdk.kotlin.services.grafana.model.DescribeWorkspaceConfigurationResponse
import aws.sdk.kotlin.services.grafana.model.DescribeWorkspaceRequest
import aws.sdk.kotlin.services.grafana.model.DescribeWorkspaceResponse
import aws.sdk.kotlin.services.grafana.model.DisassociateLicenseRequest
import aws.sdk.kotlin.services.grafana.model.DisassociateLicenseResponse
import aws.sdk.kotlin.services.grafana.model.ListPermissionsRequest
import aws.sdk.kotlin.services.grafana.model.ListPermissionsResponse
import aws.sdk.kotlin.services.grafana.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.grafana.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.grafana.model.ListVersionsRequest
import aws.sdk.kotlin.services.grafana.model.ListVersionsResponse
import aws.sdk.kotlin.services.grafana.model.ListWorkspacesRequest
import aws.sdk.kotlin.services.grafana.model.ListWorkspacesResponse
import aws.sdk.kotlin.services.grafana.model.TagResourceRequest
import aws.sdk.kotlin.services.grafana.model.TagResourceResponse
import aws.sdk.kotlin.services.grafana.model.UntagResourceRequest
import aws.sdk.kotlin.services.grafana.model.UntagResourceResponse
import aws.sdk.kotlin.services.grafana.model.UpdatePermissionsRequest
import aws.sdk.kotlin.services.grafana.model.UpdatePermissionsResponse
import aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceAuthenticationRequest
import aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceAuthenticationResponse
import aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceConfigurationRequest
import aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceConfigurationResponse
import aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceRequest
import aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "grafana"
public const val SdkVersion: String = "0.29.1-beta"

/**
 * Amazon Managed Grafana is a fully managed and secure data visualization service that you can use to instantly query, correlate, and visualize operational metrics, logs, and traces from multiple sources. Amazon Managed Grafana makes it easy to deploy, operate, and scale Grafana, a widely deployed data visualization tool that is popular for its extensible data support.
 *
 * With Amazon Managed Grafana, you create logically isolated Grafana servers called *workspaces*. In a workspace, you can create Grafana dashboards and visualizations to analyze your metrics, logs, and traces without having to build, package, or deploy any hardware to run Grafana servers.
 */
public interface GrafanaClient : SdkClient {
    /**
     * GrafanaClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, GrafanaClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, GrafanaClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): GrafanaClient = DefaultGrafanaClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "grafana"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [HttpAuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.HttpAuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Assigns a Grafana Enterprise license to a workspace. Upgrading to Grafana Enterprise incurs additional fees. For more information, see [Upgrade a workspace to Grafana Enterprise](https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html).
     */
    public suspend fun associateLicense(input: AssociateLicenseRequest): AssociateLicenseResponse

    /**
     * Creates a *workspace*. In a workspace, you can create Grafana dashboards and visualizations to analyze your metrics, logs, and traces. You don't have to build, package, or deploy any hardware to run the Grafana server.
     *
     * Don't use `CreateWorkspace` to modify an existing workspace. Instead, use [UpdateWorkspace](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspace.html).
     */
    public suspend fun createWorkspace(input: CreateWorkspaceRequest): CreateWorkspaceResponse

    /**
     * Creates a Grafana API key for the workspace. This key can be used to authenticate requests sent to the workspace's HTTP API. See [https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html](https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html) for available APIs and example requests.
     */
    public suspend fun createWorkspaceApiKey(input: CreateWorkspaceApiKeyRequest): CreateWorkspaceApiKeyResponse

    /**
     * Deletes an Amazon Managed Grafana workspace.
     */
    public suspend fun deleteWorkspace(input: DeleteWorkspaceRequest): DeleteWorkspaceResponse

    /**
     * Deletes a Grafana API key for the workspace.
     */
    public suspend fun deleteWorkspaceApiKey(input: DeleteWorkspaceApiKeyRequest): DeleteWorkspaceApiKeyResponse

    /**
     * Displays information about one Amazon Managed Grafana workspace.
     */
    public suspend fun describeWorkspace(input: DescribeWorkspaceRequest): DescribeWorkspaceResponse

    /**
     * Displays information about the authentication methods used in one Amazon Managed Grafana workspace.
     */
    public suspend fun describeWorkspaceAuthentication(input: DescribeWorkspaceAuthenticationRequest): DescribeWorkspaceAuthenticationResponse

    /**
     * Gets the current configuration string for the given workspace.
     */
    public suspend fun describeWorkspaceConfiguration(input: DescribeWorkspaceConfigurationRequest): DescribeWorkspaceConfigurationResponse

    /**
     * Removes the Grafana Enterprise license from a workspace.
     */
    public suspend fun disassociateLicense(input: DisassociateLicenseRequest): DisassociateLicenseResponse

    /**
     * Lists the users and groups who have the Grafana `Admin` and `Editor` roles in this workspace. If you use this operation without specifying `userId` or `groupId`, the operation returns the roles of all users and groups. If you specify a `userId` or a `groupId`, only the roles for that user or group are returned. If you do this, you can specify only one `userId` or one `groupId`.
     */
    public suspend fun listPermissions(input: ListPermissionsRequest): ListPermissionsResponse

    /**
     * The `ListTagsForResource` operation returns the tags that are associated with the Amazon Managed Service for Grafana resource specified by the `resourceArn`. Currently, the only resource that can be tagged is a workspace.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists available versions of Grafana. These are available when calling `CreateWorkspace`. Optionally, include a workspace to list the versions to which it can be upgraded.
     */
    public suspend fun listVersions(input: ListVersionsRequest = ListVersionsRequest {}): ListVersionsResponse

    /**
     * Returns a list of Amazon Managed Grafana workspaces in the account, with some information about each workspace. For more complete information about one workspace, use [DescribeWorkspace](https://docs.aws.amazon.com/AAMG/latest/APIReference/API_DescribeWorkspace.html).
     */
    public suspend fun listWorkspaces(input: ListWorkspacesRequest = ListWorkspacesRequest {}): ListWorkspacesResponse

    /**
     * The `TagResource` operation associates tags with an Amazon Managed Grafana resource. Currently, the only resource that can be tagged is workspaces.
     *
     * If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * The `UntagResource` operation removes the association of the tag with the Amazon Managed Grafana resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates which users in a workspace have the Grafana `Admin` or `Editor` roles.
     */
    public suspend fun updatePermissions(input: UpdatePermissionsRequest): UpdatePermissionsResponse

    /**
     * Modifies an existing Amazon Managed Grafana workspace. If you use this operation and omit any optional parameters, the existing values of those parameters are not changed.
     *
     * To modify the user authentication methods that the workspace uses, such as SAML or IAM Identity Center, use [UpdateWorkspaceAuthentication](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspaceAuthentication.html).
     *
     * To modify which users in the workspace have the `Admin` and `Editor` Grafana roles, use [UpdatePermissions](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html).
     */
    public suspend fun updateWorkspace(input: UpdateWorkspaceRequest): UpdateWorkspaceResponse

    /**
     * Use this operation to define the identity provider (IdP) that this workspace authenticates users from, using SAML. You can also map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the `Admin` and `Editor` roles in the workspace.
     *
     * Changes to the authentication method for a workspace may take a few minutes to take effect.
     */
    public suspend fun updateWorkspaceAuthentication(input: UpdateWorkspaceAuthenticationRequest): UpdateWorkspaceAuthenticationResponse

    /**
     * Updates the configuration string for the given workspace
     */
    public suspend fun updateWorkspaceConfiguration(input: UpdateWorkspaceConfigurationRequest): UpdateWorkspaceConfigurationResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun GrafanaClient.withConfig(block: GrafanaClient.Config.Builder.() -> Unit): GrafanaClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultGrafanaClient(newConfig)
}

/**
 * Assigns a Grafana Enterprise license to a workspace. Upgrading to Grafana Enterprise incurs additional fees. For more information, see [Upgrade a workspace to Grafana Enterprise](https://docs.aws.amazon.com/grafana/latest/userguide/upgrade-to-Grafana-Enterprise.html).
 */
public suspend inline fun GrafanaClient.associateLicense(crossinline block: AssociateLicenseRequest.Builder.() -> Unit): AssociateLicenseResponse = associateLicense(AssociateLicenseRequest.Builder().apply(block).build())

/**
 * Creates a *workspace*. In a workspace, you can create Grafana dashboards and visualizations to analyze your metrics, logs, and traces. You don't have to build, package, or deploy any hardware to run the Grafana server.
 *
 * Don't use `CreateWorkspace` to modify an existing workspace. Instead, use [UpdateWorkspace](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspace.html).
 */
public suspend inline fun GrafanaClient.createWorkspace(crossinline block: CreateWorkspaceRequest.Builder.() -> Unit): CreateWorkspaceResponse = createWorkspace(CreateWorkspaceRequest.Builder().apply(block).build())

/**
 * Creates a Grafana API key for the workspace. This key can be used to authenticate requests sent to the workspace's HTTP API. See [https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html](https://docs.aws.amazon.com/grafana/latest/userguide/Using-Grafana-APIs.html) for available APIs and example requests.
 */
public suspend inline fun GrafanaClient.createWorkspaceApiKey(crossinline block: CreateWorkspaceApiKeyRequest.Builder.() -> Unit): CreateWorkspaceApiKeyResponse = createWorkspaceApiKey(CreateWorkspaceApiKeyRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon Managed Grafana workspace.
 */
public suspend inline fun GrafanaClient.deleteWorkspace(crossinline block: DeleteWorkspaceRequest.Builder.() -> Unit): DeleteWorkspaceResponse = deleteWorkspace(DeleteWorkspaceRequest.Builder().apply(block).build())

/**
 * Deletes a Grafana API key for the workspace.
 */
public suspend inline fun GrafanaClient.deleteWorkspaceApiKey(crossinline block: DeleteWorkspaceApiKeyRequest.Builder.() -> Unit): DeleteWorkspaceApiKeyResponse = deleteWorkspaceApiKey(DeleteWorkspaceApiKeyRequest.Builder().apply(block).build())

/**
 * Displays information about one Amazon Managed Grafana workspace.
 */
public suspend inline fun GrafanaClient.describeWorkspace(crossinline block: DescribeWorkspaceRequest.Builder.() -> Unit): DescribeWorkspaceResponse = describeWorkspace(DescribeWorkspaceRequest.Builder().apply(block).build())

/**
 * Displays information about the authentication methods used in one Amazon Managed Grafana workspace.
 */
public suspend inline fun GrafanaClient.describeWorkspaceAuthentication(crossinline block: DescribeWorkspaceAuthenticationRequest.Builder.() -> Unit): DescribeWorkspaceAuthenticationResponse = describeWorkspaceAuthentication(DescribeWorkspaceAuthenticationRequest.Builder().apply(block).build())

/**
 * Gets the current configuration string for the given workspace.
 */
public suspend inline fun GrafanaClient.describeWorkspaceConfiguration(crossinline block: DescribeWorkspaceConfigurationRequest.Builder.() -> Unit): DescribeWorkspaceConfigurationResponse = describeWorkspaceConfiguration(DescribeWorkspaceConfigurationRequest.Builder().apply(block).build())

/**
 * Removes the Grafana Enterprise license from a workspace.
 */
public suspend inline fun GrafanaClient.disassociateLicense(crossinline block: DisassociateLicenseRequest.Builder.() -> Unit): DisassociateLicenseResponse = disassociateLicense(DisassociateLicenseRequest.Builder().apply(block).build())

/**
 * Lists the users and groups who have the Grafana `Admin` and `Editor` roles in this workspace. If you use this operation without specifying `userId` or `groupId`, the operation returns the roles of all users and groups. If you specify a `userId` or a `groupId`, only the roles for that user or group are returned. If you do this, you can specify only one `userId` or one `groupId`.
 */
public suspend inline fun GrafanaClient.listPermissions(crossinline block: ListPermissionsRequest.Builder.() -> Unit): ListPermissionsResponse = listPermissions(ListPermissionsRequest.Builder().apply(block).build())

/**
 * The `ListTagsForResource` operation returns the tags that are associated with the Amazon Managed Service for Grafana resource specified by the `resourceArn`. Currently, the only resource that can be tagged is a workspace.
 */
public suspend inline fun GrafanaClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists available versions of Grafana. These are available when calling `CreateWorkspace`. Optionally, include a workspace to list the versions to which it can be upgraded.
 */
public suspend inline fun GrafanaClient.listVersions(crossinline block: ListVersionsRequest.Builder.() -> Unit): ListVersionsResponse = listVersions(ListVersionsRequest.Builder().apply(block).build())

/**
 * Returns a list of Amazon Managed Grafana workspaces in the account, with some information about each workspace. For more complete information about one workspace, use [DescribeWorkspace](https://docs.aws.amazon.com/AAMG/latest/APIReference/API_DescribeWorkspace.html).
 */
public suspend inline fun GrafanaClient.listWorkspaces(crossinline block: ListWorkspacesRequest.Builder.() -> Unit): ListWorkspacesResponse = listWorkspaces(ListWorkspacesRequest.Builder().apply(block).build())

/**
 * The `TagResource` operation associates tags with an Amazon Managed Grafana resource. Currently, the only resource that can be tagged is workspaces.
 *
 * If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
 */
public suspend inline fun GrafanaClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * The `UntagResource` operation removes the association of the tag with the Amazon Managed Grafana resource.
 */
public suspend inline fun GrafanaClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates which users in a workspace have the Grafana `Admin` or `Editor` roles.
 */
public suspend inline fun GrafanaClient.updatePermissions(crossinline block: UpdatePermissionsRequest.Builder.() -> Unit): UpdatePermissionsResponse = updatePermissions(UpdatePermissionsRequest.Builder().apply(block).build())

/**
 * Modifies an existing Amazon Managed Grafana workspace. If you use this operation and omit any optional parameters, the existing values of those parameters are not changed.
 *
 * To modify the user authentication methods that the workspace uses, such as SAML or IAM Identity Center, use [UpdateWorkspaceAuthentication](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdateWorkspaceAuthentication.html).
 *
 * To modify which users in the workspace have the `Admin` and `Editor` Grafana roles, use [UpdatePermissions](https://docs.aws.amazon.com/grafana/latest/APIReference/API_UpdatePermissions.html).
 */
public suspend inline fun GrafanaClient.updateWorkspace(crossinline block: UpdateWorkspaceRequest.Builder.() -> Unit): UpdateWorkspaceResponse = updateWorkspace(UpdateWorkspaceRequest.Builder().apply(block).build())

/**
 * Use this operation to define the identity provider (IdP) that this workspace authenticates users from, using SAML. You can also map SAML assertion attributes to workspace user information and define which groups in the assertion attribute are to have the `Admin` and `Editor` roles in the workspace.
 *
 * Changes to the authentication method for a workspace may take a few minutes to take effect.
 */
public suspend inline fun GrafanaClient.updateWorkspaceAuthentication(crossinline block: UpdateWorkspaceAuthenticationRequest.Builder.() -> Unit): UpdateWorkspaceAuthenticationResponse = updateWorkspaceAuthentication(UpdateWorkspaceAuthenticationRequest.Builder().apply(block).build())

/**
 * Updates the configuration string for the given workspace
 */
public suspend inline fun GrafanaClient.updateWorkspaceConfiguration(crossinline block: UpdateWorkspaceConfigurationRequest.Builder.() -> Unit): UpdateWorkspaceConfigurationResponse = updateWorkspaceConfiguration(UpdateWorkspaceConfigurationRequest.Builder().apply(block).build())
