// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.serde

import aws.sdk.kotlin.services.grafana.model.DeleteWorkspaceServiceAccountTokenResponse
import aws.sdk.kotlin.services.grafana.model.GrafanaException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeleteWorkspaceServiceAccountTokenOperationDeserializer: HttpDeserializer.NonStreaming<DeleteWorkspaceServiceAccountTokenResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DeleteWorkspaceServiceAccountTokenResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDeleteWorkspaceServiceAccountTokenError(context, call, payload)
        }
        val builder = DeleteWorkspaceServiceAccountTokenResponse.Builder()

        if (payload != null) {
            deserializeDeleteWorkspaceServiceAccountTokenOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDeleteWorkspaceServiceAccountTokenError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GrafanaException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GrafanaException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeleteWorkspaceServiceAccountTokenOperationBody(builder: DeleteWorkspaceServiceAccountTokenResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val SERVICEACCOUNTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("serviceAccountId"))
    val TOKENID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("tokenId"))
    val WORKSPACEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("workspaceId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SERVICEACCOUNTID_DESCRIPTOR)
        field(TOKENID_DESCRIPTOR)
        field(WORKSPACEID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                SERVICEACCOUNTID_DESCRIPTOR.index -> builder.serviceAccountId = deserializeString()
                TOKENID_DESCRIPTOR.index -> builder.tokenId = deserializeString()
                WORKSPACEID_DESCRIPTOR.index -> builder.workspaceId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
