// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.paginators

import aws.sdk.kotlin.services.grafana.GrafanaClient
import aws.sdk.kotlin.services.grafana.model.ListPermissionsRequest
import aws.sdk.kotlin.services.grafana.model.ListPermissionsResponse
import aws.sdk.kotlin.services.grafana.model.ListVersionsRequest
import aws.sdk.kotlin.services.grafana.model.ListVersionsResponse
import aws.sdk.kotlin.services.grafana.model.ListWorkspaceServiceAccountTokensRequest
import aws.sdk.kotlin.services.grafana.model.ListWorkspaceServiceAccountTokensResponse
import aws.sdk.kotlin.services.grafana.model.ListWorkspaceServiceAccountsRequest
import aws.sdk.kotlin.services.grafana.model.ListWorkspaceServiceAccountsResponse
import aws.sdk.kotlin.services.grafana.model.ListWorkspacesRequest
import aws.sdk.kotlin.services.grafana.model.ListWorkspacesResponse
import aws.sdk.kotlin.services.grafana.model.PermissionEntry
import aws.sdk.kotlin.services.grafana.model.ServiceAccountSummary
import aws.sdk.kotlin.services.grafana.model.ServiceAccountTokenSummary
import aws.sdk.kotlin.services.grafana.model.WorkspaceSummary
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListPermissionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListPermissionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPermissionsResponse]
 */
public fun GrafanaClient.listPermissionsPaginated(initialRequest: ListPermissionsRequest): Flow<ListPermissionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listPermissionsPaginated.listPermissions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListPermissionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListPermissionsResponse]
 */
public fun GrafanaClient.listPermissionsPaginated(block: ListPermissionsRequest.Builder.() -> Unit): Flow<ListPermissionsResponse> =
    listPermissionsPaginated(ListPermissionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listPermissionsPaginated]
 * to access the nested member [PermissionEntry]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PermissionEntry]
 */
@JvmName("listPermissionsResponsePermissionEntry")
public fun Flow<ListPermissionsResponse>.permissions(): Flow<PermissionEntry> =
    transform() { response ->
        response.permissions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListVersionsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVersionsResponse]
 */
public fun GrafanaClient.listVersionsPaginated(initialRequest: ListVersionsRequest = ListVersionsRequest { }): Flow<ListVersionsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listVersionsPaginated.listVersions(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListVersionsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListVersionsResponse]
 */
public fun GrafanaClient.listVersionsPaginated(block: ListVersionsRequest.Builder.() -> Unit): Flow<ListVersionsResponse> =
    listVersionsPaginated(ListVersionsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listVersionsPaginated]
 * to access the nested member [GrafanaVersion]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GrafanaVersion]
 */
@JvmName("listVersionsResponseGrafanaVersion")
public fun Flow<ListVersionsResponse>.grafanaVersions(): Flow<String> =
    transform() { response ->
        response.grafanaVersions?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWorkspacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkspacesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkspacesResponse]
 */
public fun GrafanaClient.listWorkspacesPaginated(initialRequest: ListWorkspacesRequest = ListWorkspacesRequest { }): Flow<ListWorkspacesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkspacesPaginated.listWorkspaces(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkspacesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkspacesResponse]
 */
public fun GrafanaClient.listWorkspacesPaginated(block: ListWorkspacesRequest.Builder.() -> Unit): Flow<ListWorkspacesResponse> =
    listWorkspacesPaginated(ListWorkspacesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWorkspacesPaginated]
 * to access the nested member [WorkspaceSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [WorkspaceSummary]
 */
@JvmName("listWorkspacesResponseWorkspaceSummary")
public fun Flow<ListWorkspacesResponse>.workspaces(): Flow<WorkspaceSummary> =
    transform() { response ->
        response.workspaces?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWorkspaceServiceAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkspaceServiceAccountsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkspaceServiceAccountsResponse]
 */
public fun GrafanaClient.listWorkspaceServiceAccountsPaginated(initialRequest: ListWorkspaceServiceAccountsRequest): Flow<ListWorkspaceServiceAccountsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkspaceServiceAccountsPaginated.listWorkspaceServiceAccounts(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkspaceServiceAccountsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkspaceServiceAccountsResponse]
 */
public fun GrafanaClient.listWorkspaceServiceAccountsPaginated(block: ListWorkspaceServiceAccountsRequest.Builder.() -> Unit): Flow<ListWorkspaceServiceAccountsResponse> =
    listWorkspaceServiceAccountsPaginated(ListWorkspaceServiceAccountsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWorkspaceServiceAccountsPaginated]
 * to access the nested member [ServiceAccountSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServiceAccountSummary]
 */
@JvmName("listWorkspaceServiceAccountsResponseServiceAccountSummary")
public fun Flow<ListWorkspaceServiceAccountsResponse>.serviceAccounts(): Flow<ServiceAccountSummary> =
    transform() { response ->
        response.serviceAccounts?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListWorkspaceServiceAccountTokensResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListWorkspaceServiceAccountTokensRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkspaceServiceAccountTokensResponse]
 */
public fun GrafanaClient.listWorkspaceServiceAccountTokensPaginated(initialRequest: ListWorkspaceServiceAccountTokensRequest): Flow<ListWorkspaceServiceAccountTokensResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listWorkspaceServiceAccountTokensPaginated.listWorkspaceServiceAccountTokens(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListWorkspaceServiceAccountTokensResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListWorkspaceServiceAccountTokensResponse]
 */
public fun GrafanaClient.listWorkspaceServiceAccountTokensPaginated(block: ListWorkspaceServiceAccountTokensRequest.Builder.() -> Unit): Flow<ListWorkspaceServiceAccountTokensResponse> =
    listWorkspaceServiceAccountTokensPaginated(ListWorkspaceServiceAccountTokensRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listWorkspaceServiceAccountTokensPaginated]
 * to access the nested member [ServiceAccountTokenSummary]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ServiceAccountTokenSummary]
 */
@JvmName("listWorkspaceServiceAccountTokensResponseServiceAccountTokenSummary")
public fun Flow<ListWorkspaceServiceAccountTokensResponse>.serviceAccountTokens(): Flow<ServiceAccountTokenSummary> =
    transform() { response ->
        response.serviceAccountTokens?.forEach {
            emit(it)
        }
    }
