// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.
 *
 * Provided `securityGroupIds` and `subnetIds` must be part of the same VPC.
 *
 * Connecting to a private VPC is not yet available in the Asia Pacific (Seoul) Region (ap-northeast-2).
 */
public class VpcConfiguration private constructor(builder: Builder) {
    /**
     * The list of Amazon EC2 security group IDs attached to the Amazon VPC for your Grafana workspace to connect. Duplicates not allowed.
     */
    public val securityGroupIds: List<String> = requireNotNull(builder.securityGroupIds) { "A non-null value must be provided for securityGroupIds" }
    /**
     * The list of Amazon EC2 subnet IDs created in the Amazon VPC for your Grafana workspace to connect. Duplicates not allowed.
     */
    public val subnetIds: List<String> = requireNotNull(builder.subnetIds) { "A non-null value must be provided for subnetIds" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.grafana.model.VpcConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("VpcConfiguration(")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = securityGroupIds.hashCode()
        result = 31 * result + (subnetIds.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as VpcConfiguration

        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.grafana.model.VpcConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The list of Amazon EC2 security group IDs attached to the Amazon VPC for your Grafana workspace to connect. Duplicates not allowed.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * The list of Amazon EC2 subnet IDs created in the Amazon VPC for your Grafana workspace to connect. Duplicates not allowed.
         */
        public var subnetIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.grafana.model.VpcConfiguration) : this() {
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.grafana.model.VpcConfiguration = VpcConfiguration(this)

        internal fun correctErrors(): Builder {
            if (securityGroupIds == null) securityGroupIds = emptyList()
            if (subnetIds == null) subnetIds = emptyList()
            return this
        }
    }
}
