// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateWorkspaceRequest private constructor(builder: Builder) {
    /**
     * Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If you specify `ORGANIZATION`, you must specify which organizational units the workspace can access in the `workspaceOrganizationalUnits` parameter.
     */
    public val accountAccessType: aws.sdk.kotlin.services.grafana.model.AccountAccessType? = builder.accountAccessType
    /**
     * The configuration settings for network access to your workspace.
     *
     * When this is configured, only listed IP addresses and VPC endpoints will be able to access your workspace. Standard Grafana authentication and authorization will still be required.
     *
     * If this is not configured, or is removed, then all IP addresses and VPC endpoints will be allowed. Standard Grafana authentication and authorization will still be required.
     */
    public val networkAccessControl: aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration? = builder.networkAccessControl
    /**
     * The name of an IAM role that already exists to use to access resources through Organizations. This can only be used with a workspace that has the `permissionType` set to `CUSTOMER_MANAGED`.
     */
    public val organizationRoleName: kotlin.String? = builder.organizationRoleName
    /**
     * Use this parameter if you want to change a workspace from `SERVICE_MANAGED` to `CUSTOMER_MANAGED`. This allows you to manage the permissions that the workspace uses to access datasources and notification channels. If the workspace is in a member Amazon Web Services account of an organization, and that account is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, you must choose `CUSTOMER_MANAGED`.
     *
     * If you specify this as `CUSTOMER_MANAGED`, you must also specify a `workspaceRoleArn` that the workspace will use for accessing Amazon Web Services resources.
     *
     * For more information on the role and permissions needed, see [Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html)
     *
     * Do not use this to convert a `CUSTOMER_MANAGED` workspace to `SERVICE_MANAGED`. Do not include this parameter if you want to leave the workspace as `SERVICE_MANAGED`.
     *
     * You can convert a `CUSTOMER_MANAGED` workspace to `SERVICE_MANAGED` using the Amazon Managed Grafana console. For more information, see [Managing permissions for data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-datasource-and-notification.html).
     */
    public val permissionType: aws.sdk.kotlin.services.grafana.model.PermissionType? = builder.permissionType
    /**
     * Whether to remove the network access configuration from the workspace.
     *
     * Setting this to `true` and providing a `networkAccessControl` to set will return an error.
     *
     * If you remove this configuration by setting this to `true`, then all IP addresses and VPC endpoints will be allowed. Standard Grafana authentication and authorization will still be required.
     */
    public val removeNetworkAccessConfiguration: kotlin.Boolean? = builder.removeNetworkAccessConfiguration
    /**
     * Whether to remove the VPC configuration from the workspace.
     *
     * Setting this to `true` and providing a `vpcConfiguration` to set will return an error.
     */
    public val removeVpcConfiguration: kotlin.Boolean? = builder.removeVpcConfiguration
    /**
     * The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.
     */
    public val stackSetName: kotlin.String? = builder.stackSetName
    /**
     * The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.
     */
    public val vpcConfiguration: aws.sdk.kotlin.services.grafana.model.VpcConfiguration? = builder.vpcConfiguration
    /**
     * This parameter is for internal use only, and should not be used.
     */
    public val workspaceDataSources: List<DataSourceType>? = builder.workspaceDataSources
    /**
     * A description for the workspace. This is used only to help you identify this workspace.
     */
    public val workspaceDescription: kotlin.String? = builder.workspaceDescription
    /**
     * The ID of the workspace to update.
     */
    public val workspaceId: kotlin.String = requireNotNull(builder.workspaceId) { "A non-null value must be provided for workspaceId" }
    /**
     * A new name for the workspace to update.
     */
    public val workspaceName: kotlin.String? = builder.workspaceName
    /**
     * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to use these channels.
     */
    public val workspaceNotificationDestinations: List<NotificationDestinationType>? = builder.workspaceNotificationDestinations
    /**
     * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.
     */
    public val workspaceOrganizationalUnits: List<String>? = builder.workspaceOrganizationalUnits
    /**
     * Specifies an IAM role that grants permissions to Amazon Web Services resources that the workspace accesses, such as data sources and notification channels. If this workspace has `permissionType``CUSTOMER_MANAGED`, then this role is required.
     */
    public val workspaceRoleArn: kotlin.String? = builder.workspaceRoleArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateWorkspaceRequest(")
        append("accountAccessType=$accountAccessType,")
        append("networkAccessControl=$networkAccessControl,")
        append("organizationRoleName=*** Sensitive Data Redacted ***,")
        append("permissionType=$permissionType,")
        append("removeNetworkAccessConfiguration=$removeNetworkAccessConfiguration,")
        append("removeVpcConfiguration=$removeVpcConfiguration,")
        append("stackSetName=$stackSetName,")
        append("vpcConfiguration=$vpcConfiguration,")
        append("workspaceDataSources=$workspaceDataSources,")
        append("workspaceDescription=*** Sensitive Data Redacted ***,")
        append("workspaceId=$workspaceId,")
        append("workspaceName=*** Sensitive Data Redacted ***,")
        append("workspaceNotificationDestinations=$workspaceNotificationDestinations,")
        append("workspaceOrganizationalUnits=*** Sensitive Data Redacted ***,")
        append("workspaceRoleArn=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountAccessType?.hashCode() ?: 0
        result = 31 * result + (networkAccessControl?.hashCode() ?: 0)
        result = 31 * result + (organizationRoleName?.hashCode() ?: 0)
        result = 31 * result + (permissionType?.hashCode() ?: 0)
        result = 31 * result + (removeNetworkAccessConfiguration?.hashCode() ?: 0)
        result = 31 * result + (removeVpcConfiguration?.hashCode() ?: 0)
        result = 31 * result + (stackSetName?.hashCode() ?: 0)
        result = 31 * result + (vpcConfiguration?.hashCode() ?: 0)
        result = 31 * result + (workspaceDataSources?.hashCode() ?: 0)
        result = 31 * result + (workspaceDescription?.hashCode() ?: 0)
        result = 31 * result + (workspaceId.hashCode())
        result = 31 * result + (workspaceName?.hashCode() ?: 0)
        result = 31 * result + (workspaceNotificationDestinations?.hashCode() ?: 0)
        result = 31 * result + (workspaceOrganizationalUnits?.hashCode() ?: 0)
        result = 31 * result + (workspaceRoleArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateWorkspaceRequest

        if (accountAccessType != other.accountAccessType) return false
        if (networkAccessControl != other.networkAccessControl) return false
        if (organizationRoleName != other.organizationRoleName) return false
        if (permissionType != other.permissionType) return false
        if (removeNetworkAccessConfiguration != other.removeNetworkAccessConfiguration) return false
        if (removeVpcConfiguration != other.removeVpcConfiguration) return false
        if (stackSetName != other.stackSetName) return false
        if (vpcConfiguration != other.vpcConfiguration) return false
        if (workspaceDataSources != other.workspaceDataSources) return false
        if (workspaceDescription != other.workspaceDescription) return false
        if (workspaceId != other.workspaceId) return false
        if (workspaceName != other.workspaceName) return false
        if (workspaceNotificationDestinations != other.workspaceNotificationDestinations) return false
        if (workspaceOrganizationalUnits != other.workspaceOrganizationalUnits) return false
        if (workspaceRoleArn != other.workspaceRoleArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether the workspace can access Amazon Web Services resources in this Amazon Web Services account only, or whether it can also access Amazon Web Services resources in other accounts in the same organization. If you specify `ORGANIZATION`, you must specify which organizational units the workspace can access in the `workspaceOrganizationalUnits` parameter.
         */
        public var accountAccessType: aws.sdk.kotlin.services.grafana.model.AccountAccessType? = null
        /**
         * The configuration settings for network access to your workspace.
         *
         * When this is configured, only listed IP addresses and VPC endpoints will be able to access your workspace. Standard Grafana authentication and authorization will still be required.
         *
         * If this is not configured, or is removed, then all IP addresses and VPC endpoints will be allowed. Standard Grafana authentication and authorization will still be required.
         */
        public var networkAccessControl: aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration? = null
        /**
         * The name of an IAM role that already exists to use to access resources through Organizations. This can only be used with a workspace that has the `permissionType` set to `CUSTOMER_MANAGED`.
         */
        public var organizationRoleName: kotlin.String? = null
        /**
         * Use this parameter if you want to change a workspace from `SERVICE_MANAGED` to `CUSTOMER_MANAGED`. This allows you to manage the permissions that the workspace uses to access datasources and notification channels. If the workspace is in a member Amazon Web Services account of an organization, and that account is not a delegated administrator account, and you want the workspace to access data sources in other Amazon Web Services accounts in the organization, you must choose `CUSTOMER_MANAGED`.
         *
         * If you specify this as `CUSTOMER_MANAGED`, you must also specify a `workspaceRoleArn` that the workspace will use for accessing Amazon Web Services resources.
         *
         * For more information on the role and permissions needed, see [Amazon Managed Grafana permissions and policies for Amazon Web Services data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-manage-permissions.html)
         *
         * Do not use this to convert a `CUSTOMER_MANAGED` workspace to `SERVICE_MANAGED`. Do not include this parameter if you want to leave the workspace as `SERVICE_MANAGED`.
         *
         * You can convert a `CUSTOMER_MANAGED` workspace to `SERVICE_MANAGED` using the Amazon Managed Grafana console. For more information, see [Managing permissions for data sources and notification channels](https://docs.aws.amazon.com/grafana/latest/userguide/AMG-datasource-and-notification.html).
         */
        public var permissionType: aws.sdk.kotlin.services.grafana.model.PermissionType? = null
        /**
         * Whether to remove the network access configuration from the workspace.
         *
         * Setting this to `true` and providing a `networkAccessControl` to set will return an error.
         *
         * If you remove this configuration by setting this to `true`, then all IP addresses and VPC endpoints will be allowed. Standard Grafana authentication and authorization will still be required.
         */
        public var removeNetworkAccessConfiguration: kotlin.Boolean? = null
        /**
         * Whether to remove the VPC configuration from the workspace.
         *
         * Setting this to `true` and providing a `vpcConfiguration` to set will return an error.
         */
        public var removeVpcConfiguration: kotlin.Boolean? = null
        /**
         * The name of the CloudFormation stack set to use to generate IAM roles to be used for this workspace.
         */
        public var stackSetName: kotlin.String? = null
        /**
         * The configuration settings for an Amazon VPC that contains data sources for your Grafana workspace to connect to.
         */
        public var vpcConfiguration: aws.sdk.kotlin.services.grafana.model.VpcConfiguration? = null
        /**
         * This parameter is for internal use only, and should not be used.
         */
        public var workspaceDataSources: List<DataSourceType>? = null
        /**
         * A description for the workspace. This is used only to help you identify this workspace.
         */
        public var workspaceDescription: kotlin.String? = null
        /**
         * The ID of the workspace to update.
         */
        public var workspaceId: kotlin.String? = null
        /**
         * A new name for the workspace to update.
         */
        public var workspaceName: kotlin.String? = null
        /**
         * Specify the Amazon Web Services notification channels that you plan to use in this workspace. Specifying these data sources here enables Amazon Managed Grafana to create IAM roles and permissions that allow Amazon Managed Grafana to use these channels.
         */
        public var workspaceNotificationDestinations: List<NotificationDestinationType>? = null
        /**
         * Specifies the organizational units that this workspace is allowed to use data sources from, if this workspace is in an account that is part of an organization.
         */
        public var workspaceOrganizationalUnits: List<String>? = null
        /**
         * Specifies an IAM role that grants permissions to Amazon Web Services resources that the workspace accesses, such as data sources and notification channels. If this workspace has `permissionType``CUSTOMER_MANAGED`, then this role is required.
         */
        public var workspaceRoleArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceRequest) : this() {
            this.accountAccessType = x.accountAccessType
            this.networkAccessControl = x.networkAccessControl
            this.organizationRoleName = x.organizationRoleName
            this.permissionType = x.permissionType
            this.removeNetworkAccessConfiguration = x.removeNetworkAccessConfiguration
            this.removeVpcConfiguration = x.removeVpcConfiguration
            this.stackSetName = x.stackSetName
            this.vpcConfiguration = x.vpcConfiguration
            this.workspaceDataSources = x.workspaceDataSources
            this.workspaceDescription = x.workspaceDescription
            this.workspaceId = x.workspaceId
            this.workspaceName = x.workspaceName
            this.workspaceNotificationDestinations = x.workspaceNotificationDestinations
            this.workspaceOrganizationalUnits = x.workspaceOrganizationalUnits
            this.workspaceRoleArn = x.workspaceRoleArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.grafana.model.UpdateWorkspaceRequest = UpdateWorkspaceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration] inside the given [block]
         */
        public fun networkAccessControl(block: aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration.Builder.() -> kotlin.Unit) {
            this.networkAccessControl = aws.sdk.kotlin.services.grafana.model.NetworkAccessConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.grafana.model.VpcConfiguration] inside the given [block]
         */
        public fun vpcConfiguration(block: aws.sdk.kotlin.services.grafana.model.VpcConfiguration.Builder.() -> kotlin.Unit) {
            this.vpcConfiguration = aws.sdk.kotlin.services.grafana.model.VpcConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (workspaceId == null) workspaceId = ""
            return this
        }
    }
}
