// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A structure that contains the information about a service account token.
 */
public class ServiceAccountTokenSummary private constructor(builder: Builder) {
    /**
     * When the service account token was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.createdAt) { "A non-null value must be provided for createdAt" }
    /**
     * When the service account token will expire.
     */
    public val expiresAt: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.expiresAt) { "A non-null value must be provided for expiresAt" }
    /**
     * The unique ID of the service account token.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The last time the token was used to authorize a Grafana HTTP API.
     */
    public val lastUsedAt: aws.smithy.kotlin.runtime.time.Instant? = builder.lastUsedAt
    /**
     * The name of the service account token.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.grafana.model.ServiceAccountTokenSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceAccountTokenSummary(")
        append("createdAt=$createdAt,")
        append("expiresAt=$expiresAt,")
        append("id=$id,")
        append("lastUsedAt=$lastUsedAt,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = createdAt.hashCode()
        result = 31 * result + (expiresAt.hashCode())
        result = 31 * result + (id.hashCode())
        result = 31 * result + (lastUsedAt?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceAccountTokenSummary

        if (createdAt != other.createdAt) return false
        if (expiresAt != other.expiresAt) return false
        if (id != other.id) return false
        if (lastUsedAt != other.lastUsedAt) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.grafana.model.ServiceAccountTokenSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * When the service account token was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * When the service account token will expire.
         */
        public var expiresAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The unique ID of the service account token.
         */
        public var id: kotlin.String? = null
        /**
         * The last time the token was used to authorize a Grafana HTTP API.
         */
        public var lastUsedAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the service account token.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.grafana.model.ServiceAccountTokenSummary) : this() {
            this.createdAt = x.createdAt
            this.expiresAt = x.expiresAt
            this.id = x.id
            this.lastUsedAt = x.lastUsedAt
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.grafana.model.ServiceAccountTokenSummary = ServiceAccountTokenSummary(this)

        internal fun correctErrors(): Builder {
            if (createdAt == null) createdAt = Instant.fromEpochSeconds(0)
            if (expiresAt == null) expiresAt = Instant.fromEpochSeconds(0)
            if (id == null) id = ""
            if (name == null) name = ""
            return this
        }
    }
}
