// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.model

import aws.smithy.kotlin.runtime.ErrorMetadata
import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.ServiceErrorMetadata

/**
 * The request was denied because of request throttling. Retry the request.
 */
public class ThrottlingException private constructor(builder: Builder) : GrafanaException(builder.message) {

    /**
     * The ID of the service quota that was exceeded.
     */
    public val quotaCode: kotlin.String? = builder.quotaCode
    /**
     * The value of a parameter in the request caused an error.
     */
    public val retryAfterSeconds: kotlin.Int? = builder.retryAfterSeconds
    /**
     * The ID of the service that is associated with the error.
     */
    public val serviceCode: kotlin.String? = builder.serviceCode

    init {
        sdkErrorMetadata.attributes[ErrorMetadata.Retryable] = true
        sdkErrorMetadata.attributes[ErrorMetadata.ThrottlingError] = false
        sdkErrorMetadata.attributes[ServiceErrorMetadata.ErrorType] = ErrorType.Client
    }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.grafana.model.ThrottlingException = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ThrottlingException(")
        append("message=$message,")
        append("quotaCode=$quotaCode,")
        append("retryAfterSeconds=$retryAfterSeconds,")
        append("serviceCode=$serviceCode")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = message.hashCode()
        result = 31 * result + (quotaCode?.hashCode() ?: 0)
        result = 31 * result + (retryAfterSeconds ?: 0)
        result = 31 * result + (serviceCode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ThrottlingException

        if (message != other.message) return false
        if (quotaCode != other.quotaCode) return false
        if (retryAfterSeconds != other.retryAfterSeconds) return false
        if (serviceCode != other.serviceCode) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.grafana.model.ThrottlingException = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A description of the error.
         */
        public var message: kotlin.String? = null
        /**
         * The ID of the service quota that was exceeded.
         */
        public var quotaCode: kotlin.String? = null
        /**
         * The value of a parameter in the request caused an error.
         */
        public var retryAfterSeconds: kotlin.Int? = null
        /**
         * The ID of the service that is associated with the error.
         */
        public var serviceCode: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.grafana.model.ThrottlingException) : this() {
            this.message = x.message
            this.quotaCode = x.quotaCode
            this.retryAfterSeconds = x.retryAfterSeconds
            this.serviceCode = x.serviceCode
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.grafana.model.ThrottlingException = ThrottlingException(this)

        internal fun correctErrors(): Builder {
            if (message == null) message = ""
            return this
        }
    }
}
