// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.grafana.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A structure that contains the information about a service account token.
 *
 * This structure is returned when creating the token. It is important to store the `key` that is returned, as it is not retrievable at a later time.
 *
 * If you lose the key, you can delete and recreate the token, which will create a new key.
 */
public class ServiceAccountTokenSummaryWithKey private constructor(builder: Builder) {
    /**
     * The unique ID of the service account token.
     */
    public val id: kotlin.String = requireNotNull(builder.id) { "A non-null value must be provided for id" }
    /**
     * The key for the service account token. Used when making calls to the Grafana HTTP APIs to authenticate and authorize the requests.
     */
    public val key: kotlin.String = requireNotNull(builder.key) { "A non-null value must be provided for key" }
    /**
     * The name of the service account token.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.grafana.model.ServiceAccountTokenSummaryWithKey = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ServiceAccountTokenSummaryWithKey(")
        append("id=$id,")
        append("key=*** Sensitive Data Redacted ***,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = id.hashCode()
        result = 31 * result + (key.hashCode())
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ServiceAccountTokenSummaryWithKey

        if (id != other.id) return false
        if (key != other.key) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.grafana.model.ServiceAccountTokenSummaryWithKey = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The unique ID of the service account token.
         */
        public var id: kotlin.String? = null
        /**
         * The key for the service account token. Used when making calls to the Grafana HTTP APIs to authenticate and authorize the requests.
         */
        public var key: kotlin.String? = null
        /**
         * The name of the service account token.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.grafana.model.ServiceAccountTokenSummaryWithKey) : this() {
            this.id = x.id
            this.key = x.key
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.grafana.model.ServiceAccountTokenSummaryWithKey = ServiceAccountTokenSummaryWithKey(this)

        internal fun correctErrors(): Builder {
            if (id == null) id = ""
            if (key == null) key = ""
            if (name == null) name = ""
            return this
        }
    }
}
