// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.globalaccelerator.model.ByoipCidr
import aws.sdk.kotlin.services.globalaccelerator.model.GlobalAcceleratorException
import aws.sdk.kotlin.services.globalaccelerator.model.WithdrawByoipCidrResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class WithdrawByoipCidrOperationDeserializer: HttpDeserialize<WithdrawByoipCidrResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): WithdrawByoipCidrResponse {
        if (!response.status.isSuccess()) {
            throwWithdrawByoipCidrError(context, response)
        }
        val builder = WithdrawByoipCidrResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeWithdrawByoipCidrOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeWithdrawByoipCidrOperationBody(builder: WithdrawByoipCidrResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BYOIPCIDR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ByoipCidr"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BYOIPCIDR_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BYOIPCIDR_DESCRIPTOR.index -> builder.byoipCidr = deserializeByoipCidrDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwWithdrawByoipCidrError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GlobalAcceleratorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer()
        "ByoipCidrNotFoundException" -> ByoipCidrNotFoundExceptionDeserializer()
        "IncorrectCidrStateException" -> IncorrectCidrStateExceptionDeserializer()
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer()
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer()
        else -> throw GlobalAcceleratorException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
