// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingListener
import aws.sdk.kotlin.services.globalaccelerator.model.GlobalAcceleratorException
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingListenersResponse
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ListCustomRoutingListenersOperationDeserializer: HttpDeserialize<ListCustomRoutingListenersResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListCustomRoutingListenersResponse {
        if (!response.status.isSuccess()) {
            throwListCustomRoutingListenersError(context, response)
        }
        val builder = ListCustomRoutingListenersResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListCustomRoutingListenersOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeListCustomRoutingListenersOperationBody(builder: ListCustomRoutingListenersResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val LISTENERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Listeners"))
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(LISTENERS_DESCRIPTOR)
        field(NEXTTOKEN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                LISTENERS_DESCRIPTOR.index -> builder.listeners =
                    deserializer.deserializeList(LISTENERS_DESCRIPTOR) {
                        val col0 = mutableListOf<CustomRoutingListener>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCustomRoutingListenerDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwListCustomRoutingListenersError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GlobalAcceleratorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AcceleratorNotFoundException" -> AcceleratorNotFoundExceptionDeserializer()
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer()
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer()
        "InvalidNextTokenException" -> InvalidNextTokenExceptionDeserializer()
        else -> throw GlobalAcceleratorException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
