// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorResponse
import aws.sdk.kotlin.services.globalaccelerator.model.GlobalAcceleratorException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class DeleteCustomRoutingAcceleratorOperationDeserializer: HttpDeserialize<DeleteCustomRoutingAcceleratorResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteCustomRoutingAcceleratorResponse {
        if (!response.status.isSuccess()) {
            throwDeleteCustomRoutingAcceleratorError(context, response)
        }
        val builder = DeleteCustomRoutingAcceleratorResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDeleteCustomRoutingAcceleratorError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GlobalAcceleratorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AcceleratorNotDisabledException" -> AcceleratorNotDisabledExceptionDeserializer()
        "AcceleratorNotFoundException" -> AcceleratorNotFoundExceptionDeserializer()
        "AssociatedListenerFoundException" -> AssociatedListenerFoundExceptionDeserializer()
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer()
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer()
        else -> throw GlobalAcceleratorException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
