// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse
import aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingEndpointGroup
import aws.sdk.kotlin.services.globalaccelerator.model.GlobalAcceleratorException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateCustomRoutingEndpointGroupOperationDeserializer: HttpDeserialize<CreateCustomRoutingEndpointGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): CreateCustomRoutingEndpointGroupResponse {
        if (!response.status.isSuccess()) {
            throwCreateCustomRoutingEndpointGroupError(context, response)
        }
        val builder = CreateCustomRoutingEndpointGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeCreateCustomRoutingEndpointGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private fun deserializeCreateCustomRoutingEndpointGroupOperationBody(builder: CreateCustomRoutingEndpointGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENDPOINTGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EndpointGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDPOINTGROUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENDPOINTGROUP_DESCRIPTOR.index -> builder.endpointGroup = deserializeCustomRoutingEndpointGroupDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwCreateCustomRoutingEndpointGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GlobalAcceleratorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "AcceleratorNotFoundException" -> AcceleratorNotFoundExceptionDeserializer()
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer()
        "EndpointGroupAlreadyExistsException" -> EndpointGroupAlreadyExistsExceptionDeserializer()
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer()
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer()
        "InvalidPortRangeException" -> InvalidPortRangeExceptionDeserializer()
        "LimitExceededException" -> LimitExceededExceptionDeserializer()
        "ListenerNotFoundException" -> ListenerNotFoundExceptionDeserializer()
        else -> throw GlobalAcceleratorException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
