// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.paginators

import aws.sdk.kotlin.services.globalaccelerator.GlobalAcceleratorClient
import aws.sdk.kotlin.services.globalaccelerator.model.ListAcceleratorsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListAcceleratorsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListByoipCidrsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListByoipCidrsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingListenersRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingListenersResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListEndpointGroupsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListEndpointGroupsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListListenersRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListListenersResponse
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow


/**
 * Paginate over [ListAcceleratorsResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListAcceleratorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAcceleratorsResponse]
 */
fun GlobalAcceleratorClient.listAcceleratorsPaginated(initialRequest: ListAcceleratorsRequest): Flow<ListAcceleratorsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAcceleratorsPaginated.listAccelerators(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListByoipCidrsResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListByoipCidrsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListByoipCidrsResponse]
 */
fun GlobalAcceleratorClient.listByoipCidrsPaginated(initialRequest: ListByoipCidrsRequest): Flow<ListByoipCidrsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listByoipCidrsPaginated.listByoipCidrs(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCustomRoutingAcceleratorsResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListCustomRoutingAcceleratorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomRoutingAcceleratorsResponse]
 */
fun GlobalAcceleratorClient.listCustomRoutingAcceleratorsPaginated(initialRequest: ListCustomRoutingAcceleratorsRequest): Flow<ListCustomRoutingAcceleratorsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCustomRoutingAcceleratorsPaginated.listCustomRoutingAccelerators(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCustomRoutingEndpointGroupsResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListCustomRoutingEndpointGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomRoutingEndpointGroupsResponse]
 */
fun GlobalAcceleratorClient.listCustomRoutingEndpointGroupsPaginated(initialRequest: ListCustomRoutingEndpointGroupsRequest): Flow<ListCustomRoutingEndpointGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCustomRoutingEndpointGroupsPaginated.listCustomRoutingEndpointGroups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCustomRoutingListenersResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListCustomRoutingListenersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomRoutingListenersResponse]
 */
fun GlobalAcceleratorClient.listCustomRoutingListenersPaginated(initialRequest: ListCustomRoutingListenersRequest): Flow<ListCustomRoutingListenersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCustomRoutingListenersPaginated.listCustomRoutingListeners(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCustomRoutingPortMappingsResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListCustomRoutingPortMappingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomRoutingPortMappingsResponse]
 */
fun GlobalAcceleratorClient.listCustomRoutingPortMappingsPaginated(initialRequest: ListCustomRoutingPortMappingsRequest): Flow<ListCustomRoutingPortMappingsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCustomRoutingPortMappingsPaginated.listCustomRoutingPortMappings(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListCustomRoutingPortMappingsByDestinationResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListCustomRoutingPortMappingsByDestinationRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomRoutingPortMappingsByDestinationResponse]
 */
fun GlobalAcceleratorClient.listCustomRoutingPortMappingsByDestinationPaginated(initialRequest: ListCustomRoutingPortMappingsByDestinationRequest): Flow<ListCustomRoutingPortMappingsByDestinationResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCustomRoutingPortMappingsByDestinationPaginated.listCustomRoutingPortMappingsByDestination(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListEndpointGroupsResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListEndpointGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEndpointGroupsResponse]
 */
fun GlobalAcceleratorClient.listEndpointGroupsPaginated(initialRequest: ListEndpointGroupsRequest): Flow<ListEndpointGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEndpointGroupsPaginated.listEndpointGroups(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }

/**
 * Paginate over [ListListenersResponse] results.
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service calls are
 * made until the flow is collected. This also means there is no guarantee that the request is valid until then. Once
 * you start collecting the flow, the SDK will lazily load response pages by making service calls until there are no
 * pages left or the flow is cancelled. If there are errors in your request, you will see the failures only after you start
 * collection.
 * @param initialRequest A [ListListenersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListListenersResponse]
 */
fun GlobalAcceleratorClient.listListenersPaginated(initialRequest: ListListenersRequest): Flow<ListListenersResponse> =
    flow {
        var cursor: kotlin.String? = null
        var isFirstPage: Boolean = true

        while (isFirstPage || (cursor?.isNotEmpty() == true)) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listListenersPaginated.listListeners(req)
            isFirstPage = false
            cursor = result.nextToken
            emit(result)
        }
    }
