// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model



/**
 * A complex type for the endpoint group. An AWS Region can have only one endpoint group for a specific listener.
 */
class EndpointGroup private constructor(builder: Builder) {
    /**
     * The list of endpoint objects.
     */
    val endpointDescriptions: List<EndpointDescription>? = builder.endpointDescriptions
    /**
     * The Amazon Resource Name (ARN) of the endpoint group.
     */
    val endpointGroupArn: kotlin.String? = builder.endpointGroupArn
    /**
     * The AWS Region where the endpoint group is located.
     */
    val endpointGroupRegion: kotlin.String? = builder.endpointGroupRegion
    /**
     * The time—10 seconds or 30 seconds—between health checks for each endpoint. The default value is 30.
     */
    val healthCheckIntervalSeconds: kotlin.Int? = builder.healthCheckIntervalSeconds
    /**
     * If the protocol is HTTP/S, then this value provides the ping path that Global Accelerator uses for the destination on the
     * endpoints for health checks. The default is slash (/).
     */
    val healthCheckPath: kotlin.String? = builder.healthCheckPath
    /**
     * The port that Global Accelerator uses to perform health checks on endpoints that are part of this endpoint group.
     * The default port is the port for the listener that this endpoint group is associated with. If the listener port is a
     * list, Global Accelerator uses the first specified port in the list of ports.
     */
    val healthCheckPort: kotlin.Int? = builder.healthCheckPort
    /**
     * The protocol that Global Accelerator uses to perform health checks on endpoints that are part of this endpoint group. The default
     * value is TCP.
     */
    val healthCheckProtocol: aws.sdk.kotlin.services.globalaccelerator.model.HealthCheckProtocol? = builder.healthCheckProtocol
    /**
     * Allows you to override the destination ports used to route traffic to an endpoint.
     * Using a port override lets you to map a list of external destination ports (that your
     * users send traffic to) to a list of internal destination ports that you want an application
     * endpoint to receive traffic on.
     */
    val portOverrides: List<PortOverride>? = builder.portOverrides
    /**
     * The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an
     * unhealthy endpoint to healthy. The default value is 3.
     */
    val thresholdCount: kotlin.Int? = builder.thresholdCount
    /**
     * The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for
     * this listener.
     * Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
     * applied to the traffic that would otherwise have been routed to the Region based on optimal routing.
     * The default value is 100.
     */
    val trafficDialPercentage: kotlin.Float? = builder.trafficDialPercentage

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.EndpointGroup = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointGroup(")
        append("endpointDescriptions=$endpointDescriptions,")
        append("endpointGroupArn=$endpointGroupArn,")
        append("endpointGroupRegion=$endpointGroupRegion,")
        append("healthCheckIntervalSeconds=$healthCheckIntervalSeconds,")
        append("healthCheckPath=$healthCheckPath,")
        append("healthCheckPort=$healthCheckPort,")
        append("healthCheckProtocol=$healthCheckProtocol,")
        append("portOverrides=$portOverrides,")
        append("thresholdCount=$thresholdCount,")
        append("trafficDialPercentage=$trafficDialPercentage)")
    }

    override fun hashCode(): kotlin.Int {
        var result = endpointDescriptions?.hashCode() ?: 0
        result = 31 * result + (endpointGroupArn?.hashCode() ?: 0)
        result = 31 * result + (endpointGroupRegion?.hashCode() ?: 0)
        result = 31 * result + (healthCheckIntervalSeconds ?: 0)
        result = 31 * result + (healthCheckPath?.hashCode() ?: 0)
        result = 31 * result + (healthCheckPort ?: 0)
        result = 31 * result + (healthCheckProtocol?.hashCode() ?: 0)
        result = 31 * result + (portOverrides?.hashCode() ?: 0)
        result = 31 * result + (thresholdCount ?: 0)
        result = 31 * result + (trafficDialPercentage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointGroup

        if (endpointDescriptions != other.endpointDescriptions) return false
        if (endpointGroupArn != other.endpointGroupArn) return false
        if (endpointGroupRegion != other.endpointGroupRegion) return false
        if (healthCheckIntervalSeconds != other.healthCheckIntervalSeconds) return false
        if (healthCheckPath != other.healthCheckPath) return false
        if (healthCheckPort != other.healthCheckPort) return false
        if (healthCheckProtocol != other.healthCheckProtocol) return false
        if (portOverrides != other.portOverrides) return false
        if (thresholdCount != other.thresholdCount) return false
        if (trafficDialPercentage != other.trafficDialPercentage) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.EndpointGroup = Builder(this).apply(block).build()

    class Builder {
        /**
         * The list of endpoint objects.
         */
        var endpointDescriptions: List<EndpointDescription>? = null
        /**
         * The Amazon Resource Name (ARN) of the endpoint group.
         */
        var endpointGroupArn: kotlin.String? = null
        /**
         * The AWS Region where the endpoint group is located.
         */
        var endpointGroupRegion: kotlin.String? = null
        /**
         * The time—10 seconds or 30 seconds—between health checks for each endpoint. The default value is 30.
         */
        var healthCheckIntervalSeconds: kotlin.Int? = null
        /**
         * If the protocol is HTTP/S, then this value provides the ping path that Global Accelerator uses for the destination on the
         * endpoints for health checks. The default is slash (/).
         */
        var healthCheckPath: kotlin.String? = null
        /**
         * The port that Global Accelerator uses to perform health checks on endpoints that are part of this endpoint group.
         * The default port is the port for the listener that this endpoint group is associated with. If the listener port is a
         * list, Global Accelerator uses the first specified port in the list of ports.
         */
        var healthCheckPort: kotlin.Int? = null
        /**
         * The protocol that Global Accelerator uses to perform health checks on endpoints that are part of this endpoint group. The default
         * value is TCP.
         */
        var healthCheckProtocol: aws.sdk.kotlin.services.globalaccelerator.model.HealthCheckProtocol? = null
        /**
         * Allows you to override the destination ports used to route traffic to an endpoint.
         * Using a port override lets you to map a list of external destination ports (that your
         * users send traffic to) to a list of internal destination ports that you want an application
         * endpoint to receive traffic on.
         */
        var portOverrides: List<PortOverride>? = null
        /**
         * The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an
         * unhealthy endpoint to healthy. The default value is 3.
         */
        var thresholdCount: kotlin.Int? = null
        /**
         * The percentage of traffic to send to an AWS Region. Additional traffic is distributed to other endpoint groups for
         * this listener.
         * Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is
         * applied to the traffic that would otherwise have been routed to the Region based on optimal routing.
         * The default value is 100.
         */
        var trafficDialPercentage: kotlin.Float? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.EndpointGroup) : this() {
            this.endpointDescriptions = x.endpointDescriptions
            this.endpointGroupArn = x.endpointGroupArn
            this.endpointGroupRegion = x.endpointGroupRegion
            this.healthCheckIntervalSeconds = x.healthCheckIntervalSeconds
            this.healthCheckPath = x.healthCheckPath
            this.healthCheckPort = x.healthCheckPort
            this.healthCheckProtocol = x.healthCheckProtocol
            this.portOverrides = x.portOverrides
            this.thresholdCount = x.thresholdCount
            this.trafficDialPercentage = x.trafficDialPercentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.EndpointGroup = EndpointGroup(this)
    }
}
