// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model



/**
 * A complex type for an endpoint. Each endpoint group can include one or more endpoints, such as load
 * balancers.
 */
class EndpointDescription private constructor(builder: Builder) {
    /**
     * Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint.
     * The value is true or false. The default value is true for new accelerators.
     * If the value is set to true, the client's IP address is preserved in the X-Forwarded-For request header as
     * traffic travels to applications on the Application Load Balancer endpoint fronted by the accelerator.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/introduction-how-it-works-client-ip.html">
     * Viewing Client IP Addresses in AWS Global Accelerator in the AWS Global Accelerator Developer Guide.
     */
    val clientIpPreservationEnabled: kotlin.Boolean? = builder.clientIpPreservationEnabled
    /**
     * An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon
     * Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address
     * allocation ID. For Amazon EC2 instances, this is the EC2 instance ID.
     * An Application Load Balancer can be either internal or internet-facing.
     */
    val endpointId: kotlin.String? = builder.endpointId
    /**
     * Returns a null result.
     */
    val healthReason: kotlin.String? = builder.healthReason
    /**
     * The health status of the endpoint.
     */
    val healthState: aws.sdk.kotlin.services.globalaccelerator.model.HealthState? = builder.healthState
    /**
     * The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global Accelerator to route traffic
     * based on proportions that you specify. For example, you might specify endpoint weights of 4, 5, 5, and 6 (sum=20). The
     * result is that 4/20 of your traffic, on average, is routed to the first endpoint, 5/20 is routed both to the second
     * and third endpoints, and 6/20 is routed to the last endpoint. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html">Endpoint Weights in the
     * AWS Global Accelerator Developer Guide.
     */
    val weight: kotlin.Int? = builder.weight

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.EndpointDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointDescription(")
        append("clientIpPreservationEnabled=$clientIpPreservationEnabled,")
        append("endpointId=$endpointId,")
        append("healthReason=$healthReason,")
        append("healthState=$healthState,")
        append("weight=$weight)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientIpPreservationEnabled?.hashCode() ?: 0
        result = 31 * result + (endpointId?.hashCode() ?: 0)
        result = 31 * result + (healthReason?.hashCode() ?: 0)
        result = 31 * result + (healthState?.hashCode() ?: 0)
        result = 31 * result + (weight ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointDescription

        if (clientIpPreservationEnabled != other.clientIpPreservationEnabled) return false
        if (endpointId != other.endpointId) return false
        if (healthReason != other.healthReason) return false
        if (healthState != other.healthState) return false
        if (weight != other.weight) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.EndpointDescription = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint.
         * The value is true or false. The default value is true for new accelerators.
         * If the value is set to true, the client's IP address is preserved in the X-Forwarded-For request header as
         * traffic travels to applications on the Application Load Balancer endpoint fronted by the accelerator.
         * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/introduction-how-it-works-client-ip.html">
         * Viewing Client IP Addresses in AWS Global Accelerator in the AWS Global Accelerator Developer Guide.
         */
        var clientIpPreservationEnabled: kotlin.Boolean? = null
        /**
         * An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon
         * Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address
         * allocation ID. For Amazon EC2 instances, this is the EC2 instance ID.
         * An Application Load Balancer can be either internal or internet-facing.
         */
        var endpointId: kotlin.String? = null
        /**
         * Returns a null result.
         */
        var healthReason: kotlin.String? = null
        /**
         * The health status of the endpoint.
         */
        var healthState: aws.sdk.kotlin.services.globalaccelerator.model.HealthState? = null
        /**
         * The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global Accelerator to route traffic
         * based on proportions that you specify. For example, you might specify endpoint weights of 4, 5, 5, and 6 (sum=20). The
         * result is that 4/20 of your traffic, on average, is routed to the first endpoint, 5/20 is routed both to the second
         * and third endpoints, and 6/20 is routed to the last endpoint. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html">Endpoint Weights in the
         * AWS Global Accelerator Developer Guide.
         */
        var weight: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.EndpointDescription) : this() {
            this.clientIpPreservationEnabled = x.clientIpPreservationEnabled
            this.endpointId = x.endpointId
            this.healthReason = x.healthReason
            this.healthState = x.healthState
            this.weight = x.weight
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.EndpointDescription = EndpointDescription(this)
    }
}
