// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model



/**
 * A complex type for endpoints. A resource must be valid and active when you add it as an endpoint.
 */
class EndpointConfiguration private constructor(builder: Builder) {
    /**
     * Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint.
     * The value is true or false. The default value is true for new accelerators.
     * If the value is set to true, the client's IP address is preserved in the X-Forwarded-For request header as
     * traffic travels to applications on the Application Load Balancer endpoint fronted by the accelerator.
     * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/preserve-client-ip-address.html">
     * Preserve Client IP Addresses in AWS Global Accelerator in the AWS Global Accelerator Developer Guide.
     */
    val clientIpPreservationEnabled: kotlin.Boolean? = builder.clientIpPreservationEnabled
    /**
     * An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon
     * Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address
     * allocation ID. For Amazon EC2 instances, this is the EC2 instance ID. A resource must be valid and active
     * when you add it as an endpoint.
     * An Application Load Balancer can be either internal or internet-facing.
     */
    val endpointId: kotlin.String? = builder.endpointId
    /**
     * The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global Accelerator to route traffic
     * based on proportions that you specify. For example, you might specify endpoint weights of 4, 5, 5, and 6 (sum=20). The
     * result is that 4/20 of your traffic, on average, is routed to the first endpoint, 5/20 is routed both to the second
     * and third endpoints, and 6/20 is routed to the last endpoint. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html">Endpoint Weights in the
     * AWS Global Accelerator Developer Guide.
     */
    val weight: kotlin.Int? = builder.weight

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.EndpointConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointConfiguration(")
        append("clientIpPreservationEnabled=$clientIpPreservationEnabled,")
        append("endpointId=$endpointId,")
        append("weight=$weight)")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientIpPreservationEnabled?.hashCode() ?: 0
        result = 31 * result + (endpointId?.hashCode() ?: 0)
        result = 31 * result + (weight ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointConfiguration

        if (clientIpPreservationEnabled != other.clientIpPreservationEnabled) return false
        if (endpointId != other.endpointId) return false
        if (weight != other.weight) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.EndpointConfiguration = Builder(this).apply(block).build()

    class Builder {
        /**
         * Indicates whether client IP address preservation is enabled for an Application Load Balancer endpoint.
         * The value is true or false. The default value is true for new accelerators.
         * If the value is set to true, the client's IP address is preserved in the X-Forwarded-For request header as
         * traffic travels to applications on the Application Load Balancer endpoint fronted by the accelerator.
         * For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/preserve-client-ip-address.html">
         * Preserve Client IP Addresses in AWS Global Accelerator in the AWS Global Accelerator Developer Guide.
         */
        var clientIpPreservationEnabled: kotlin.Boolean? = null
        /**
         * An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon
         * Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address
         * allocation ID. For Amazon EC2 instances, this is the EC2 instance ID. A resource must be valid and active
         * when you add it as an endpoint.
         * An Application Load Balancer can be either internal or internet-facing.
         */
        var endpointId: kotlin.String? = null
        /**
         * The weight associated with the endpoint. When you add weights to endpoints, you configure AWS Global Accelerator to route traffic
         * based on proportions that you specify. For example, you might specify endpoint weights of 4, 5, 5, and 6 (sum=20). The
         * result is that 4/20 of your traffic, on average, is routed to the first endpoint, 5/20 is routed both to the second
         * and third endpoints, and 6/20 is routed to the last endpoint. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html">Endpoint Weights in the
         * AWS Global Accelerator Developer Guide.
         */
        var weight: kotlin.Int? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.EndpointConfiguration) : this() {
            this.clientIpPreservationEnabled = x.clientIpPreservationEnabled
            this.endpointId = x.endpointId
            this.weight = x.weight
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.EndpointConfiguration = EndpointConfiguration(this)
    }
}
