// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model



/**
 * A complex type for a listener for a custom routing accelerator.
 */
class CustomRoutingListener private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the listener.
     */
    val listenerArn: kotlin.String? = builder.listenerArn
    /**
     * The port range to support for connections from clients to your accelerator.
     * Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
     * endpoints for custom routing accelerators.
     */
    val portRanges: List<PortRange>? = builder.portRanges

    companion object {
        operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingListener = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CustomRoutingListener(")
        append("listenerArn=$listenerArn,")
        append("portRanges=$portRanges)")
    }

    override fun hashCode(): kotlin.Int {
        var result = listenerArn?.hashCode() ?: 0
        result = 31 * result + (portRanges?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CustomRoutingListener

        if (listenerArn != other.listenerArn) return false
        if (portRanges != other.portRanges) return false

        return true
    }

    inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingListener = Builder(this).apply(block).build()

    class Builder {
        /**
         * The Amazon Resource Name (ARN) of the listener.
         */
        var listenerArn: kotlin.String? = null
        /**
         * The port range to support for connections from clients to your accelerator.
         * Separately, you set port ranges for endpoints. For more information, see <a href="https://docs.aws.amazon.com/global-accelerator/latest/dg/about-custom-routing-endpoints.html">About
         * endpoints for custom routing accelerators.
         */
        var portRanges: List<PortRange>? = null

        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingListener) : this() {
            this.listenerArn = x.listenerArn
            this.portRanges = x.portRanges
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingListener = CustomRoutingListener(this)
    }
}
