// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * An endpoint (Amazon Web Services resource) or an IP address range, in CIDR format, that is listed in a cross-account attachment. A cross-account resource can be added to an accelerator by specified principals, which are also listed in the attachment.
 *
 * For more information, see [ Working with cross-account attachments and resources in Global Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/cross-account-resources.html) in the * Global Accelerator Developer Guide*.
 */
public class CrossAccountResource private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the cross-account attachment that specifies the resources (endpoints or CIDR range) that can be added to accelerators and principals that have permission to add them.
     */
    public val attachmentArn: kotlin.String? = builder.attachmentArn
    /**
     * An IP address range, in CIDR format, that is specified as an Amazon Web Services resource. The address must be provisioned and advertised in Global Accelerator by following the bring your own IP address (BYOIP) process for Global Accelerator.
     *
     *  For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the Global Accelerator Developer Guide.
     */
    public val cidr: kotlin.String? = builder.cidr
    /**
     * The endpoint ID for the endpoint that is listed in a cross-account attachment and can be added to an accelerator by specified principals.
     */
    public val endpointId: kotlin.String? = builder.endpointId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.CrossAccountResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CrossAccountResource(")
        append("attachmentArn=$attachmentArn,")
        append("cidr=$cidr,")
        append("endpointId=$endpointId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachmentArn?.hashCode() ?: 0
        result = 31 * result + (cidr?.hashCode() ?: 0)
        result = 31 * result + (endpointId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CrossAccountResource

        if (attachmentArn != other.attachmentArn) return false
        if (cidr != other.cidr) return false
        if (endpointId != other.endpointId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.CrossAccountResource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the cross-account attachment that specifies the resources (endpoints or CIDR range) that can be added to accelerators and principals that have permission to add them.
         */
        public var attachmentArn: kotlin.String? = null
        /**
         * An IP address range, in CIDR format, that is specified as an Amazon Web Services resource. The address must be provisioned and advertised in Global Accelerator by following the bring your own IP address (BYOIP) process for Global Accelerator.
         *
         *  For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the Global Accelerator Developer Guide.
         */
        public var cidr: kotlin.String? = null
        /**
         * The endpoint ID for the endpoint that is listed in a cross-account attachment and can be added to an accelerator by specified principals.
         */
        public var endpointId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.CrossAccountResource) : this() {
            this.attachmentArn = x.attachmentArn
            this.cidr = x.cidr
            this.endpointId = x.endpointId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.CrossAccountResource = CrossAccountResource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
