// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.serde

import aws.sdk.kotlin.services.globalaccelerator.model.AllowCustomRoutingTrafficResponse
import aws.sdk.kotlin.services.globalaccelerator.model.GlobalAcceleratorException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext


internal class AllowCustomRoutingTrafficOperationDeserializer: HttpDeserializer.NonStreaming<AllowCustomRoutingTrafficResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): AllowCustomRoutingTrafficResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAllowCustomRoutingTrafficError(context, call, payload)
        }
        val builder = AllowCustomRoutingTrafficResponse.Builder()

        builder.correctErrors()
        return builder.build()
    }
}

private fun throwAllowCustomRoutingTrafficError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GlobalAcceleratorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EndpointGroupNotFoundException" -> EndpointGroupNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GlobalAcceleratorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
