// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.serde

import aws.sdk.kotlin.services.globalaccelerator.model.ByoipCidr
import aws.sdk.kotlin.services.globalaccelerator.model.GlobalAcceleratorException
import aws.sdk.kotlin.services.globalaccelerator.model.WithdrawByoipCidrResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class WithdrawByoipCidrOperationDeserializer: HttpDeserializer.NonStreaming<WithdrawByoipCidrResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): WithdrawByoipCidrResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwWithdrawByoipCidrError(context, call, payload)
        }
        val builder = WithdrawByoipCidrResponse.Builder()

        if (payload != null) {
            deserializeWithdrawByoipCidrOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwWithdrawByoipCidrError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GlobalAcceleratorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ByoipCidrNotFoundException" -> ByoipCidrNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "IncorrectCidrStateException" -> IncorrectCidrStateExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GlobalAcceleratorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeWithdrawByoipCidrOperationBody(builder: WithdrawByoipCidrResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BYOIPCIDR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ByoipCidr"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BYOIPCIDR_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BYOIPCIDR_DESCRIPTOR.index -> builder.byoipCidr = deserializeByoipCidrDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
