// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.serde

import aws.sdk.kotlin.services.globalaccelerator.model.AddCustomRoutingEndpointsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingEndpointDescription
import aws.sdk.kotlin.services.globalaccelerator.model.GlobalAcceleratorException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class AddCustomRoutingEndpointsOperationDeserializer: HttpDeserializer.NonStreaming<AddCustomRoutingEndpointsResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): AddCustomRoutingEndpointsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAddCustomRoutingEndpointsError(context, call, payload)
        }
        val builder = AddCustomRoutingEndpointsResponse.Builder()

        if (payload != null) {
            deserializeAddCustomRoutingEndpointsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwAddCustomRoutingEndpointsError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GlobalAcceleratorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EndpointGroupNotFoundException" -> EndpointGroupNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "EndpointAlreadyExistsException" -> EndpointAlreadyExistsExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> GlobalAcceleratorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAddCustomRoutingEndpointsOperationBody(builder: AddCustomRoutingEndpointsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENDPOINTDESCRIPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EndpointDescriptions"))
    val ENDPOINTGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EndpointGroupArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDPOINTDESCRIPTIONS_DESCRIPTOR)
        field(ENDPOINTGROUPARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENDPOINTDESCRIPTIONS_DESCRIPTOR.index -> builder.endpointDescriptions =
                    deserializer.deserializeList(ENDPOINTDESCRIPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<CustomRoutingEndpointDescription>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCustomRoutingEndpointDescriptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ENDPOINTGROUPARN_DESCRIPTOR.index -> builder.endpointGroupArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
