// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.paginators

import aws.sdk.kotlin.services.globalaccelerator.GlobalAcceleratorClient
import aws.sdk.kotlin.services.globalaccelerator.model.Accelerator
import aws.sdk.kotlin.services.globalaccelerator.model.Attachment
import aws.sdk.kotlin.services.globalaccelerator.model.ByoipCidr
import aws.sdk.kotlin.services.globalaccelerator.model.CrossAccountResource
import aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingAccelerator
import aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingEndpointGroup
import aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingListener
import aws.sdk.kotlin.services.globalaccelerator.model.DestinationPortMapping
import aws.sdk.kotlin.services.globalaccelerator.model.EndpointGroup
import aws.sdk.kotlin.services.globalaccelerator.model.ListAcceleratorsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListAcceleratorsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListByoipCidrsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListByoipCidrsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListCrossAccountAttachmentsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCrossAccountAttachmentsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListCrossAccountResourcesRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCrossAccountResourcesResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingListenersRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingListenersResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListEndpointGroupsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListEndpointGroupsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListListenersRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListListenersResponse
import aws.sdk.kotlin.services.globalaccelerator.model.Listener
import aws.sdk.kotlin.services.globalaccelerator.model.PortMapping
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListAcceleratorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListAcceleratorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAcceleratorsResponse]
 */
public fun GlobalAcceleratorClient.listAcceleratorsPaginated(initialRequest: ListAcceleratorsRequest = ListAcceleratorsRequest { }): Flow<ListAcceleratorsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listAcceleratorsPaginated.listAccelerators(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListAcceleratorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListAcceleratorsResponse]
 */
public fun GlobalAcceleratorClient.listAcceleratorsPaginated(block: ListAcceleratorsRequest.Builder.() -> Unit): Flow<ListAcceleratorsResponse> =
    listAcceleratorsPaginated(ListAcceleratorsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listAcceleratorsPaginated]
 * to access the nested member [Accelerator]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Accelerator]
 */
@JvmName("listAcceleratorsResponseAccelerator")
public fun Flow<ListAcceleratorsResponse>.accelerators(): Flow<Accelerator> =
    transform() { response ->
        response.accelerators?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListByoipCidrsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListByoipCidrsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListByoipCidrsResponse]
 */
public fun GlobalAcceleratorClient.listByoipCidrsPaginated(initialRequest: ListByoipCidrsRequest = ListByoipCidrsRequest { }): Flow<ListByoipCidrsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listByoipCidrsPaginated.listByoipCidrs(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListByoipCidrsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListByoipCidrsResponse]
 */
public fun GlobalAcceleratorClient.listByoipCidrsPaginated(block: ListByoipCidrsRequest.Builder.() -> Unit): Flow<ListByoipCidrsResponse> =
    listByoipCidrsPaginated(ListByoipCidrsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listByoipCidrsPaginated]
 * to access the nested member [ByoipCidr]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ByoipCidr]
 */
@JvmName("listByoipCidrsResponseByoipCidr")
public fun Flow<ListByoipCidrsResponse>.byoipCidrs(): Flow<ByoipCidr> =
    transform() { response ->
        response.byoipCidrs?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCrossAccountAttachmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCrossAccountAttachmentsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCrossAccountAttachmentsResponse]
 */
public fun GlobalAcceleratorClient.listCrossAccountAttachmentsPaginated(initialRequest: ListCrossAccountAttachmentsRequest = ListCrossAccountAttachmentsRequest { }): Flow<ListCrossAccountAttachmentsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCrossAccountAttachmentsPaginated.listCrossAccountAttachments(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCrossAccountAttachmentsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCrossAccountAttachmentsResponse]
 */
public fun GlobalAcceleratorClient.listCrossAccountAttachmentsPaginated(block: ListCrossAccountAttachmentsRequest.Builder.() -> Unit): Flow<ListCrossAccountAttachmentsResponse> =
    listCrossAccountAttachmentsPaginated(ListCrossAccountAttachmentsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCrossAccountAttachmentsPaginated]
 * to access the nested member [Attachment]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Attachment]
 */
@JvmName("listCrossAccountAttachmentsResponseAttachment")
public fun Flow<ListCrossAccountAttachmentsResponse>.crossAccountAttachments(): Flow<Attachment> =
    transform() { response ->
        response.crossAccountAttachments?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCrossAccountResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCrossAccountResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCrossAccountResourcesResponse]
 */
public fun GlobalAcceleratorClient.listCrossAccountResourcesPaginated(initialRequest: ListCrossAccountResourcesRequest): Flow<ListCrossAccountResourcesResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCrossAccountResourcesPaginated.listCrossAccountResources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCrossAccountResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCrossAccountResourcesResponse]
 */
public fun GlobalAcceleratorClient.listCrossAccountResourcesPaginated(block: ListCrossAccountResourcesRequest.Builder.() -> Unit): Flow<ListCrossAccountResourcesResponse> =
    listCrossAccountResourcesPaginated(ListCrossAccountResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCrossAccountResourcesPaginated]
 * to access the nested member [CrossAccountResource]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CrossAccountResource]
 */
@JvmName("listCrossAccountResourcesResponseCrossAccountResource")
public fun Flow<ListCrossAccountResourcesResponse>.crossAccountResources(): Flow<CrossAccountResource> =
    transform() { response ->
        response.crossAccountResources?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCustomRoutingAcceleratorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCustomRoutingAcceleratorsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomRoutingAcceleratorsResponse]
 */
public fun GlobalAcceleratorClient.listCustomRoutingAcceleratorsPaginated(initialRequest: ListCustomRoutingAcceleratorsRequest = ListCustomRoutingAcceleratorsRequest { }): Flow<ListCustomRoutingAcceleratorsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCustomRoutingAcceleratorsPaginated.listCustomRoutingAccelerators(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCustomRoutingAcceleratorsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomRoutingAcceleratorsResponse]
 */
public fun GlobalAcceleratorClient.listCustomRoutingAcceleratorsPaginated(block: ListCustomRoutingAcceleratorsRequest.Builder.() -> Unit): Flow<ListCustomRoutingAcceleratorsResponse> =
    listCustomRoutingAcceleratorsPaginated(ListCustomRoutingAcceleratorsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCustomRoutingAcceleratorsPaginated]
 * to access the nested member [CustomRoutingAccelerator]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CustomRoutingAccelerator]
 */
@JvmName("listCustomRoutingAcceleratorsResponseCustomRoutingAccelerator")
public fun Flow<ListCustomRoutingAcceleratorsResponse>.accelerators(): Flow<CustomRoutingAccelerator> =
    transform() { response ->
        response.accelerators?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCustomRoutingEndpointGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCustomRoutingEndpointGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomRoutingEndpointGroupsResponse]
 */
public fun GlobalAcceleratorClient.listCustomRoutingEndpointGroupsPaginated(initialRequest: ListCustomRoutingEndpointGroupsRequest): Flow<ListCustomRoutingEndpointGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCustomRoutingEndpointGroupsPaginated.listCustomRoutingEndpointGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCustomRoutingEndpointGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomRoutingEndpointGroupsResponse]
 */
public fun GlobalAcceleratorClient.listCustomRoutingEndpointGroupsPaginated(block: ListCustomRoutingEndpointGroupsRequest.Builder.() -> Unit): Flow<ListCustomRoutingEndpointGroupsResponse> =
    listCustomRoutingEndpointGroupsPaginated(ListCustomRoutingEndpointGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCustomRoutingEndpointGroupsPaginated]
 * to access the nested member [CustomRoutingEndpointGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CustomRoutingEndpointGroup]
 */
@JvmName("listCustomRoutingEndpointGroupsResponseCustomRoutingEndpointGroup")
public fun Flow<ListCustomRoutingEndpointGroupsResponse>.endpointGroups(): Flow<CustomRoutingEndpointGroup> =
    transform() { response ->
        response.endpointGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCustomRoutingListenersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCustomRoutingListenersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomRoutingListenersResponse]
 */
public fun GlobalAcceleratorClient.listCustomRoutingListenersPaginated(initialRequest: ListCustomRoutingListenersRequest): Flow<ListCustomRoutingListenersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCustomRoutingListenersPaginated.listCustomRoutingListeners(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCustomRoutingListenersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomRoutingListenersResponse]
 */
public fun GlobalAcceleratorClient.listCustomRoutingListenersPaginated(block: ListCustomRoutingListenersRequest.Builder.() -> Unit): Flow<ListCustomRoutingListenersResponse> =
    listCustomRoutingListenersPaginated(ListCustomRoutingListenersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCustomRoutingListenersPaginated]
 * to access the nested member [CustomRoutingListener]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [CustomRoutingListener]
 */
@JvmName("listCustomRoutingListenersResponseCustomRoutingListener")
public fun Flow<ListCustomRoutingListenersResponse>.listeners(): Flow<CustomRoutingListener> =
    transform() { response ->
        response.listeners?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCustomRoutingPortMappingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCustomRoutingPortMappingsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomRoutingPortMappingsResponse]
 */
public fun GlobalAcceleratorClient.listCustomRoutingPortMappingsPaginated(initialRequest: ListCustomRoutingPortMappingsRequest): Flow<ListCustomRoutingPortMappingsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCustomRoutingPortMappingsPaginated.listCustomRoutingPortMappings(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCustomRoutingPortMappingsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomRoutingPortMappingsResponse]
 */
public fun GlobalAcceleratorClient.listCustomRoutingPortMappingsPaginated(block: ListCustomRoutingPortMappingsRequest.Builder.() -> Unit): Flow<ListCustomRoutingPortMappingsResponse> =
    listCustomRoutingPortMappingsPaginated(ListCustomRoutingPortMappingsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCustomRoutingPortMappingsPaginated]
 * to access the nested member [PortMapping]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [PortMapping]
 */
@JvmName("listCustomRoutingPortMappingsResponsePortMapping")
public fun Flow<ListCustomRoutingPortMappingsResponse>.portMappings(): Flow<PortMapping> =
    transform() { response ->
        response.portMappings?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListCustomRoutingPortMappingsByDestinationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListCustomRoutingPortMappingsByDestinationRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomRoutingPortMappingsByDestinationResponse]
 */
public fun GlobalAcceleratorClient.listCustomRoutingPortMappingsByDestinationPaginated(initialRequest: ListCustomRoutingPortMappingsByDestinationRequest): Flow<ListCustomRoutingPortMappingsByDestinationResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listCustomRoutingPortMappingsByDestinationPaginated.listCustomRoutingPortMappingsByDestination(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListCustomRoutingPortMappingsByDestinationResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListCustomRoutingPortMappingsByDestinationResponse]
 */
public fun GlobalAcceleratorClient.listCustomRoutingPortMappingsByDestinationPaginated(block: ListCustomRoutingPortMappingsByDestinationRequest.Builder.() -> Unit): Flow<ListCustomRoutingPortMappingsByDestinationResponse> =
    listCustomRoutingPortMappingsByDestinationPaginated(ListCustomRoutingPortMappingsByDestinationRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listCustomRoutingPortMappingsByDestinationPaginated]
 * to access the nested member [DestinationPortMapping]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [DestinationPortMapping]
 */
@JvmName("listCustomRoutingPortMappingsByDestinationResponseDestinationPortMapping")
public fun Flow<ListCustomRoutingPortMappingsByDestinationResponse>.destinationPortMappings(): Flow<DestinationPortMapping> =
    transform() { response ->
        response.destinationPortMappings?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListEndpointGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListEndpointGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEndpointGroupsResponse]
 */
public fun GlobalAcceleratorClient.listEndpointGroupsPaginated(initialRequest: ListEndpointGroupsRequest): Flow<ListEndpointGroupsResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listEndpointGroupsPaginated.listEndpointGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListEndpointGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListEndpointGroupsResponse]
 */
public fun GlobalAcceleratorClient.listEndpointGroupsPaginated(block: ListEndpointGroupsRequest.Builder.() -> Unit): Flow<ListEndpointGroupsResponse> =
    listEndpointGroupsPaginated(ListEndpointGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listEndpointGroupsPaginated]
 * to access the nested member [EndpointGroup]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [EndpointGroup]
 */
@JvmName("listEndpointGroupsResponseEndpointGroup")
public fun Flow<ListEndpointGroupsResponse>.endpointGroups(): Flow<EndpointGroup> =
    transform() { response ->
        response.endpointGroups?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListListenersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListListenersRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListListenersResponse]
 */
public fun GlobalAcceleratorClient.listListenersPaginated(initialRequest: ListListenersRequest): Flow<ListListenersResponse> =
    flow {
        var cursor: kotlin.String? = initialRequest.nextToken
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listListenersPaginated.listListeners(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListListenersResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListListenersResponse]
 */
public fun GlobalAcceleratorClient.listListenersPaginated(block: ListListenersRequest.Builder.() -> Unit): Flow<ListListenersResponse> =
    listListenersPaginated(ListListenersRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listListenersPaginated]
 * to access the nested member [Listener]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [Listener]
 */
@JvmName("listListenersResponseListener")
public fun Flow<ListListenersResponse>.listeners(): Flow<Listener> =
    transform() { response ->
        response.listeners?.forEach {
            emit(it)
        }
    }
