// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A complex type for endpoints. A resource must be valid and active when you add it as an endpoint.
 */
public class EndpointConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the cross-account attachment that specifies the endpoints (resources) that can be added to accelerators and principals that have permission to add the endpoints.
     */
    public val attachmentArn: kotlin.String? = builder.attachmentArn
    /**
     * Indicates whether client IP address preservation is enabled for an endpoint. The value is true or false. The default value is true for Application Load Balancer endpoints.
     *
     * If the value is set to true, the client's IP address is preserved in the `X-Forwarded-For` request header as traffic travels to applications on the endpoint fronted by the accelerator.
     *
     * Client IP address preservation is supported, in specific Amazon Web Services Regions, for endpoints that are Application Load Balancers, Amazon EC2 instances, and Network Load Balancers with security groups. IMPORTANT: You cannot use client IP address preservation with Network Load Balancers with TLS listeners.
     *
     * For more information, see [ Preserve client IP addresses in Global Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/preserve-client-ip-address.html) in the *Global Accelerator Developer Guide*.
     */
    public val clientIpPreservationEnabled: kotlin.Boolean? = builder.clientIpPreservationEnabled
    /**
     * An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address allocation ID. For Amazon EC2 instances, this is the EC2 instance ID. A resource must be valid and active when you add it as an endpoint.
     *
     * For cross-account endpoints, this must be the ARN of the resource.
     */
    public val endpointId: kotlin.String? = builder.endpointId
    /**
     * The weight associated with the endpoint. When you add weights to endpoints, you configure Global Accelerator to route traffic based on proportions that you specify. For example, you might specify endpoint weights of 4, 5, 5, and 6 (sum=20). The result is that 4/20 of your traffic, on average, is routed to the first endpoint, 5/20 is routed both to the second and third endpoints, and 6/20 is routed to the last endpoint. For more information, see [Endpoint weights](https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html) in the *Global Accelerator Developer Guide*.
     */
    public val weight: kotlin.Int? = builder.weight

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.EndpointConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointConfiguration(")
        append("attachmentArn=$attachmentArn,")
        append("clientIpPreservationEnabled=$clientIpPreservationEnabled,")
        append("endpointId=$endpointId,")
        append("weight=$weight")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachmentArn?.hashCode() ?: 0
        result = 31 * result + (clientIpPreservationEnabled?.hashCode() ?: 0)
        result = 31 * result + (endpointId?.hashCode() ?: 0)
        result = 31 * result + (weight ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointConfiguration

        if (attachmentArn != other.attachmentArn) return false
        if (clientIpPreservationEnabled != other.clientIpPreservationEnabled) return false
        if (endpointId != other.endpointId) return false
        if (weight != other.weight) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.EndpointConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the cross-account attachment that specifies the endpoints (resources) that can be added to accelerators and principals that have permission to add the endpoints.
         */
        public var attachmentArn: kotlin.String? = null
        /**
         * Indicates whether client IP address preservation is enabled for an endpoint. The value is true or false. The default value is true for Application Load Balancer endpoints.
         *
         * If the value is set to true, the client's IP address is preserved in the `X-Forwarded-For` request header as traffic travels to applications on the endpoint fronted by the accelerator.
         *
         * Client IP address preservation is supported, in specific Amazon Web Services Regions, for endpoints that are Application Load Balancers, Amazon EC2 instances, and Network Load Balancers with security groups. IMPORTANT: You cannot use client IP address preservation with Network Load Balancers with TLS listeners.
         *
         * For more information, see [ Preserve client IP addresses in Global Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/preserve-client-ip-address.html) in the *Global Accelerator Developer Guide*.
         */
        public var clientIpPreservationEnabled: kotlin.Boolean? = null
        /**
         * An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address allocation ID. For Amazon EC2 instances, this is the EC2 instance ID. A resource must be valid and active when you add it as an endpoint.
         *
         * For cross-account endpoints, this must be the ARN of the resource.
         */
        public var endpointId: kotlin.String? = null
        /**
         * The weight associated with the endpoint. When you add weights to endpoints, you configure Global Accelerator to route traffic based on proportions that you specify. For example, you might specify endpoint weights of 4, 5, 5, and 6 (sum=20). The result is that 4/20 of your traffic, on average, is routed to the first endpoint, 5/20 is routed both to the second and third endpoints, and 6/20 is routed to the last endpoint. For more information, see [Endpoint weights](https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints-endpoint-weights.html) in the *Global Accelerator Developer Guide*.
         */
        public var weight: kotlin.Int? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.EndpointConfiguration) : this() {
            this.attachmentArn = x.attachmentArn
            this.clientIpPreservationEnabled = x.clientIpPreservationEnabled
            this.endpointId = x.endpointId
            this.weight = x.weight
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.EndpointConfiguration = EndpointConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
