// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A cross-account attachment in Global Accelerator. A cross-account attachment specifies the *principals* who have permission to work with *resources* in your account, which you also list in the attachment.
 */
public class Attachment private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the cross-account attachment.
     */
    public val attachmentArn: kotlin.String? = builder.attachmentArn
    /**
     * The date and time that the cross-account attachment was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The date and time that the cross-account attachment was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the cross-account attachment.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The principals included in the cross-account attachment.
     */
    public val principals: List<String>? = builder.principals
    /**
     * The resources included in the cross-account attachment.
     */
    public val resources: List<Resource>? = builder.resources

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.Attachment = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Attachment(")
        append("attachmentArn=$attachmentArn,")
        append("createdTime=$createdTime,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=$name,")
        append("principals=$principals,")
        append("resources=$resources")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = attachmentArn?.hashCode() ?: 0
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (principals?.hashCode() ?: 0)
        result = 31 * result + (resources?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Attachment

        if (attachmentArn != other.attachmentArn) return false
        if (createdTime != other.createdTime) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false
        if (principals != other.principals) return false
        if (resources != other.resources) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.Attachment = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the cross-account attachment.
         */
        public var attachmentArn: kotlin.String? = null
        /**
         * The date and time that the cross-account attachment was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The date and time that the cross-account attachment was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the cross-account attachment.
         */
        public var name: kotlin.String? = null
        /**
         * The principals included in the cross-account attachment.
         */
        public var principals: List<String>? = null
        /**
         * The resources included in the cross-account attachment.
         */
        public var resources: List<Resource>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.Attachment) : this() {
            this.attachmentArn = x.attachmentArn
            this.createdTime = x.createdTime
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
            this.principals = x.principals
            this.resources = x.resources
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.Attachment = Attachment(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
