// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model



/**
 * A resource is one of the following: the ARN for an Amazon Web Services resource that is supported by Global Accelerator to be added as an endpoint, or a CIDR range that specifies a bring your own IP (BYOIP) address pool.
 */
public class Resource private constructor(builder: Builder) {
    /**
     * An IP address range, in CIDR format, that is specified as resource. The address must be provisioned and advertised in Global Accelerator by following the bring your own IP address (BYOIP) process for Global Accelerator
     *
     *  For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the Global Accelerator Developer Guide.
     */
    public val cidr: kotlin.String? = builder.cidr
    /**
     * The endpoint ID for the endpoint that is specified as a Amazon Web Services resource.
     *
     * An endpoint ID for the cross-account feature is the ARN of an Amazon Web Services resource, such as a Network Load Balancer, that Global Accelerator supports as an endpoint for an accelerator.
     */
    public val endpointId: kotlin.String = builder.endpointId
    /**
     * The Amazon Web Services Region where a shared endpoint resource is located.
     */
    public val region: kotlin.String? = builder.region

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.Resource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Resource(")
        append("cidr=$cidr,")
        append("endpointId=$endpointId,")
        append("region=$region")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = cidr?.hashCode() ?: 0
        result = 31 * result + (endpointId.hashCode())
        result = 31 * result + (region?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Resource

        if (cidr != other.cidr) return false
        if (endpointId != other.endpointId) return false
        if (region != other.region) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.Resource = Builder(this).apply(block).build()

    public class Builder {
        /**
         * An IP address range, in CIDR format, that is specified as resource. The address must be provisioned and advertised in Global Accelerator by following the bring your own IP address (BYOIP) process for Global Accelerator
         *
         *  For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the Global Accelerator Developer Guide.
         */
        public var cidr: kotlin.String? = null
        /**
         * The endpoint ID for the endpoint that is specified as a Amazon Web Services resource.
         *
         * An endpoint ID for the cross-account feature is the ARN of an Amazon Web Services resource, such as a Network Load Balancer, that Global Accelerator supports as an endpoint for an accelerator.
         */
        public var endpointId: kotlin.String = ""
        /**
         * The Amazon Web Services Region where a shared endpoint resource is located.
         */
        public var region: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.Resource) : this() {
            this.cidr = x.cidr
            this.endpointId = x.endpointId
            this.region = x.region
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.Resource = Resource(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
