// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.services.globalaccelerator.auth.DefaultGlobalAcceleratorAuthSchemeProvider
import aws.sdk.kotlin.services.globalaccelerator.auth.GlobalAcceleratorAuthSchemeProvider
import aws.sdk.kotlin.services.globalaccelerator.endpoints.DefaultGlobalAcceleratorEndpointProvider
import aws.sdk.kotlin.services.globalaccelerator.endpoints.GlobalAcceleratorEndpointParameters
import aws.sdk.kotlin.services.globalaccelerator.endpoints.GlobalAcceleratorEndpointProvider
import aws.sdk.kotlin.services.globalaccelerator.model.AddCustomRoutingEndpointsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.AddCustomRoutingEndpointsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.AddEndpointsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.AddEndpointsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.AdvertiseByoipCidrRequest
import aws.sdk.kotlin.services.globalaccelerator.model.AdvertiseByoipCidrResponse
import aws.sdk.kotlin.services.globalaccelerator.model.AllowCustomRoutingTrafficRequest
import aws.sdk.kotlin.services.globalaccelerator.model.AllowCustomRoutingTrafficResponse
import aws.sdk.kotlin.services.globalaccelerator.model.CreateAcceleratorRequest
import aws.sdk.kotlin.services.globalaccelerator.model.CreateAcceleratorResponse
import aws.sdk.kotlin.services.globalaccelerator.model.CreateCustomRoutingAcceleratorRequest
import aws.sdk.kotlin.services.globalaccelerator.model.CreateCustomRoutingAcceleratorResponse
import aws.sdk.kotlin.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest
import aws.sdk.kotlin.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupResponse
import aws.sdk.kotlin.services.globalaccelerator.model.CreateCustomRoutingListenerRequest
import aws.sdk.kotlin.services.globalaccelerator.model.CreateCustomRoutingListenerResponse
import aws.sdk.kotlin.services.globalaccelerator.model.CreateEndpointGroupRequest
import aws.sdk.kotlin.services.globalaccelerator.model.CreateEndpointGroupResponse
import aws.sdk.kotlin.services.globalaccelerator.model.CreateListenerRequest
import aws.sdk.kotlin.services.globalaccelerator.model.CreateListenerResponse
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteAcceleratorRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteAcceleratorResponse
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorResponse
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupResponse
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteCustomRoutingListenerRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteCustomRoutingListenerResponse
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteEndpointGroupRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteEndpointGroupResponse
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteListenerRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteListenerResponse
import aws.sdk.kotlin.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DenyCustomRoutingTrafficResponse
import aws.sdk.kotlin.services.globalaccelerator.model.DeprovisionByoipCidrRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DeprovisionByoipCidrResponse
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeAcceleratorAttributesRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeAcceleratorAttributesResponse
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeAcceleratorRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeAcceleratorResponse
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesResponse
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorResponse
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupResponse
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeCustomRoutingListenerRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeCustomRoutingListenerResponse
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeEndpointGroupRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeEndpointGroupResponse
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeListenerRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeListenerResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListAcceleratorsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListAcceleratorsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListByoipCidrsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListByoipCidrsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingAcceleratorsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingListenersRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingListenersResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingPortMappingsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListEndpointGroupsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListEndpointGroupsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListListenersRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListListenersResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.globalaccelerator.model.ProvisionByoipCidrRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ProvisionByoipCidrResponse
import aws.sdk.kotlin.services.globalaccelerator.model.RemoveCustomRoutingEndpointsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.RemoveCustomRoutingEndpointsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.RemoveEndpointsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.RemoveEndpointsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.TagResourceRequest
import aws.sdk.kotlin.services.globalaccelerator.model.TagResourceResponse
import aws.sdk.kotlin.services.globalaccelerator.model.UntagResourceRequest
import aws.sdk.kotlin.services.globalaccelerator.model.UntagResourceResponse
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateAcceleratorAttributesRequest
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateAcceleratorAttributesResponse
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateAcceleratorRequest
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateAcceleratorResponse
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorResponse
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateCustomRoutingListenerRequest
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateCustomRoutingListenerResponse
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateEndpointGroupRequest
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateEndpointGroupResponse
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateListenerRequest
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateListenerResponse
import aws.sdk.kotlin.services.globalaccelerator.model.WithdrawByoipCidrRequest
import aws.sdk.kotlin.services.globalaccelerator.model.WithdrawByoipCidrResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Global Accelerator"
public const val SdkVersion: String = "1.0.57"
public const val ServiceApiVersion: String = "2018-08-08"

/**
 * # Global Accelerator
 * This is the *Global Accelerator API Reference*. This guide is for developers who need detailed information about Global Accelerator API actions, data types, and errors. For more information about Global Accelerator features, see the [Global Accelerator Developer Guide](https://docs.aws.amazon.com/global-accelerator/latest/dg/what-is-global-accelerator.html).
 *
 * Global Accelerator is a service in which you create *accelerators* to improve the performance of your applications for local and global users. Depending on the type of accelerator you choose, you can gain additional benefits.
 * + By using a standard accelerator, you can improve availability of your internet applications that are used by a global audience. With a standard accelerator, Global Accelerator directs traffic to optimal endpoints over the Amazon Web Services global network.
 * + For other scenarios, you might choose a custom routing accelerator. With a custom routing accelerator, you can use application logic to directly map one or more users to a specific endpoint among many endpoints.
 *
 * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for example, specify `--region us-west-2` on Amazon Web Services CLI commands.
 *
 * By default, Global Accelerator provides you with static IP addresses that you associate with your accelerator. The static IP addresses are anycast from the Amazon Web Services edge network. For IPv4, Global Accelerator provides two static IPv4 addresses. For dual-stack, Global Accelerator provides a total of four addresses: two static IPv4 addresses and two static IPv6 addresses. With a standard accelerator for IPv4, instead of using the addresses that Global Accelerator provides, you can configure these entry points to be IPv4 addresses from your own IP address ranges that you bring toGlobal Accelerator (BYOIP).
 *
 * For a standard accelerator, they distribute incoming application traffic across multiple endpoint resources in multiple Amazon Web Services Regions , which increases the availability of your applications. Endpoints for standard accelerators can be Network Load Balancers, Application Load Balancers, Amazon EC2 instances, or Elastic IP addresses that are located in one Amazon Web Services Region or multiple Amazon Web Services Regions. For custom routing accelerators, you map traffic that arrives to the static IP addresses to specific Amazon EC2 servers in endpoints that are virtual private cloud (VPC) subnets.
 *
 * The static IP addresses remain assigned to your accelerator for as long as it exists, even if you disable the accelerator and it no longer accepts or routes traffic. However, when you *delete* an accelerator, you lose the static IP addresses that are assigned to it, so you can no longer route traffic by using them. You can use IAM policies like tag-based permissions with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information, see [Tag-based policies](https://docs.aws.amazon.com/global-accelerator/latest/dg/access-control-manage-access-tag-policies.html).
 *
 * For standard accelerators, Global Accelerator uses the Amazon Web Services global network to route traffic to the optimal regional endpoint based on health, client location, and policies that you configure. The service reacts instantly to changes in health or configuration to ensure that internet traffic from clients is always directed to healthy endpoints.
 *
 * For more information about understanding and using Global Accelerator, see the [Global Accelerator Developer Guide](https://docs.aws.amazon.com/global-accelerator/latest/dg/what-is-global-accelerator.html).
 */
public interface GlobalAcceleratorClient : SdkClient {
    /**
     * GlobalAcceleratorClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, GlobalAcceleratorClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "GlobalAccelerator",
                "GLOBAL_ACCELERATOR",
                "global_accelerator",
            )
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, GlobalAcceleratorClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): GlobalAcceleratorClient = DefaultGlobalAcceleratorClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: GlobalAcceleratorEndpointProvider = builder.endpointProvider ?: DefaultGlobalAcceleratorEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: GlobalAcceleratorAuthSchemeProvider = builder.authSchemeProvider ?: DefaultGlobalAcceleratorAuthSchemeProvider()
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Global Accelerator"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: GlobalAcceleratorEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: GlobalAcceleratorAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Associate a virtual private cloud (VPC) subnet endpoint with your custom routing accelerator.
     *
     * The listener port range must be large enough to support the number of IP addresses that can be specified in your subnet. The number of ports required is: subnet size times the number of ports per destination EC2 instances. For example, a subnet defined as /24 requires a listener port range of at least 255 ports.
     *
     * Note: You must have enough remaining listener ports available to map to the subnet ports, or the call will fail with a LimitExceededException.
     *
     * By default, all destinations in a subnet in a custom routing accelerator cannot receive traffic. To enable all destinations to receive traffic, or to specify individual port mappings that can receive traffic, see the [ AllowCustomRoutingTraffic](https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html) operation.
     */
    public suspend fun addCustomRoutingEndpoints(input: AddCustomRoutingEndpointsRequest): AddCustomRoutingEndpointsResponse

    /**
     * Add endpoints to an endpoint group. The `AddEndpoints` API operation is the recommended option for adding endpoints. The alternative options are to add endpoints when you create an endpoint group (with the [CreateEndpointGroup](https://docs.aws.amazon.com/global-accelerator/latest/api/API_CreateEndpointGroup.html) API) or when you update an endpoint group (with the [UpdateEndpointGroup](https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateEndpointGroup.html) API).
     *
     * There are two advantages to using `AddEndpoints` to add endpoints in Global Accelerator:
     * + It's faster, because Global Accelerator only has to resolve the new endpoints that you're adding, rather than resolving new and existing endpoints.
     * + It's more convenient, because you don't need to specify the current endpoints that are already in the endpoint group, in addition to the new endpoints that you want to add.
     *
     * For information about endpoint types and requirements for endpoints that you can add to Global Accelerator, see [ Endpoints for standard accelerators](https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints.html) in the *Global Accelerator Developer Guide*.
     */
    public suspend fun addEndpoints(input: AddEndpointsRequest): AddEndpointsResponse

    /**
     * Advertises an IPv4 address range that is provisioned for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP). It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services because of propagation delays.
     *
     * To stop advertising the BYOIP address range, use [ WithdrawByoipCidr](https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html).
     *
     * For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the *Global Accelerator Developer Guide*.
     */
    public suspend fun advertiseByoipCidr(input: AdvertiseByoipCidrRequest): AdvertiseByoipCidrResponse

    /**
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that can receive traffic for a custom routing accelerator. You can allow traffic to all destinations in the subnet endpoint, or allow traffic to a specified list of destination IP addresses and ports in the subnet. Note that you cannot specify IP addresses or ports outside of the range that you configured for the endpoint group.
     *
     * After you make changes, you can verify that the updates are complete by checking the status of your accelerator: the status changes from IN_PROGRESS to DEPLOYED.
     */
    public suspend fun allowCustomRoutingTraffic(input: AllowCustomRoutingTrafficRequest): AllowCustomRoutingTrafficResponse

    /**
     * Create an accelerator. An accelerator includes one or more listeners that process inbound connections and direct traffic to one or more endpoint groups, each of which includes endpoints, such as Network Load Balancers.
     *
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for example, specify `--region us-west-2` on Amazon Web Services CLI commands.
     */
    public suspend fun createAccelerator(input: CreateAcceleratorRequest): CreateAcceleratorResponse

    /**
     * Create a custom routing accelerator. A custom routing accelerator directs traffic to one of possibly thousands of Amazon EC2 instance destinations running in a single or multiple virtual private clouds (VPC) subnet endpoints.
     *
     * Be aware that, by default, all destination EC2 instances in a VPC subnet endpoint cannot receive traffic. To enable all destinations to receive traffic, or to specify individual port mappings that can receive traffic, see the [ AllowCustomRoutingTraffic](https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html) operation.
     *
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for example, specify `--region us-west-2` on Amazon Web Services CLI commands.
     */
    public suspend fun createCustomRoutingAccelerator(input: CreateCustomRoutingAcceleratorRequest): CreateCustomRoutingAcceleratorResponse

    /**
     * Create an endpoint group for the specified listener for a custom routing accelerator. An endpoint group is a collection of endpoints in one Amazon Web Services Region.
     */
    public suspend fun createCustomRoutingEndpointGroup(input: CreateCustomRoutingEndpointGroupRequest): CreateCustomRoutingEndpointGroupResponse

    /**
     * Create a listener to process inbound connections from clients to a custom routing accelerator. Connections arrive to assigned static IP addresses on the port range that you specify.
     */
    public suspend fun createCustomRoutingListener(input: CreateCustomRoutingListenerRequest): CreateCustomRoutingListenerResponse

    /**
     * Create an endpoint group for the specified listener. An endpoint group is a collection of endpoints in one Amazon Web Services Region. A resource must be valid and active when you add it as an endpoint.
     *
     * For more information about endpoint types and requirements for endpoints that you can add to Global Accelerator, see [ Endpoints for standard accelerators](https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints.html) in the *Global Accelerator Developer Guide*.
     */
    public suspend fun createEndpointGroup(input: CreateEndpointGroupRequest): CreateEndpointGroupResponse

    /**
     * Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned static IP addresses on a port, port range, or list of port ranges that you specify.
     */
    public suspend fun createListener(input: CreateListenerRequest): CreateListenerResponse

    /**
     * Delete an accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set `Enabled` to false.
     *
     * When you create an accelerator, by default, Global Accelerator provides you with a set of two static IP addresses. Alternatively, you can bring your own IP address ranges to Global Accelerator and assign IP addresses from those ranges.
     *
     * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator and it no longer accepts or routes traffic. However, when you *delete* an accelerator, you lose the static IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information, see [Identity and access management](https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html) in the *Global Accelerator Developer Guide*.
     */
    public suspend fun deleteAccelerator(input: DeleteAcceleratorRequest): DeleteAcceleratorResponse

    /**
     * Delete a custom routing accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set `Enabled` to false.
     *
     * When you create a custom routing accelerator, by default, Global Accelerator provides you with a set of two static IP addresses.
     *
     * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator and it no longer accepts or routes traffic. However, when you *delete* an accelerator, you lose the static IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information, see [Identity and access management](https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html) in the *Global Accelerator Developer Guide*.
     */
    public suspend fun deleteCustomRoutingAccelerator(input: DeleteCustomRoutingAcceleratorRequest): DeleteCustomRoutingAcceleratorResponse

    /**
     * Delete an endpoint group from a listener for a custom routing accelerator.
     */
    public suspend fun deleteCustomRoutingEndpointGroup(input: DeleteCustomRoutingEndpointGroupRequest): DeleteCustomRoutingEndpointGroupResponse

    /**
     * Delete a listener for a custom routing accelerator.
     */
    public suspend fun deleteCustomRoutingListener(input: DeleteCustomRoutingListenerRequest): DeleteCustomRoutingListenerResponse

    /**
     * Delete an endpoint group from a listener.
     */
    public suspend fun deleteEndpointGroup(input: DeleteEndpointGroupRequest): DeleteEndpointGroupResponse

    /**
     * Delete a listener from an accelerator.
     */
    public suspend fun deleteListener(input: DeleteListenerRequest): DeleteListenerResponse

    /**
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that cannot receive traffic for a custom routing accelerator. You can deny traffic to all destinations in the VPC endpoint, or deny traffic to a specified list of destination IP addresses and ports. Note that you cannot specify IP addresses or ports outside of the range that you configured for the endpoint group.
     *
     * After you make changes, you can verify that the updates are complete by checking the status of your accelerator: the status changes from IN_PROGRESS to DEPLOYED.
     */
    public suspend fun denyCustomRoutingTraffic(input: DenyCustomRoutingTrafficRequest): DenyCustomRoutingTrafficResponse

    /**
     * Releases the specified address range that you provisioned to use with your Amazon Web Services resources through bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     *
     * Before you can release an address range, you must stop advertising it by using [WithdrawByoipCidr](https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html) and you must not have any accelerators that are using static IP addresses allocated from its address range.
     *
     * For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the *Global Accelerator Developer Guide*.
     */
    public suspend fun deprovisionByoipCidr(input: DeprovisionByoipCidrRequest): DeprovisionByoipCidrResponse

    /**
     * Describe an accelerator.
     */
    public suspend fun describeAccelerator(input: DescribeAcceleratorRequest): DescribeAcceleratorResponse

    /**
     * Describe the attributes of an accelerator.
     */
    public suspend fun describeAcceleratorAttributes(input: DescribeAcceleratorAttributesRequest): DescribeAcceleratorAttributesResponse

    /**
     * Describe a custom routing accelerator.
     */
    public suspend fun describeCustomRoutingAccelerator(input: DescribeCustomRoutingAcceleratorRequest): DescribeCustomRoutingAcceleratorResponse

    /**
     * Describe the attributes of a custom routing accelerator.
     */
    public suspend fun describeCustomRoutingAcceleratorAttributes(input: DescribeCustomRoutingAcceleratorAttributesRequest): DescribeCustomRoutingAcceleratorAttributesResponse

    /**
     * Describe an endpoint group for a custom routing accelerator.
     */
    public suspend fun describeCustomRoutingEndpointGroup(input: DescribeCustomRoutingEndpointGroupRequest): DescribeCustomRoutingEndpointGroupResponse

    /**
     * The description of a listener for a custom routing accelerator.
     */
    public suspend fun describeCustomRoutingListener(input: DescribeCustomRoutingListenerRequest): DescribeCustomRoutingListenerResponse

    /**
     * Describe an endpoint group.
     */
    public suspend fun describeEndpointGroup(input: DescribeEndpointGroupRequest): DescribeEndpointGroupResponse

    /**
     * Describe a listener.
     */
    public suspend fun describeListener(input: DescribeListenerRequest): DescribeListenerResponse

    /**
     * List the accelerators for an Amazon Web Services account.
     */
    public suspend fun listAccelerators(input: ListAcceleratorsRequest = ListAcceleratorsRequest { }): ListAcceleratorsResponse

    /**
     * Lists the IP address ranges that were specified in calls to [ProvisionByoipCidr](https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html), including the current state and a history of state changes.
     */
    public suspend fun listByoipCidrs(input: ListByoipCidrsRequest = ListByoipCidrsRequest { }): ListByoipCidrsResponse

    /**
     * List the custom routing accelerators for an Amazon Web Services account.
     */
    public suspend fun listCustomRoutingAccelerators(input: ListCustomRoutingAcceleratorsRequest = ListCustomRoutingAcceleratorsRequest { }): ListCustomRoutingAcceleratorsResponse

    /**
     * List the endpoint groups that are associated with a listener for a custom routing accelerator.
     */
    public suspend fun listCustomRoutingEndpointGroups(input: ListCustomRoutingEndpointGroupsRequest): ListCustomRoutingEndpointGroupsResponse

    /**
     * List the listeners for a custom routing accelerator.
     */
    public suspend fun listCustomRoutingListeners(input: ListCustomRoutingListenersRequest): ListCustomRoutingListenersResponse

    /**
     * Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance IP addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator. For each subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on your servers.
     *
     * If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add a subnet to your accelerator, Global Accelerator creates new port mappings (the existing ones don't change). If you add or remove EC2 instances in your subnet, the port mappings don't change, because the mappings are created when you add the subnet to Global Accelerator.
     *
     * The mappings also include a flag for each destination denoting which destination IP addresses and ports are allowed or denied traffic.
     */
    public suspend fun listCustomRoutingPortMappings(input: ListCustomRoutingPortMappingsRequest): ListCustomRoutingPortMappingsResponse

    /**
     * List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The response is the mappings for one destination IP address. This is useful when your subnet endpoint has mappings that span multiple custom routing accelerators in your account, or for scenarios where you only want to list the port mappings for a specific destination instance.
     */
    public suspend fun listCustomRoutingPortMappingsByDestination(input: ListCustomRoutingPortMappingsByDestinationRequest): ListCustomRoutingPortMappingsByDestinationResponse

    /**
     * List the endpoint groups that are associated with a listener.
     */
    public suspend fun listEndpointGroups(input: ListEndpointGroupsRequest): ListEndpointGroupsResponse

    /**
     * List the listeners for an accelerator.
     */
    public suspend fun listListeners(input: ListListenersRequest): ListListenersResponse

    /**
     * List all tags for an accelerator.
     *
     * For more information, see [Tagging in Global Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html) in the *Global Accelerator Developer Guide*.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Provisions an IP address range to use with your Amazon Web Services resources through bring your own IP addresses (BYOIP) and creates a corresponding address pool. After the address range is provisioned, it is ready to be advertised using [ AdvertiseByoipCidr](https://docs.aws.amazon.com/global-accelerator/latest/api/AdvertiseByoipCidr.html).
     *
     * For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the *Global Accelerator Developer Guide*.
     */
    public suspend fun provisionByoipCidr(input: ProvisionByoipCidrRequest): ProvisionByoipCidrResponse

    /**
     * Remove endpoints from a custom routing accelerator.
     */
    public suspend fun removeCustomRoutingEndpoints(input: RemoveCustomRoutingEndpointsRequest): RemoveCustomRoutingEndpointsResponse

    /**
     * Remove endpoints from an endpoint group.
     *
     * The `RemoveEndpoints` API operation is the recommended option for removing endpoints. The alternative is to remove endpoints by updating an endpoint group by using the [UpdateEndpointGroup](https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateEndpointGroup.html) API operation. There are two advantages to using `AddEndpoints` to remove endpoints instead:
     * + It's more convenient, because you only need to specify the endpoints that you want to remove. With the `UpdateEndpointGroup` API operation, you must specify all of the endpoints in the endpoint group except the ones that you want to remove from the group.
     * + It's faster, because Global Accelerator doesn't need to resolve any endpoints. With the `UpdateEndpointGroup` API operation, Global Accelerator must resolve all of the endpoints that remain in the group.
     */
    public suspend fun removeEndpoints(input: RemoveEndpointsRequest): RemoveEndpointsResponse

    /**
     * Add tags to an accelerator resource.
     *
     * For more information, see [Tagging in Global Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html) in the *Global Accelerator Developer Guide*.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Remove tags from a Global Accelerator resource. When you specify a tag key, the action removes both that key and its associated value. The operation succeeds even if you attempt to remove tags from an accelerator that was already removed.
     *
     * For more information, see [Tagging in Global Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html) in the *Global Accelerator Developer Guide*.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Update an accelerator to make changes, such as the following:
     * + Change the name of the accelerator.
     * + Disable the accelerator so that it no longer accepts or routes traffic, or so that you can delete it.
     * + Enable the accelerator, if it is disabled.
     * + Change the IP address type to dual-stack if it is IPv4, or change the IP address type to IPv4 if it's dual-stack.
     *
     * Be aware that static IP addresses remain assigned to your accelerator for as long as it exists, even if you disable the accelerator and it no longer accepts or routes traffic. However, when you delete the accelerator, you lose the static IP addresses that are assigned to it, so you can no longer route traffic by using them.
     *
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for example, specify `--region us-west-2` on Amazon Web Services CLI commands.
     */
    public suspend fun updateAccelerator(input: UpdateAcceleratorRequest): UpdateAcceleratorResponse

    /**
     * Update the attributes for an accelerator.
     */
    public suspend fun updateAcceleratorAttributes(input: UpdateAcceleratorAttributesRequest): UpdateAcceleratorAttributesResponse

    /**
     * Update a custom routing accelerator.
     */
    public suspend fun updateCustomRoutingAccelerator(input: UpdateCustomRoutingAcceleratorRequest): UpdateCustomRoutingAcceleratorResponse

    /**
     * Update the attributes for a custom routing accelerator.
     */
    public suspend fun updateCustomRoutingAcceleratorAttributes(input: UpdateCustomRoutingAcceleratorAttributesRequest): UpdateCustomRoutingAcceleratorAttributesResponse

    /**
     * Update a listener for a custom routing accelerator.
     */
    public suspend fun updateCustomRoutingListener(input: UpdateCustomRoutingListenerRequest): UpdateCustomRoutingListenerResponse

    /**
     * Update an endpoint group. A resource must be valid and active when you add it as an endpoint.
     */
    public suspend fun updateEndpointGroup(input: UpdateEndpointGroupRequest): UpdateEndpointGroupResponse

    /**
     * Update a listener.
     */
    public suspend fun updateListener(input: UpdateListenerRequest): UpdateListenerResponse

    /**
     * Stops advertising an address range that is provisioned as an address pool. You can perform this operation at most once every 10 seconds, even if you specify different address ranges each time.
     *
     * It can take a few minutes before traffic to the specified addresses stops routing to Amazon Web Services because of propagation delays.
     *
     * For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the *Global Accelerator Developer Guide*.
     */
    public suspend fun withdrawByoipCidr(input: WithdrawByoipCidrRequest): WithdrawByoipCidrResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun GlobalAcceleratorClient.withConfig(block: GlobalAcceleratorClient.Config.Builder.() -> Unit): GlobalAcceleratorClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultGlobalAcceleratorClient(newConfig)
}

/**
 * Associate a virtual private cloud (VPC) subnet endpoint with your custom routing accelerator.
 *
 * The listener port range must be large enough to support the number of IP addresses that can be specified in your subnet. The number of ports required is: subnet size times the number of ports per destination EC2 instances. For example, a subnet defined as /24 requires a listener port range of at least 255 ports.
 *
 * Note: You must have enough remaining listener ports available to map to the subnet ports, or the call will fail with a LimitExceededException.
 *
 * By default, all destinations in a subnet in a custom routing accelerator cannot receive traffic. To enable all destinations to receive traffic, or to specify individual port mappings that can receive traffic, see the [ AllowCustomRoutingTraffic](https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html) operation.
 */
public suspend inline fun GlobalAcceleratorClient.addCustomRoutingEndpoints(crossinline block: AddCustomRoutingEndpointsRequest.Builder.() -> Unit): AddCustomRoutingEndpointsResponse = addCustomRoutingEndpoints(AddCustomRoutingEndpointsRequest.Builder().apply(block).build())

/**
 * Add endpoints to an endpoint group. The `AddEndpoints` API operation is the recommended option for adding endpoints. The alternative options are to add endpoints when you create an endpoint group (with the [CreateEndpointGroup](https://docs.aws.amazon.com/global-accelerator/latest/api/API_CreateEndpointGroup.html) API) or when you update an endpoint group (with the [UpdateEndpointGroup](https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateEndpointGroup.html) API).
 *
 * There are two advantages to using `AddEndpoints` to add endpoints in Global Accelerator:
 * + It's faster, because Global Accelerator only has to resolve the new endpoints that you're adding, rather than resolving new and existing endpoints.
 * + It's more convenient, because you don't need to specify the current endpoints that are already in the endpoint group, in addition to the new endpoints that you want to add.
 *
 * For information about endpoint types and requirements for endpoints that you can add to Global Accelerator, see [ Endpoints for standard accelerators](https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints.html) in the *Global Accelerator Developer Guide*.
 */
public suspend inline fun GlobalAcceleratorClient.addEndpoints(crossinline block: AddEndpointsRequest.Builder.() -> Unit): AddEndpointsResponse = addEndpoints(AddEndpointsRequest.Builder().apply(block).build())

/**
 * Advertises an IPv4 address range that is provisioned for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP). It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services because of propagation delays.
 *
 * To stop advertising the BYOIP address range, use [ WithdrawByoipCidr](https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html).
 *
 * For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the *Global Accelerator Developer Guide*.
 */
public suspend inline fun GlobalAcceleratorClient.advertiseByoipCidr(crossinline block: AdvertiseByoipCidrRequest.Builder.() -> Unit): AdvertiseByoipCidrResponse = advertiseByoipCidr(AdvertiseByoipCidrRequest.Builder().apply(block).build())

/**
 * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that can receive traffic for a custom routing accelerator. You can allow traffic to all destinations in the subnet endpoint, or allow traffic to a specified list of destination IP addresses and ports in the subnet. Note that you cannot specify IP addresses or ports outside of the range that you configured for the endpoint group.
 *
 * After you make changes, you can verify that the updates are complete by checking the status of your accelerator: the status changes from IN_PROGRESS to DEPLOYED.
 */
public suspend inline fun GlobalAcceleratorClient.allowCustomRoutingTraffic(crossinline block: AllowCustomRoutingTrafficRequest.Builder.() -> Unit): AllowCustomRoutingTrafficResponse = allowCustomRoutingTraffic(AllowCustomRoutingTrafficRequest.Builder().apply(block).build())

/**
 * Create an accelerator. An accelerator includes one or more listeners that process inbound connections and direct traffic to one or more endpoint groups, each of which includes endpoints, such as Network Load Balancers.
 *
 * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for example, specify `--region us-west-2` on Amazon Web Services CLI commands.
 */
public suspend inline fun GlobalAcceleratorClient.createAccelerator(crossinline block: CreateAcceleratorRequest.Builder.() -> Unit): CreateAcceleratorResponse = createAccelerator(CreateAcceleratorRequest.Builder().apply(block).build())

/**
 * Create a custom routing accelerator. A custom routing accelerator directs traffic to one of possibly thousands of Amazon EC2 instance destinations running in a single or multiple virtual private clouds (VPC) subnet endpoints.
 *
 * Be aware that, by default, all destination EC2 instances in a VPC subnet endpoint cannot receive traffic. To enable all destinations to receive traffic, or to specify individual port mappings that can receive traffic, see the [ AllowCustomRoutingTraffic](https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html) operation.
 *
 * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for example, specify `--region us-west-2` on Amazon Web Services CLI commands.
 */
public suspend inline fun GlobalAcceleratorClient.createCustomRoutingAccelerator(crossinline block: CreateCustomRoutingAcceleratorRequest.Builder.() -> Unit): CreateCustomRoutingAcceleratorResponse = createCustomRoutingAccelerator(CreateCustomRoutingAcceleratorRequest.Builder().apply(block).build())

/**
 * Create an endpoint group for the specified listener for a custom routing accelerator. An endpoint group is a collection of endpoints in one Amazon Web Services Region.
 */
public suspend inline fun GlobalAcceleratorClient.createCustomRoutingEndpointGroup(crossinline block: CreateCustomRoutingEndpointGroupRequest.Builder.() -> Unit): CreateCustomRoutingEndpointGroupResponse = createCustomRoutingEndpointGroup(CreateCustomRoutingEndpointGroupRequest.Builder().apply(block).build())

/**
 * Create a listener to process inbound connections from clients to a custom routing accelerator. Connections arrive to assigned static IP addresses on the port range that you specify.
 */
public suspend inline fun GlobalAcceleratorClient.createCustomRoutingListener(crossinline block: CreateCustomRoutingListenerRequest.Builder.() -> Unit): CreateCustomRoutingListenerResponse = createCustomRoutingListener(CreateCustomRoutingListenerRequest.Builder().apply(block).build())

/**
 * Create an endpoint group for the specified listener. An endpoint group is a collection of endpoints in one Amazon Web Services Region. A resource must be valid and active when you add it as an endpoint.
 *
 * For more information about endpoint types and requirements for endpoints that you can add to Global Accelerator, see [ Endpoints for standard accelerators](https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoints.html) in the *Global Accelerator Developer Guide*.
 */
public suspend inline fun GlobalAcceleratorClient.createEndpointGroup(crossinline block: CreateEndpointGroupRequest.Builder.() -> Unit): CreateEndpointGroupResponse = createEndpointGroup(CreateEndpointGroupRequest.Builder().apply(block).build())

/**
 * Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned static IP addresses on a port, port range, or list of port ranges that you specify.
 */
public suspend inline fun GlobalAcceleratorClient.createListener(crossinline block: CreateListenerRequest.Builder.() -> Unit): CreateListenerResponse = createListener(CreateListenerRequest.Builder().apply(block).build())

/**
 * Delete an accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set `Enabled` to false.
 *
 * When you create an accelerator, by default, Global Accelerator provides you with a set of two static IP addresses. Alternatively, you can bring your own IP address ranges to Global Accelerator and assign IP addresses from those ranges.
 *
 * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator and it no longer accepts or routes traffic. However, when you *delete* an accelerator, you lose the static IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information, see [Identity and access management](https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html) in the *Global Accelerator Developer Guide*.
 */
public suspend inline fun GlobalAcceleratorClient.deleteAccelerator(crossinline block: DeleteAcceleratorRequest.Builder.() -> Unit): DeleteAcceleratorResponse = deleteAccelerator(DeleteAcceleratorRequest.Builder().apply(block).build())

/**
 * Delete a custom routing accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set `Enabled` to false.
 *
 * When you create a custom routing accelerator, by default, Global Accelerator provides you with a set of two static IP addresses.
 *
 * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator and it no longer accepts or routes traffic. However, when you *delete* an accelerator, you lose the static IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information, see [Identity and access management](https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html) in the *Global Accelerator Developer Guide*.
 */
public suspend inline fun GlobalAcceleratorClient.deleteCustomRoutingAccelerator(crossinline block: DeleteCustomRoutingAcceleratorRequest.Builder.() -> Unit): DeleteCustomRoutingAcceleratorResponse = deleteCustomRoutingAccelerator(DeleteCustomRoutingAcceleratorRequest.Builder().apply(block).build())

/**
 * Delete an endpoint group from a listener for a custom routing accelerator.
 */
public suspend inline fun GlobalAcceleratorClient.deleteCustomRoutingEndpointGroup(crossinline block: DeleteCustomRoutingEndpointGroupRequest.Builder.() -> Unit): DeleteCustomRoutingEndpointGroupResponse = deleteCustomRoutingEndpointGroup(DeleteCustomRoutingEndpointGroupRequest.Builder().apply(block).build())

/**
 * Delete a listener for a custom routing accelerator.
 */
public suspend inline fun GlobalAcceleratorClient.deleteCustomRoutingListener(crossinline block: DeleteCustomRoutingListenerRequest.Builder.() -> Unit): DeleteCustomRoutingListenerResponse = deleteCustomRoutingListener(DeleteCustomRoutingListenerRequest.Builder().apply(block).build())

/**
 * Delete an endpoint group from a listener.
 */
public suspend inline fun GlobalAcceleratorClient.deleteEndpointGroup(crossinline block: DeleteEndpointGroupRequest.Builder.() -> Unit): DeleteEndpointGroupResponse = deleteEndpointGroup(DeleteEndpointGroupRequest.Builder().apply(block).build())

/**
 * Delete a listener from an accelerator.
 */
public suspend inline fun GlobalAcceleratorClient.deleteListener(crossinline block: DeleteListenerRequest.Builder.() -> Unit): DeleteListenerResponse = deleteListener(DeleteListenerRequest.Builder().apply(block).build())

/**
 * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that cannot receive traffic for a custom routing accelerator. You can deny traffic to all destinations in the VPC endpoint, or deny traffic to a specified list of destination IP addresses and ports. Note that you cannot specify IP addresses or ports outside of the range that you configured for the endpoint group.
 *
 * After you make changes, you can verify that the updates are complete by checking the status of your accelerator: the status changes from IN_PROGRESS to DEPLOYED.
 */
public suspend inline fun GlobalAcceleratorClient.denyCustomRoutingTraffic(crossinline block: DenyCustomRoutingTrafficRequest.Builder.() -> Unit): DenyCustomRoutingTrafficResponse = denyCustomRoutingTraffic(DenyCustomRoutingTrafficRequest.Builder().apply(block).build())

/**
 * Releases the specified address range that you provisioned to use with your Amazon Web Services resources through bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
 *
 * Before you can release an address range, you must stop advertising it by using [WithdrawByoipCidr](https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html) and you must not have any accelerators that are using static IP addresses allocated from its address range.
 *
 * For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the *Global Accelerator Developer Guide*.
 */
public suspend inline fun GlobalAcceleratorClient.deprovisionByoipCidr(crossinline block: DeprovisionByoipCidrRequest.Builder.() -> Unit): DeprovisionByoipCidrResponse = deprovisionByoipCidr(DeprovisionByoipCidrRequest.Builder().apply(block).build())

/**
 * Describe an accelerator.
 */
public suspend inline fun GlobalAcceleratorClient.describeAccelerator(crossinline block: DescribeAcceleratorRequest.Builder.() -> Unit): DescribeAcceleratorResponse = describeAccelerator(DescribeAcceleratorRequest.Builder().apply(block).build())

/**
 * Describe the attributes of an accelerator.
 */
public suspend inline fun GlobalAcceleratorClient.describeAcceleratorAttributes(crossinline block: DescribeAcceleratorAttributesRequest.Builder.() -> Unit): DescribeAcceleratorAttributesResponse = describeAcceleratorAttributes(DescribeAcceleratorAttributesRequest.Builder().apply(block).build())

/**
 * Describe a custom routing accelerator.
 */
public suspend inline fun GlobalAcceleratorClient.describeCustomRoutingAccelerator(crossinline block: DescribeCustomRoutingAcceleratorRequest.Builder.() -> Unit): DescribeCustomRoutingAcceleratorResponse = describeCustomRoutingAccelerator(DescribeCustomRoutingAcceleratorRequest.Builder().apply(block).build())

/**
 * Describe the attributes of a custom routing accelerator.
 */
public suspend inline fun GlobalAcceleratorClient.describeCustomRoutingAcceleratorAttributes(crossinline block: DescribeCustomRoutingAcceleratorAttributesRequest.Builder.() -> Unit): DescribeCustomRoutingAcceleratorAttributesResponse = describeCustomRoutingAcceleratorAttributes(DescribeCustomRoutingAcceleratorAttributesRequest.Builder().apply(block).build())

/**
 * Describe an endpoint group for a custom routing accelerator.
 */
public suspend inline fun GlobalAcceleratorClient.describeCustomRoutingEndpointGroup(crossinline block: DescribeCustomRoutingEndpointGroupRequest.Builder.() -> Unit): DescribeCustomRoutingEndpointGroupResponse = describeCustomRoutingEndpointGroup(DescribeCustomRoutingEndpointGroupRequest.Builder().apply(block).build())

/**
 * The description of a listener for a custom routing accelerator.
 */
public suspend inline fun GlobalAcceleratorClient.describeCustomRoutingListener(crossinline block: DescribeCustomRoutingListenerRequest.Builder.() -> Unit): DescribeCustomRoutingListenerResponse = describeCustomRoutingListener(DescribeCustomRoutingListenerRequest.Builder().apply(block).build())

/**
 * Describe an endpoint group.
 */
public suspend inline fun GlobalAcceleratorClient.describeEndpointGroup(crossinline block: DescribeEndpointGroupRequest.Builder.() -> Unit): DescribeEndpointGroupResponse = describeEndpointGroup(DescribeEndpointGroupRequest.Builder().apply(block).build())

/**
 * Describe a listener.
 */
public suspend inline fun GlobalAcceleratorClient.describeListener(crossinline block: DescribeListenerRequest.Builder.() -> Unit): DescribeListenerResponse = describeListener(DescribeListenerRequest.Builder().apply(block).build())

/**
 * List the accelerators for an Amazon Web Services account.
 */
public suspend inline fun GlobalAcceleratorClient.listAccelerators(crossinline block: ListAcceleratorsRequest.Builder.() -> Unit): ListAcceleratorsResponse = listAccelerators(ListAcceleratorsRequest.Builder().apply(block).build())

/**
 * Lists the IP address ranges that were specified in calls to [ProvisionByoipCidr](https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html), including the current state and a history of state changes.
 */
public suspend inline fun GlobalAcceleratorClient.listByoipCidrs(crossinline block: ListByoipCidrsRequest.Builder.() -> Unit): ListByoipCidrsResponse = listByoipCidrs(ListByoipCidrsRequest.Builder().apply(block).build())

/**
 * List the custom routing accelerators for an Amazon Web Services account.
 */
public suspend inline fun GlobalAcceleratorClient.listCustomRoutingAccelerators(crossinline block: ListCustomRoutingAcceleratorsRequest.Builder.() -> Unit): ListCustomRoutingAcceleratorsResponse = listCustomRoutingAccelerators(ListCustomRoutingAcceleratorsRequest.Builder().apply(block).build())

/**
 * List the endpoint groups that are associated with a listener for a custom routing accelerator.
 */
public suspend inline fun GlobalAcceleratorClient.listCustomRoutingEndpointGroups(crossinline block: ListCustomRoutingEndpointGroupsRequest.Builder.() -> Unit): ListCustomRoutingEndpointGroupsResponse = listCustomRoutingEndpointGroups(ListCustomRoutingEndpointGroupsRequest.Builder().apply(block).build())

/**
 * List the listeners for a custom routing accelerator.
 */
public suspend inline fun GlobalAcceleratorClient.listCustomRoutingListeners(crossinline block: ListCustomRoutingListenersRequest.Builder.() -> Unit): ListCustomRoutingListenersResponse = listCustomRoutingListeners(ListCustomRoutingListenersRequest.Builder().apply(block).build())

/**
 * Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance IP addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator. For each subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on your servers.
 *
 * If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add a subnet to your accelerator, Global Accelerator creates new port mappings (the existing ones don't change). If you add or remove EC2 instances in your subnet, the port mappings don't change, because the mappings are created when you add the subnet to Global Accelerator.
 *
 * The mappings also include a flag for each destination denoting which destination IP addresses and ports are allowed or denied traffic.
 */
public suspend inline fun GlobalAcceleratorClient.listCustomRoutingPortMappings(crossinline block: ListCustomRoutingPortMappingsRequest.Builder.() -> Unit): ListCustomRoutingPortMappingsResponse = listCustomRoutingPortMappings(ListCustomRoutingPortMappingsRequest.Builder().apply(block).build())

/**
 * List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The response is the mappings for one destination IP address. This is useful when your subnet endpoint has mappings that span multiple custom routing accelerators in your account, or for scenarios where you only want to list the port mappings for a specific destination instance.
 */
public suspend inline fun GlobalAcceleratorClient.listCustomRoutingPortMappingsByDestination(crossinline block: ListCustomRoutingPortMappingsByDestinationRequest.Builder.() -> Unit): ListCustomRoutingPortMappingsByDestinationResponse = listCustomRoutingPortMappingsByDestination(ListCustomRoutingPortMappingsByDestinationRequest.Builder().apply(block).build())

/**
 * List the endpoint groups that are associated with a listener.
 */
public suspend inline fun GlobalAcceleratorClient.listEndpointGroups(crossinline block: ListEndpointGroupsRequest.Builder.() -> Unit): ListEndpointGroupsResponse = listEndpointGroups(ListEndpointGroupsRequest.Builder().apply(block).build())

/**
 * List the listeners for an accelerator.
 */
public suspend inline fun GlobalAcceleratorClient.listListeners(crossinline block: ListListenersRequest.Builder.() -> Unit): ListListenersResponse = listListeners(ListListenersRequest.Builder().apply(block).build())

/**
 * List all tags for an accelerator.
 *
 * For more information, see [Tagging in Global Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html) in the *Global Accelerator Developer Guide*.
 */
public suspend inline fun GlobalAcceleratorClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Provisions an IP address range to use with your Amazon Web Services resources through bring your own IP addresses (BYOIP) and creates a corresponding address pool. After the address range is provisioned, it is ready to be advertised using [ AdvertiseByoipCidr](https://docs.aws.amazon.com/global-accelerator/latest/api/AdvertiseByoipCidr.html).
 *
 * For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the *Global Accelerator Developer Guide*.
 */
public suspend inline fun GlobalAcceleratorClient.provisionByoipCidr(crossinline block: ProvisionByoipCidrRequest.Builder.() -> Unit): ProvisionByoipCidrResponse = provisionByoipCidr(ProvisionByoipCidrRequest.Builder().apply(block).build())

/**
 * Remove endpoints from a custom routing accelerator.
 */
public suspend inline fun GlobalAcceleratorClient.removeCustomRoutingEndpoints(crossinline block: RemoveCustomRoutingEndpointsRequest.Builder.() -> Unit): RemoveCustomRoutingEndpointsResponse = removeCustomRoutingEndpoints(RemoveCustomRoutingEndpointsRequest.Builder().apply(block).build())

/**
 * Remove endpoints from an endpoint group.
 *
 * The `RemoveEndpoints` API operation is the recommended option for removing endpoints. The alternative is to remove endpoints by updating an endpoint group by using the [UpdateEndpointGroup](https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateEndpointGroup.html) API operation. There are two advantages to using `AddEndpoints` to remove endpoints instead:
 * + It's more convenient, because you only need to specify the endpoints that you want to remove. With the `UpdateEndpointGroup` API operation, you must specify all of the endpoints in the endpoint group except the ones that you want to remove from the group.
 * + It's faster, because Global Accelerator doesn't need to resolve any endpoints. With the `UpdateEndpointGroup` API operation, Global Accelerator must resolve all of the endpoints that remain in the group.
 */
public suspend inline fun GlobalAcceleratorClient.removeEndpoints(crossinline block: RemoveEndpointsRequest.Builder.() -> Unit): RemoveEndpointsResponse = removeEndpoints(RemoveEndpointsRequest.Builder().apply(block).build())

/**
 * Add tags to an accelerator resource.
 *
 * For more information, see [Tagging in Global Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html) in the *Global Accelerator Developer Guide*.
 */
public suspend inline fun GlobalAcceleratorClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Remove tags from a Global Accelerator resource. When you specify a tag key, the action removes both that key and its associated value. The operation succeeds even if you attempt to remove tags from an accelerator that was already removed.
 *
 * For more information, see [Tagging in Global Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html) in the *Global Accelerator Developer Guide*.
 */
public suspend inline fun GlobalAcceleratorClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Update an accelerator to make changes, such as the following:
 * + Change the name of the accelerator.
 * + Disable the accelerator so that it no longer accepts or routes traffic, or so that you can delete it.
 * + Enable the accelerator, if it is disabled.
 * + Change the IP address type to dual-stack if it is IPv4, or change the IP address type to IPv4 if it's dual-stack.
 *
 * Be aware that static IP addresses remain assigned to your accelerator for as long as it exists, even if you disable the accelerator and it no longer accepts or routes traffic. However, when you delete the accelerator, you lose the static IP addresses that are assigned to it, so you can no longer route traffic by using them.
 *
 * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for example, specify `--region us-west-2` on Amazon Web Services CLI commands.
 */
public suspend inline fun GlobalAcceleratorClient.updateAccelerator(crossinline block: UpdateAcceleratorRequest.Builder.() -> Unit): UpdateAcceleratorResponse = updateAccelerator(UpdateAcceleratorRequest.Builder().apply(block).build())

/**
 * Update the attributes for an accelerator.
 */
public suspend inline fun GlobalAcceleratorClient.updateAcceleratorAttributes(crossinline block: UpdateAcceleratorAttributesRequest.Builder.() -> Unit): UpdateAcceleratorAttributesResponse = updateAcceleratorAttributes(UpdateAcceleratorAttributesRequest.Builder().apply(block).build())

/**
 * Update a custom routing accelerator.
 */
public suspend inline fun GlobalAcceleratorClient.updateCustomRoutingAccelerator(crossinline block: UpdateCustomRoutingAcceleratorRequest.Builder.() -> Unit): UpdateCustomRoutingAcceleratorResponse = updateCustomRoutingAccelerator(UpdateCustomRoutingAcceleratorRequest.Builder().apply(block).build())

/**
 * Update the attributes for a custom routing accelerator.
 */
public suspend inline fun GlobalAcceleratorClient.updateCustomRoutingAcceleratorAttributes(crossinline block: UpdateCustomRoutingAcceleratorAttributesRequest.Builder.() -> Unit): UpdateCustomRoutingAcceleratorAttributesResponse = updateCustomRoutingAcceleratorAttributes(UpdateCustomRoutingAcceleratorAttributesRequest.Builder().apply(block).build())

/**
 * Update a listener for a custom routing accelerator.
 */
public suspend inline fun GlobalAcceleratorClient.updateCustomRoutingListener(crossinline block: UpdateCustomRoutingListenerRequest.Builder.() -> Unit): UpdateCustomRoutingListenerResponse = updateCustomRoutingListener(UpdateCustomRoutingListenerRequest.Builder().apply(block).build())

/**
 * Update an endpoint group. A resource must be valid and active when you add it as an endpoint.
 */
public suspend inline fun GlobalAcceleratorClient.updateEndpointGroup(crossinline block: UpdateEndpointGroupRequest.Builder.() -> Unit): UpdateEndpointGroupResponse = updateEndpointGroup(UpdateEndpointGroupRequest.Builder().apply(block).build())

/**
 * Update a listener.
 */
public suspend inline fun GlobalAcceleratorClient.updateListener(crossinline block: UpdateListenerRequest.Builder.() -> Unit): UpdateListenerResponse = updateListener(UpdateListenerRequest.Builder().apply(block).build())

/**
 * Stops advertising an address range that is provisioned as an address pool. You can perform this operation at most once every 10 seconds, even if you specify different address ranges each time.
 *
 * It can take a few minutes before traffic to the specified addresses stops routing to Amazon Web Services because of propagation delays.
 *
 * For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the *Global Accelerator Developer Guide*.
 */
public suspend inline fun GlobalAcceleratorClient.withdrawByoipCidr(crossinline block: WithdrawByoipCidrRequest.Builder.() -> Unit): WithdrawByoipCidrResponse = withdrawByoipCidr(WithdrawByoipCidrRequest.Builder().apply(block).build())
