// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model



public class UpdateCustomRoutingAcceleratorAttributesRequest private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the custom routing accelerator to update attributes for.
     */
    public val acceleratorArn: kotlin.String? = builder.acceleratorArn
    /**
     * Update whether flow logs are enabled. The default value is false. If the value is true, `FlowLogsS3Bucket` and `FlowLogsS3Prefix` must be specified.
     *
     * For more information, see [Flow logs](https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html) in the *Global Accelerator Developer Guide*.
     */
    public val flowLogsEnabled: kotlin.Boolean? = builder.flowLogsEnabled
    /**
     * The name of the Amazon S3 bucket for the flow logs. Attribute is required if `FlowLogsEnabled` is `true`. The bucket must exist and have a bucket policy that grants Global Accelerator permission to write to the bucket.
     */
    public val flowLogsS3Bucket: kotlin.String? = builder.flowLogsS3Bucket
    /**
     * Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if `FlowLogsEnabled` is `true`.
     *
     * If you don’t specify a prefix, the flow logs are stored in the root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:
     *
     * DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id
     */
    public val flowLogsS3Prefix: kotlin.String? = builder.flowLogsS3Prefix

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateCustomRoutingAcceleratorAttributesRequest(")
        append("acceleratorArn=$acceleratorArn,")
        append("flowLogsEnabled=$flowLogsEnabled,")
        append("flowLogsS3Bucket=$flowLogsS3Bucket,")
        append("flowLogsS3Prefix=$flowLogsS3Prefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceleratorArn?.hashCode() ?: 0
        result = 31 * result + (flowLogsEnabled?.hashCode() ?: 0)
        result = 31 * result + (flowLogsS3Bucket?.hashCode() ?: 0)
        result = 31 * result + (flowLogsS3Prefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateCustomRoutingAcceleratorAttributesRequest

        if (acceleratorArn != other.acceleratorArn) return false
        if (flowLogsEnabled != other.flowLogsEnabled) return false
        if (flowLogsS3Bucket != other.flowLogsS3Bucket) return false
        if (flowLogsS3Prefix != other.flowLogsS3Prefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the custom routing accelerator to update attributes for.
         */
        public var acceleratorArn: kotlin.String? = null
        /**
         * Update whether flow logs are enabled. The default value is false. If the value is true, `FlowLogsS3Bucket` and `FlowLogsS3Prefix` must be specified.
         *
         * For more information, see [Flow logs](https://docs.aws.amazon.com/global-accelerator/latest/dg/monitoring-global-accelerator.flow-logs.html) in the *Global Accelerator Developer Guide*.
         */
        public var flowLogsEnabled: kotlin.Boolean? = null
        /**
         * The name of the Amazon S3 bucket for the flow logs. Attribute is required if `FlowLogsEnabled` is `true`. The bucket must exist and have a bucket policy that grants Global Accelerator permission to write to the bucket.
         */
        public var flowLogsS3Bucket: kotlin.String? = null
        /**
         * Update the prefix for the location in the Amazon S3 bucket for the flow logs. Attribute is required if `FlowLogsEnabled` is `true`.
         *
         * If you don’t specify a prefix, the flow logs are stored in the root of the bucket. If you specify slash (/) for the S3 bucket prefix, the log file bucket folder structure will include a double slash (//), like the following:
         *
         * DOC-EXAMPLE-BUCKET//AWSLogs/aws_account_id
         */
        public var flowLogsS3Prefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest) : this() {
            this.acceleratorArn = x.acceleratorArn
            this.flowLogsEnabled = x.flowLogsEnabled
            this.flowLogsS3Bucket = x.flowLogsS3Bucket
            this.flowLogsS3Prefix = x.flowLogsS3Prefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest = UpdateCustomRoutingAcceleratorAttributesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
