// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.transform

import aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingAcceleratorAttributes
import aws.sdk.kotlin.services.globalaccelerator.model.GlobalAcceleratorException
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateCustomRoutingAcceleratorAttributesOperationDeserializer: HttpDeserialize<UpdateCustomRoutingAcceleratorAttributesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UpdateCustomRoutingAcceleratorAttributesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateCustomRoutingAcceleratorAttributesError(context, call)
        }
        val builder = UpdateCustomRoutingAcceleratorAttributesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateCustomRoutingAcceleratorAttributesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUpdateCustomRoutingAcceleratorAttributesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GlobalAcceleratorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AcceleratorNotFoundException" -> AcceleratorNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall)
        else -> GlobalAcceleratorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateCustomRoutingAcceleratorAttributesOperationBody(builder: UpdateCustomRoutingAcceleratorAttributesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ACCELERATORATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AcceleratorAttributes"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ACCELERATORATTRIBUTES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ACCELERATORATTRIBUTES_DESCRIPTOR.index -> builder.acceleratorAttributes = deserializeCustomRoutingAcceleratorAttributesDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
