// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.transform

import aws.sdk.kotlin.services.globalaccelerator.model.AddEndpointsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.EndpointDescription
import aws.sdk.kotlin.services.globalaccelerator.model.GlobalAcceleratorException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class AddEndpointsOperationDeserializer: HttpDeserialize<AddEndpointsResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): AddEndpointsResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwAddEndpointsError(context, call)
        }
        val builder = AddEndpointsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAddEndpointsOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwAddEndpointsError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw GlobalAcceleratorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall)
        "EndpointGroupNotFoundException" -> EndpointGroupNotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "TransactionInProgressException" -> TransactionInProgressExceptionDeserializer().deserialize(context, wrappedCall)
        else -> GlobalAcceleratorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAddEndpointsOperationBody(builder: AddEndpointsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENDPOINTDESCRIPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EndpointDescriptions"))
    val ENDPOINTGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EndpointGroupArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDPOINTDESCRIPTIONS_DESCRIPTOR)
        field(ENDPOINTGROUPARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENDPOINTDESCRIPTIONS_DESCRIPTOR.index -> builder.endpointDescriptions =
                    deserializer.deserializeList(ENDPOINTDESCRIPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<EndpointDescription>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEndpointDescriptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ENDPOINTGROUPARN_DESCRIPTOR.index -> builder.endpointGroupArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
