// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeEndpointGroupResponse
import aws.sdk.kotlin.services.globalaccelerator.model.EndpointGroup
import aws.sdk.kotlin.services.globalaccelerator.model.GlobalAcceleratorException
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DescribeEndpointGroupOperationDeserializer: HttpDeserialize<DescribeEndpointGroupResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeEndpointGroupResponse {
        if (!response.status.isSuccess()) {
            throwDescribeEndpointGroupError(context, response)
        }
        val builder = DescribeEndpointGroupResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeEndpointGroupOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeEndpointGroupError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GlobalAcceleratorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "EndpointGroupNotFoundException" -> EndpointGroupNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> GlobalAcceleratorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeEndpointGroupOperationBody(builder: DescribeEndpointGroupResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENDPOINTGROUP_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EndpointGroup"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDPOINTGROUP_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENDPOINTGROUP_DESCRIPTOR.index -> builder.endpointGroup = deserializeEndpointGroupDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
