// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.globalaccelerator.model.ByoipCidr
import aws.sdk.kotlin.services.globalaccelerator.model.DeprovisionByoipCidrResponse
import aws.sdk.kotlin.services.globalaccelerator.model.GlobalAcceleratorException
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class DeprovisionByoipCidrOperationDeserializer: HttpDeserialize<DeprovisionByoipCidrResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeprovisionByoipCidrResponse {
        if (!response.status.isSuccess()) {
            throwDeprovisionByoipCidrError(context, response)
        }
        val builder = DeprovisionByoipCidrResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDeprovisionByoipCidrOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDeprovisionByoipCidrError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GlobalAcceleratorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ByoipCidrNotFoundException" -> ByoipCidrNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "IncorrectCidrStateException" -> IncorrectCidrStateExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> GlobalAcceleratorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDeprovisionByoipCidrOperationBody(builder: DeprovisionByoipCidrResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BYOIPCIDR_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ByoipCidr"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BYOIPCIDR_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BYOIPCIDR_DESCRIPTOR.index -> builder.byoipCidr = deserializeByoipCidrDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
