// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model



public class UpdateEndpointGroupRequest private constructor(builder: Builder) {
    /**
     * The list of endpoint objects. A resource must be valid and active when you add it as an endpoint.
     */
    public val endpointConfigurations: List<EndpointConfiguration>? = builder.endpointConfigurations
    /**
     * The Amazon Resource Name (ARN) of the endpoint group.
     */
    public val endpointGroupArn: kotlin.String? = builder.endpointGroupArn
    /**
     * The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.
     */
    public val healthCheckIntervalSeconds: kotlin.Int? = builder.healthCheckIntervalSeconds
    /**
     * If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The default value is slash (/).
     */
    public val healthCheckPath: kotlin.String? = builder.healthCheckPath
    /**
     * The port that Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port is the listener port that this endpoint group is associated with. If the listener port is a list of ports, Global Accelerator uses the first port in the list.
     */
    public val healthCheckPort: kotlin.Int? = builder.healthCheckPort
    /**
     * The protocol that Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default value is TCP.
     */
    public val healthCheckProtocol: aws.sdk.kotlin.services.globalaccelerator.model.HealthCheckProtocol? = builder.healthCheckProtocol
    /**
     * Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. For example, you can create a port override in which the listener receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080 and 1443, respectively, on the endpoints.
     *
     * For more information, see [ Overriding listener ports](https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html) in the *Global Accelerator Developer Guide*.
     */
    public val portOverrides: List<PortOverride>? = builder.portOverrides
    /**
     * The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default value is 3.
     */
    public val thresholdCount: kotlin.Int? = builder.thresholdCount
    /**
     * The percentage of traffic to send to an Amazon Web Services Region. Additional traffic is distributed to other endpoint groups for this listener.
     *
     * Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is applied to the traffic that would otherwise have been routed to the Region based on optimal routing.
     *
     * The default value is 100.
     */
    public val trafficDialPercentage: kotlin.Float? = builder.trafficDialPercentage

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.UpdateEndpointGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateEndpointGroupRequest(")
        append("endpointConfigurations=$endpointConfigurations,")
        append("endpointGroupArn=$endpointGroupArn,")
        append("healthCheckIntervalSeconds=$healthCheckIntervalSeconds,")
        append("healthCheckPath=$healthCheckPath,")
        append("healthCheckPort=$healthCheckPort,")
        append("healthCheckProtocol=$healthCheckProtocol,")
        append("portOverrides=$portOverrides,")
        append("thresholdCount=$thresholdCount,")
        append("trafficDialPercentage=$trafficDialPercentage")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = endpointConfigurations?.hashCode() ?: 0
        result = 31 * result + (endpointGroupArn?.hashCode() ?: 0)
        result = 31 * result + (healthCheckIntervalSeconds ?: 0)
        result = 31 * result + (healthCheckPath?.hashCode() ?: 0)
        result = 31 * result + (healthCheckPort ?: 0)
        result = 31 * result + (healthCheckProtocol?.hashCode() ?: 0)
        result = 31 * result + (portOverrides?.hashCode() ?: 0)
        result = 31 * result + (thresholdCount ?: 0)
        result = 31 * result + (trafficDialPercentage?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateEndpointGroupRequest

        if (endpointConfigurations != other.endpointConfigurations) return false
        if (endpointGroupArn != other.endpointGroupArn) return false
        if (healthCheckIntervalSeconds != other.healthCheckIntervalSeconds) return false
        if (healthCheckPath != other.healthCheckPath) return false
        if (healthCheckPort != other.healthCheckPort) return false
        if (healthCheckProtocol != other.healthCheckProtocol) return false
        if (portOverrides != other.portOverrides) return false
        if (thresholdCount != other.thresholdCount) return false
        if (trafficDialPercentage != other.trafficDialPercentage) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.UpdateEndpointGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The list of endpoint objects. A resource must be valid and active when you add it as an endpoint.
         */
        public var endpointConfigurations: List<EndpointConfiguration>? = null
        /**
         * The Amazon Resource Name (ARN) of the endpoint group.
         */
        public var endpointGroupArn: kotlin.String? = null
        /**
         * The time—10 seconds or 30 seconds—between each health check for an endpoint. The default value is 30.
         */
        public var healthCheckIntervalSeconds: kotlin.Int? = null
        /**
         * If the protocol is HTTP/S, then this specifies the path that is the destination for health check targets. The default value is slash (/).
         */
        public var healthCheckPath: kotlin.String? = null
        /**
         * The port that Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default port is the listener port that this endpoint group is associated with. If the listener port is a list of ports, Global Accelerator uses the first port in the list.
         */
        public var healthCheckPort: kotlin.Int? = null
        /**
         * The protocol that Global Accelerator uses to check the health of endpoints that are part of this endpoint group. The default value is TCP.
         */
        public var healthCheckProtocol: aws.sdk.kotlin.services.globalaccelerator.model.HealthCheckProtocol? = null
        /**
         * Override specific listener ports used to route traffic to endpoints that are part of this endpoint group. For example, you can create a port override in which the listener receives user traffic on ports 80 and 443, but your accelerator routes that traffic to ports 1080 and 1443, respectively, on the endpoints.
         *
         * For more information, see [ Overriding listener ports](https://docs.aws.amazon.com/global-accelerator/latest/dg/about-endpoint-groups-port-override.html) in the *Global Accelerator Developer Guide*.
         */
        public var portOverrides: List<PortOverride>? = null
        /**
         * The number of consecutive health checks required to set the state of a healthy endpoint to unhealthy, or to set an unhealthy endpoint to healthy. The default value is 3.
         */
        public var thresholdCount: kotlin.Int? = null
        /**
         * The percentage of traffic to send to an Amazon Web Services Region. Additional traffic is distributed to other endpoint groups for this listener.
         *
         * Use this action to increase (dial up) or decrease (dial down) traffic to a specific Region. The percentage is applied to the traffic that would otherwise have been routed to the Region based on optimal routing.
         *
         * The default value is 100.
         */
        public var trafficDialPercentage: kotlin.Float? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.UpdateEndpointGroupRequest) : this() {
            this.endpointConfigurations = x.endpointConfigurations
            this.endpointGroupArn = x.endpointGroupArn
            this.healthCheckIntervalSeconds = x.healthCheckIntervalSeconds
            this.healthCheckPath = x.healthCheckPath
            this.healthCheckPort = x.healthCheckPort
            this.healthCheckProtocol = x.healthCheckProtocol
            this.portOverrides = x.portOverrides
            this.thresholdCount = x.thresholdCount
            this.trafficDialPercentage = x.trafficDialPercentage
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.UpdateEndpointGroupRequest = UpdateEndpointGroupRequest(this)
    }
}
