// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model



/**
 * Returns the ports and associated IP addresses and ports of Amazon EC2 instances in your virtual private cloud (VPC) subnets. Custom routing is a port mapping protocol in Global Accelerator that statically associates port ranges with VPC subnets, which allows Global Accelerator to route to specific instances and ports within one or more subnets.
 */
public class PortMapping private constructor(builder: Builder) {
    /**
     * The accelerator port.
     */
    public val acceleratorPort: kotlin.Int? = builder.acceleratorPort
    /**
     * The EC2 instance IP address and port number in the virtual private cloud (VPC) subnet.
     */
    public val destinationSocketAddress: aws.sdk.kotlin.services.globalaccelerator.model.SocketAddress? = builder.destinationSocketAddress
    /**
     * Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.
     */
    public val destinationTrafficState: aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingDestinationTrafficState? = builder.destinationTrafficState
    /**
     * The Amazon Resource Name (ARN) of the endpoint group.
     */
    public val endpointGroupArn: kotlin.String? = builder.endpointGroupArn
    /**
     * The IP address of the VPC subnet (the subnet ID).
     */
    public val endpointId: kotlin.String? = builder.endpointId
    /**
     * The protocols supported by the endpoint group.
     */
    public val protocols: List<CustomRoutingProtocol>? = builder.protocols

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.PortMapping = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PortMapping(")
        append("acceleratorPort=$acceleratorPort,")
        append("destinationSocketAddress=$destinationSocketAddress,")
        append("destinationTrafficState=$destinationTrafficState,")
        append("endpointGroupArn=$endpointGroupArn,")
        append("endpointId=$endpointId,")
        append("protocols=$protocols")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceleratorPort ?: 0
        result = 31 * result + (destinationSocketAddress?.hashCode() ?: 0)
        result = 31 * result + (destinationTrafficState?.hashCode() ?: 0)
        result = 31 * result + (endpointGroupArn?.hashCode() ?: 0)
        result = 31 * result + (endpointId?.hashCode() ?: 0)
        result = 31 * result + (protocols?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PortMapping

        if (acceleratorPort != other.acceleratorPort) return false
        if (destinationSocketAddress != other.destinationSocketAddress) return false
        if (destinationTrafficState != other.destinationTrafficState) return false
        if (endpointGroupArn != other.endpointGroupArn) return false
        if (endpointId != other.endpointId) return false
        if (protocols != other.protocols) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.PortMapping = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The accelerator port.
         */
        public var acceleratorPort: kotlin.Int? = null
        /**
         * The EC2 instance IP address and port number in the virtual private cloud (VPC) subnet.
         */
        public var destinationSocketAddress: aws.sdk.kotlin.services.globalaccelerator.model.SocketAddress? = null
        /**
         * Indicates whether or not a port mapping destination can receive traffic. The value is either ALLOW, if traffic is allowed to the destination, or DENY, if traffic is not allowed to the destination.
         */
        public var destinationTrafficState: aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingDestinationTrafficState? = null
        /**
         * The Amazon Resource Name (ARN) of the endpoint group.
         */
        public var endpointGroupArn: kotlin.String? = null
        /**
         * The IP address of the VPC subnet (the subnet ID).
         */
        public var endpointId: kotlin.String? = null
        /**
         * The protocols supported by the endpoint group.
         */
        public var protocols: List<CustomRoutingProtocol>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.PortMapping) : this() {
            this.acceleratorPort = x.acceleratorPort
            this.destinationSocketAddress = x.destinationSocketAddress
            this.destinationTrafficState = x.destinationTrafficState
            this.endpointGroupArn = x.endpointGroupArn
            this.endpointId = x.endpointId
            this.protocols = x.protocols
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.PortMapping = PortMapping(this)

        /**
         * construct an [aws.sdk.kotlin.services.globalaccelerator.model.SocketAddress] inside the given [block]
         */
        public fun destinationSocketAddress(block: aws.sdk.kotlin.services.globalaccelerator.model.SocketAddress.Builder.() -> kotlin.Unit) {
            this.destinationSocketAddress = aws.sdk.kotlin.services.globalaccelerator.model.SocketAddress.invoke(block)
        }
    }
}
