// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorResponse
import aws.sdk.kotlin.services.globalaccelerator.model.GlobalAcceleratorException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse


internal class DeleteCustomRoutingAcceleratorOperationDeserializer: HttpDeserialize<DeleteCustomRoutingAcceleratorResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DeleteCustomRoutingAcceleratorResponse {
        if (!response.status.isSuccess()) {
            throwDeleteCustomRoutingAcceleratorError(context, response)
        }
        val builder = DeleteCustomRoutingAcceleratorResponse.Builder()

        return builder.build()
    }
}

private suspend fun throwDeleteCustomRoutingAcceleratorError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GlobalAcceleratorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AcceleratorNotDisabledException" -> AcceleratorNotDisabledExceptionDeserializer().deserialize(context, wrappedResponse)
        "AcceleratorNotFoundException" -> AcceleratorNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "AssociatedListenerFoundException" -> AssociatedListenerFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> GlobalAcceleratorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}
