// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.globalaccelerator.model.AddCustomRoutingEndpointsResponse
import aws.sdk.kotlin.services.globalaccelerator.model.CustomRoutingEndpointDescription
import aws.sdk.kotlin.services.globalaccelerator.model.GlobalAcceleratorException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class AddCustomRoutingEndpointsOperationDeserializer: HttpDeserialize<AddCustomRoutingEndpointsResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): AddCustomRoutingEndpointsResponse {
        if (!response.status.isSuccess()) {
            throwAddCustomRoutingEndpointsError(context, response)
        }
        val builder = AddCustomRoutingEndpointsResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeAddCustomRoutingEndpointsOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwAddCustomRoutingEndpointsError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw GlobalAcceleratorException("Failed to parse response as 'awsJson1_1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedResponse)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedResponse)
        "EndpointAlreadyExistsException" -> EndpointAlreadyExistsExceptionDeserializer().deserialize(context, wrappedResponse)
        "EndpointGroupNotFoundException" -> EndpointGroupNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "InternalServiceErrorException" -> InternalServiceErrorExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidArgumentException" -> InvalidArgumentExceptionDeserializer().deserialize(context, wrappedResponse)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> GlobalAcceleratorException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeAddCustomRoutingEndpointsOperationBody(builder: AddCustomRoutingEndpointsResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ENDPOINTDESCRIPTIONS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("EndpointDescriptions"))
    val ENDPOINTGROUPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("EndpointGroupArn"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ENDPOINTDESCRIPTIONS_DESCRIPTOR)
        field(ENDPOINTGROUPARN_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ENDPOINTDESCRIPTIONS_DESCRIPTOR.index -> builder.endpointDescriptions =
                    deserializer.deserializeList(ENDPOINTDESCRIPTIONS_DESCRIPTOR) {
                        val col0 = mutableListOf<CustomRoutingEndpointDescription>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeCustomRoutingEndpointDescriptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ENDPOINTGROUPARN_DESCRIPTOR.index -> builder.endpointGroupArn = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
