// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model



/**
 * A complex type for an endpoint. Specifies information about the endpoint to remove from the endpoint group.
 */
public class EndpointIdentifier private constructor(builder: Builder) {
    /**
     * Indicates whether client IP address preservation is enabled for an endpoint. The value is true or false.
     *
     * If the value is set to true, the client's IP address is preserved in the `X-Forwarded-For` request header as traffic travels to applications on the endpoint fronted by the accelerator.
     */
    public val clientIpPreservationEnabled: kotlin.Boolean? = builder.clientIpPreservationEnabled
    /**
     * An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address allocation ID. For Amazon EC2 instances, this is the EC2 instance ID.
     *
     * An Application Load Balancer can be either internal or internet-facing.
     */
    public val endpointId: kotlin.String? = builder.endpointId

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.EndpointIdentifier = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EndpointIdentifier(")
        append("clientIpPreservationEnabled=$clientIpPreservationEnabled,")
        append("endpointId=$endpointId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = clientIpPreservationEnabled?.hashCode() ?: 0
        result = 31 * result + (endpointId?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EndpointIdentifier

        if (clientIpPreservationEnabled != other.clientIpPreservationEnabled) return false
        if (endpointId != other.endpointId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.EndpointIdentifier = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Indicates whether client IP address preservation is enabled for an endpoint. The value is true or false.
         *
         * If the value is set to true, the client's IP address is preserved in the `X-Forwarded-For` request header as traffic travels to applications on the endpoint fronted by the accelerator.
         */
        public var clientIpPreservationEnabled: kotlin.Boolean? = null
        /**
         * An ID for the endpoint. If the endpoint is a Network Load Balancer or Application Load Balancer, this is the Amazon Resource Name (ARN) of the resource. If the endpoint is an Elastic IP address, this is the Elastic IP address allocation ID. For Amazon EC2 instances, this is the EC2 instance ID.
         *
         * An Application Load Balancer can be either internal or internet-facing.
         */
        public var endpointId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.EndpointIdentifier) : this() {
            this.clientIpPreservationEnabled = x.clientIpPreservationEnabled
            this.endpointId = x.endpointId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.EndpointIdentifier = EndpointIdentifier(this)
    }
}
