// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * An accelerator is a complex type that includes one or more listeners that process inbound connections and then direct traffic to one or more endpoint groups, each of which includes endpoints, such as load balancers.
 */
public class Accelerator private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the accelerator.
     */
    public val acceleratorArn: kotlin.String? = builder.acceleratorArn
    /**
     * The date and time that the accelerator was created.
     */
    public val createdTime: aws.smithy.kotlin.runtime.time.Instant? = builder.createdTime
    /**
     * The Domain Name System (DNS) name that Global Accelerator creates that points to an accelerator's static IPv4 addresses.
     *
     * The naming convention for the DNS name for an accelerator is the following: A lowercase letter a, followed by a 16-bit random hex string, followed by .awsglobalaccelerator.com. For example: a1234567890abcdef.awsglobalaccelerator.com.
     *
     * If you have a dual-stack accelerator, you also have a second DNS name, `DualStackDnsName`, that points to both the A record and the AAAA record for all four static addresses for the accelerator: two IPv4 addresses and two IPv6 addresses.
     *
     * For more information about the default DNS name, see [ Support for DNS addressing in Global Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/dns-addressing-custom-domains.dns-addressing.html) in the *Global Accelerator Developer Guide*.
     */
    public val dnsName: kotlin.String? = builder.dnsName
    /**
     * The Domain Name System (DNS) name that Global Accelerator creates that points to a dual-stack accelerator's four static IP addresses: two IPv4 addresses and two IPv6 addresses.
     *
     * The naming convention for the dual-stack DNS name is the following: A lowercase letter a, followed by a 16-bit random hex string, followed by .dualstack.awsglobalaccelerator.com. For example: a1234567890abcdef.dualstack.awsglobalaccelerator.com.
     *
     * Note: Global Accelerator also assigns a default DNS name, `DnsName`, to your accelerator that points just to the static IPv4 addresses.
     *
     * For more information, see [ Support for DNS addressing in Global Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing) in the *Global Accelerator Developer Guide*.
     */
    public val dualStackDnsName: kotlin.String? = builder.dualStackDnsName
    /**
     * Indicates whether the accelerator is enabled. The value is true or false. The default value is true.
     *
     * If the value is set to true, the accelerator cannot be deleted. If set to false, accelerator can be deleted.
     */
    public val enabled: kotlin.Boolean? = builder.enabled
    /**
     * A history of changes that you make to an accelerator in Global Accelerator.
     */
    public val events: List<AcceleratorEvent>? = builder.events
    /**
     * The IP address type that an accelerator supports. For a standard accelerator, the value can be IPV4 or DUAL_STACK.
     */
    public val ipAddressType: aws.sdk.kotlin.services.globalaccelerator.model.IpAddressType? = builder.ipAddressType
    /**
     * The static IP addresses that Global Accelerator associates with the accelerator.
     */
    public val ipSets: List<IpSet>? = builder.ipSets
    /**
     * The date and time that the accelerator was last modified.
     */
    public val lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastModifiedTime
    /**
     * The name of the accelerator. The name must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Describes the deployment status of the accelerator.
     */
    public val status: aws.sdk.kotlin.services.globalaccelerator.model.AcceleratorStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.globalaccelerator.model.Accelerator = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Accelerator(")
        append("acceleratorArn=$acceleratorArn,")
        append("createdTime=$createdTime,")
        append("dnsName=$dnsName,")
        append("dualStackDnsName=$dualStackDnsName,")
        append("enabled=$enabled,")
        append("events=$events,")
        append("ipAddressType=$ipAddressType,")
        append("ipSets=$ipSets,")
        append("lastModifiedTime=$lastModifiedTime,")
        append("name=$name,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = acceleratorArn?.hashCode() ?: 0
        result = 31 * result + (createdTime?.hashCode() ?: 0)
        result = 31 * result + (dnsName?.hashCode() ?: 0)
        result = 31 * result + (dualStackDnsName?.hashCode() ?: 0)
        result = 31 * result + (enabled?.hashCode() ?: 0)
        result = 31 * result + (events?.hashCode() ?: 0)
        result = 31 * result + (ipAddressType?.hashCode() ?: 0)
        result = 31 * result + (ipSets?.hashCode() ?: 0)
        result = 31 * result + (lastModifiedTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Accelerator

        if (acceleratorArn != other.acceleratorArn) return false
        if (createdTime != other.createdTime) return false
        if (dnsName != other.dnsName) return false
        if (dualStackDnsName != other.dualStackDnsName) return false
        if (enabled != other.enabled) return false
        if (events != other.events) return false
        if (ipAddressType != other.ipAddressType) return false
        if (ipSets != other.ipSets) return false
        if (lastModifiedTime != other.lastModifiedTime) return false
        if (name != other.name) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.globalaccelerator.model.Accelerator = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the accelerator.
         */
        public var acceleratorArn: kotlin.String? = null
        /**
         * The date and time that the accelerator was created.
         */
        public var createdTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The Domain Name System (DNS) name that Global Accelerator creates that points to an accelerator's static IPv4 addresses.
         *
         * The naming convention for the DNS name for an accelerator is the following: A lowercase letter a, followed by a 16-bit random hex string, followed by .awsglobalaccelerator.com. For example: a1234567890abcdef.awsglobalaccelerator.com.
         *
         * If you have a dual-stack accelerator, you also have a second DNS name, `DualStackDnsName`, that points to both the A record and the AAAA record for all four static addresses for the accelerator: two IPv4 addresses and two IPv6 addresses.
         *
         * For more information about the default DNS name, see [ Support for DNS addressing in Global Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/dns-addressing-custom-domains.dns-addressing.html) in the *Global Accelerator Developer Guide*.
         */
        public var dnsName: kotlin.String? = null
        /**
         * The Domain Name System (DNS) name that Global Accelerator creates that points to a dual-stack accelerator's four static IP addresses: two IPv4 addresses and two IPv6 addresses.
         *
         * The naming convention for the dual-stack DNS name is the following: A lowercase letter a, followed by a 16-bit random hex string, followed by .dualstack.awsglobalaccelerator.com. For example: a1234567890abcdef.dualstack.awsglobalaccelerator.com.
         *
         * Note: Global Accelerator also assigns a default DNS name, `DnsName`, to your accelerator that points just to the static IPv4 addresses.
         *
         * For more information, see [ Support for DNS addressing in Global Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/about-accelerators.html#about-accelerators.dns-addressing) in the *Global Accelerator Developer Guide*.
         */
        public var dualStackDnsName: kotlin.String? = null
        /**
         * Indicates whether the accelerator is enabled. The value is true or false. The default value is true.
         *
         * If the value is set to true, the accelerator cannot be deleted. If set to false, accelerator can be deleted.
         */
        public var enabled: kotlin.Boolean? = null
        /**
         * A history of changes that you make to an accelerator in Global Accelerator.
         */
        public var events: List<AcceleratorEvent>? = null
        /**
         * The IP address type that an accelerator supports. For a standard accelerator, the value can be IPV4 or DUAL_STACK.
         */
        public var ipAddressType: aws.sdk.kotlin.services.globalaccelerator.model.IpAddressType? = null
        /**
         * The static IP addresses that Global Accelerator associates with the accelerator.
         */
        public var ipSets: List<IpSet>? = null
        /**
         * The date and time that the accelerator was last modified.
         */
        public var lastModifiedTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the accelerator. The name must contain only alphanumeric characters or hyphens (-), and must not begin or end with a hyphen.
         */
        public var name: kotlin.String? = null
        /**
         * Describes the deployment status of the accelerator.
         */
        public var status: aws.sdk.kotlin.services.globalaccelerator.model.AcceleratorStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.globalaccelerator.model.Accelerator) : this() {
            this.acceleratorArn = x.acceleratorArn
            this.createdTime = x.createdTime
            this.dnsName = x.dnsName
            this.dualStackDnsName = x.dualStackDnsName
            this.enabled = x.enabled
            this.events = x.events
            this.ipAddressType = x.ipAddressType
            this.ipSets = x.ipSets
            this.lastModifiedTime = x.lastModifiedTime
            this.name = x.name
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.globalaccelerator.model.Accelerator = Accelerator(this)
    }
}
