// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.globalaccelerator

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.runtime.protocol.json.AwsJsonProtocol
import aws.sdk.kotlin.services.globalaccelerator.endpoints.internal.ResolveEndpoint
import aws.sdk.kotlin.services.globalaccelerator.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.globalaccelerator.model.*
import aws.sdk.kotlin.services.globalaccelerator.model.AddCustomRoutingEndpointsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.AddEndpointsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.AdvertiseByoipCidrRequest
import aws.sdk.kotlin.services.globalaccelerator.model.AllowCustomRoutingTrafficRequest
import aws.sdk.kotlin.services.globalaccelerator.model.CreateAcceleratorRequest
import aws.sdk.kotlin.services.globalaccelerator.model.CreateCustomRoutingAcceleratorRequest
import aws.sdk.kotlin.services.globalaccelerator.model.CreateCustomRoutingEndpointGroupRequest
import aws.sdk.kotlin.services.globalaccelerator.model.CreateCustomRoutingListenerRequest
import aws.sdk.kotlin.services.globalaccelerator.model.CreateEndpointGroupRequest
import aws.sdk.kotlin.services.globalaccelerator.model.CreateListenerRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteAcceleratorRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteCustomRoutingAcceleratorRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteCustomRoutingEndpointGroupRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteCustomRoutingListenerRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteEndpointGroupRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DeleteListenerRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DenyCustomRoutingTrafficRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DeprovisionByoipCidrRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeAcceleratorAttributesRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeAcceleratorRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorAttributesRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeCustomRoutingAcceleratorRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeCustomRoutingEndpointGroupRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeCustomRoutingListenerRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeEndpointGroupRequest
import aws.sdk.kotlin.services.globalaccelerator.model.DescribeListenerRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListAcceleratorsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListByoipCidrsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingAcceleratorsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingEndpointGroupsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingListenersRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingPortMappingsByDestinationRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListCustomRoutingPortMappingsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListEndpointGroupsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListListenersRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.globalaccelerator.model.ProvisionByoipCidrRequest
import aws.sdk.kotlin.services.globalaccelerator.model.RemoveCustomRoutingEndpointsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.RemoveEndpointsRequest
import aws.sdk.kotlin.services.globalaccelerator.model.TagResourceRequest
import aws.sdk.kotlin.services.globalaccelerator.model.UntagResourceRequest
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateAcceleratorAttributesRequest
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateAcceleratorRequest
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorAttributesRequest
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateCustomRoutingAcceleratorRequest
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateCustomRoutingListenerRequest
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateEndpointGroupRequest
import aws.sdk.kotlin.services.globalaccelerator.model.UpdateListenerRequest
import aws.sdk.kotlin.services.globalaccelerator.model.WithdrawByoipCidrRequest
import aws.sdk.kotlin.services.globalaccelerator.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsHttpSigner
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "Global Accelerator"
public const val ServiceApiVersion: String = "2018-08-08"
public const val SdkVersion: String = "0.19.3-beta"

internal class DefaultGlobalAcceleratorClient(override val config: GlobalAcceleratorClient.Config) : GlobalAcceleratorClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Associate a virtual private cloud (VPC) subnet endpoint with your custom routing accelerator.
     *
     * The listener port range must be large enough to support the number of IP addresses that can be specified in your subnet. The number of ports required is: subnet size times the number of ports per destination EC2 instances. For example, a subnet defined as /24 requires a listener port range of at least 255 ports.
     *
     * Note: You must have enough remaining listener ports available to map to the subnet ports, or the call will fail with a LimitExceededException.
     *
     * By default, all destinations in a subnet in a custom routing accelerator cannot receive traffic. To enable all destinations to receive traffic, or to specify individual port mappings that can receive traffic, see the [ AllowCustomRoutingTraffic](https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html) operation.
     */
    override suspend fun addCustomRoutingEndpoints(input: AddCustomRoutingEndpointsRequest): AddCustomRoutingEndpointsResponse {
        val op = SdkHttpOperation.build<AddCustomRoutingEndpointsRequest, AddCustomRoutingEndpointsResponse> {
            serializer = AddCustomRoutingEndpointsOperationSerializer()
            deserializer = AddCustomRoutingEndpointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddCustomRoutingEndpoints"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AddCustomRoutingEndpointsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AddCustomRoutingEndpoints-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Add endpoints to an endpoint group. The `AddEndpoints` API operation is the recommended option for adding endpoints. The alternative options are to add endpoints when you create an endpoint group (with the [CreateEndpointGroup](https://docs.aws.amazon.com/global-accelerator/latest/api/API_CreateEndpointGroup.html) API) or when you update an endpoint group (with the [UpdateEndpointGroup](https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateEndpointGroup.html) API).
     *
     * There are two advantages to using `AddEndpoints` to add endpoints:
     * + It's faster, because Global Accelerator only has to resolve the new endpoints that you're adding.
     * + It's more convenient, because you don't need to specify all of the current endpoints that are already in the endpoint group in addition to the new endpoints that you want to add.
     */
    override suspend fun addEndpoints(input: AddEndpointsRequest): AddEndpointsResponse {
        val op = SdkHttpOperation.build<AddEndpointsRequest, AddEndpointsResponse> {
            serializer = AddEndpointsOperationSerializer()
            deserializer = AddEndpointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AddEndpoints"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AddEndpointsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AddEndpoints-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Advertises an IPv4 address range that is provisioned for use with your Amazon Web Services resources through bring your own IP addresses (BYOIP). It can take a few minutes before traffic to the specified addresses starts routing to Amazon Web Services because of propagation delays.
     *
     * To stop advertising the BYOIP address range, use [ WithdrawByoipCidr](https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html).
     *
     * For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the *Global Accelerator Developer Guide*.
     */
    override suspend fun advertiseByoipCidr(input: AdvertiseByoipCidrRequest): AdvertiseByoipCidrResponse {
        val op = SdkHttpOperation.build<AdvertiseByoipCidrRequest, AdvertiseByoipCidrResponse> {
            serializer = AdvertiseByoipCidrOperationSerializer()
            deserializer = AdvertiseByoipCidrOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AdvertiseByoipCidr"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AdvertiseByoipCidrRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AdvertiseByoipCidr-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that can receive traffic for a custom routing accelerator. You can allow traffic to all destinations in the subnet endpoint, or allow traffic to a specified list of destination IP addresses and ports in the subnet. Note that you cannot specify IP addresses or ports outside of the range that you configured for the endpoint group.
     *
     * After you make changes, you can verify that the updates are complete by checking the status of your accelerator: the status changes from IN_PROGRESS to DEPLOYED.
     */
    override suspend fun allowCustomRoutingTraffic(input: AllowCustomRoutingTrafficRequest): AllowCustomRoutingTrafficResponse {
        val op = SdkHttpOperation.build<AllowCustomRoutingTrafficRequest, AllowCustomRoutingTrafficResponse> {
            serializer = AllowCustomRoutingTrafficOperationSerializer()
            deserializer = AllowCustomRoutingTrafficOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "AllowCustomRoutingTraffic"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<AllowCustomRoutingTrafficRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("AllowCustomRoutingTraffic-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Create an accelerator. An accelerator includes one or more listeners that process inbound connections and direct traffic to one or more endpoint groups, each of which includes endpoints, such as Network Load Balancers.
     *
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for example, specify `--region us-west-2` on AWS CLI commands.
     */
    override suspend fun createAccelerator(input: CreateAcceleratorRequest): CreateAcceleratorResponse {
        val op = SdkHttpOperation.build<CreateAcceleratorRequest, CreateAcceleratorResponse> {
            serializer = CreateAcceleratorOperationSerializer()
            deserializer = CreateAcceleratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateAccelerator"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateAcceleratorRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateAccelerator-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Create a custom routing accelerator. A custom routing accelerator directs traffic to one of possibly thousands of Amazon EC2 instance destinations running in a single or multiple virtual private clouds (VPC) subnet endpoints.
     *
     * Be aware that, by default, all destination EC2 instances in a VPC subnet endpoint cannot receive traffic. To enable all destinations to receive traffic, or to specify individual port mappings that can receive traffic, see the [ AllowCustomRoutingTraffic](https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html) operation.
     *
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for example, specify `--region us-west-2` on AWS CLI commands.
     */
    override suspend fun createCustomRoutingAccelerator(input: CreateCustomRoutingAcceleratorRequest): CreateCustomRoutingAcceleratorResponse {
        val op = SdkHttpOperation.build<CreateCustomRoutingAcceleratorRequest, CreateCustomRoutingAcceleratorResponse> {
            serializer = CreateCustomRoutingAcceleratorOperationSerializer()
            deserializer = CreateCustomRoutingAcceleratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCustomRoutingAccelerator"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateCustomRoutingAcceleratorRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateCustomRoutingAccelerator-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Create an endpoint group for the specified listener for a custom routing accelerator. An endpoint group is a collection of endpoints in one Amazon Web Services Region.
     */
    override suspend fun createCustomRoutingEndpointGroup(input: CreateCustomRoutingEndpointGroupRequest): CreateCustomRoutingEndpointGroupResponse {
        val op = SdkHttpOperation.build<CreateCustomRoutingEndpointGroupRequest, CreateCustomRoutingEndpointGroupResponse> {
            serializer = CreateCustomRoutingEndpointGroupOperationSerializer()
            deserializer = CreateCustomRoutingEndpointGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCustomRoutingEndpointGroup"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateCustomRoutingEndpointGroupRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateCustomRoutingEndpointGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Create a listener to process inbound connections from clients to a custom routing accelerator. Connections arrive to assigned static IP addresses on the port range that you specify.
     */
    override suspend fun createCustomRoutingListener(input: CreateCustomRoutingListenerRequest): CreateCustomRoutingListenerResponse {
        val op = SdkHttpOperation.build<CreateCustomRoutingListenerRequest, CreateCustomRoutingListenerResponse> {
            serializer = CreateCustomRoutingListenerOperationSerializer()
            deserializer = CreateCustomRoutingListenerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateCustomRoutingListener"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateCustomRoutingListenerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateCustomRoutingListener-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Create an endpoint group for the specified listener. An endpoint group is a collection of endpoints in one Amazon Web Services Region. A resource must be valid and active when you add it as an endpoint.
     */
    override suspend fun createEndpointGroup(input: CreateEndpointGroupRequest): CreateEndpointGroupResponse {
        val op = SdkHttpOperation.build<CreateEndpointGroupRequest, CreateEndpointGroupResponse> {
            serializer = CreateEndpointGroupOperationSerializer()
            deserializer = CreateEndpointGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateEndpointGroup"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateEndpointGroupRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateEndpointGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Create a listener to process inbound connections from clients to an accelerator. Connections arrive to assigned static IP addresses on a port, port range, or list of port ranges that you specify.
     */
    override suspend fun createListener(input: CreateListenerRequest): CreateListenerResponse {
        val op = SdkHttpOperation.build<CreateListenerRequest, CreateListenerResponse> {
            serializer = CreateListenerOperationSerializer()
            deserializer = CreateListenerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateListener"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateListenerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateListener-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Delete an accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set `Enabled` to false.
     *
     * When you create an accelerator, by default, Global Accelerator provides you with a set of two static IP addresses. Alternatively, you can bring your own IP address ranges to Global Accelerator and assign IP addresses from those ranges.
     *
     * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator and it no longer accepts or routes traffic. However, when you *delete* an accelerator, you lose the static IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information, see [Identity and access management](https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html) in the *Global Accelerator Developer Guide*.
     */
    override suspend fun deleteAccelerator(input: DeleteAcceleratorRequest): DeleteAcceleratorResponse {
        val op = SdkHttpOperation.build<DeleteAcceleratorRequest, DeleteAcceleratorResponse> {
            serializer = DeleteAcceleratorOperationSerializer()
            deserializer = DeleteAcceleratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteAccelerator"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteAcceleratorRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteAccelerator-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Delete a custom routing accelerator. Before you can delete an accelerator, you must disable it and remove all dependent resources (listeners and endpoint groups). To disable the accelerator, update the accelerator to set `Enabled` to false.
     *
     * When you create a custom routing accelerator, by default, Global Accelerator provides you with a set of two static IP addresses.
     *
     * The IP addresses are assigned to your accelerator for as long as it exists, even if you disable the accelerator and it no longer accepts or routes traffic. However, when you *delete* an accelerator, you lose the static IP addresses that are assigned to the accelerator, so you can no longer route traffic by using them. As a best practice, ensure that you have permissions in place to avoid inadvertently deleting accelerators. You can use IAM policies with Global Accelerator to limit the users who have permissions to delete an accelerator. For more information, see [Identity and access management](https://docs.aws.amazon.com/global-accelerator/latest/dg/auth-and-access-control.html) in the *Global Accelerator Developer Guide*.
     */
    override suspend fun deleteCustomRoutingAccelerator(input: DeleteCustomRoutingAcceleratorRequest): DeleteCustomRoutingAcceleratorResponse {
        val op = SdkHttpOperation.build<DeleteCustomRoutingAcceleratorRequest, DeleteCustomRoutingAcceleratorResponse> {
            serializer = DeleteCustomRoutingAcceleratorOperationSerializer()
            deserializer = DeleteCustomRoutingAcceleratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCustomRoutingAccelerator"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteCustomRoutingAcceleratorRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteCustomRoutingAccelerator-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Delete an endpoint group from a listener for a custom routing accelerator.
     */
    override suspend fun deleteCustomRoutingEndpointGroup(input: DeleteCustomRoutingEndpointGroupRequest): DeleteCustomRoutingEndpointGroupResponse {
        val op = SdkHttpOperation.build<DeleteCustomRoutingEndpointGroupRequest, DeleteCustomRoutingEndpointGroupResponse> {
            serializer = DeleteCustomRoutingEndpointGroupOperationSerializer()
            deserializer = DeleteCustomRoutingEndpointGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCustomRoutingEndpointGroup"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteCustomRoutingEndpointGroupRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteCustomRoutingEndpointGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Delete a listener for a custom routing accelerator.
     */
    override suspend fun deleteCustomRoutingListener(input: DeleteCustomRoutingListenerRequest): DeleteCustomRoutingListenerResponse {
        val op = SdkHttpOperation.build<DeleteCustomRoutingListenerRequest, DeleteCustomRoutingListenerResponse> {
            serializer = DeleteCustomRoutingListenerOperationSerializer()
            deserializer = DeleteCustomRoutingListenerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteCustomRoutingListener"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteCustomRoutingListenerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteCustomRoutingListener-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Delete an endpoint group from a listener.
     */
    override suspend fun deleteEndpointGroup(input: DeleteEndpointGroupRequest): DeleteEndpointGroupResponse {
        val op = SdkHttpOperation.build<DeleteEndpointGroupRequest, DeleteEndpointGroupResponse> {
            serializer = DeleteEndpointGroupOperationSerializer()
            deserializer = DeleteEndpointGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteEndpointGroup"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteEndpointGroupRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteEndpointGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Delete a listener from an accelerator.
     */
    override suspend fun deleteListener(input: DeleteListenerRequest): DeleteListenerResponse {
        val op = SdkHttpOperation.build<DeleteListenerRequest, DeleteListenerResponse> {
            serializer = DeleteListenerOperationSerializer()
            deserializer = DeleteListenerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteListener"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteListenerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteListener-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Specify the Amazon EC2 instance (destination) IP addresses and ports for a VPC subnet endpoint that cannot receive traffic for a custom routing accelerator. You can deny traffic to all destinations in the VPC endpoint, or deny traffic to a specified list of destination IP addresses and ports. Note that you cannot specify IP addresses or ports outside of the range that you configured for the endpoint group.
     *
     * After you make changes, you can verify that the updates are complete by checking the status of your accelerator: the status changes from IN_PROGRESS to DEPLOYED.
     */
    override suspend fun denyCustomRoutingTraffic(input: DenyCustomRoutingTrafficRequest): DenyCustomRoutingTrafficResponse {
        val op = SdkHttpOperation.build<DenyCustomRoutingTrafficRequest, DenyCustomRoutingTrafficResponse> {
            serializer = DenyCustomRoutingTrafficOperationSerializer()
            deserializer = DenyCustomRoutingTrafficOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DenyCustomRoutingTraffic"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DenyCustomRoutingTrafficRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DenyCustomRoutingTraffic-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Releases the specified address range that you provisioned to use with your Amazon Web Services resources through bring your own IP addresses (BYOIP) and deletes the corresponding address pool.
     *
     * Before you can release an address range, you must stop advertising it by using [WithdrawByoipCidr](https://docs.aws.amazon.com/global-accelerator/latest/api/WithdrawByoipCidr.html) and you must not have any accelerators that are using static IP addresses allocated from its address range.
     *
     * For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the *Global Accelerator Developer Guide*.
     */
    override suspend fun deprovisionByoipCidr(input: DeprovisionByoipCidrRequest): DeprovisionByoipCidrResponse {
        val op = SdkHttpOperation.build<DeprovisionByoipCidrRequest, DeprovisionByoipCidrResponse> {
            serializer = DeprovisionByoipCidrOperationSerializer()
            deserializer = DeprovisionByoipCidrOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeprovisionByoipCidr"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeprovisionByoipCidrRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeprovisionByoipCidr-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describe an accelerator.
     */
    override suspend fun describeAccelerator(input: DescribeAcceleratorRequest): DescribeAcceleratorResponse {
        val op = SdkHttpOperation.build<DescribeAcceleratorRequest, DescribeAcceleratorResponse> {
            serializer = DescribeAcceleratorOperationSerializer()
            deserializer = DescribeAcceleratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAccelerator"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeAcceleratorRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeAccelerator-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describe the attributes of an accelerator.
     */
    override suspend fun describeAcceleratorAttributes(input: DescribeAcceleratorAttributesRequest): DescribeAcceleratorAttributesResponse {
        val op = SdkHttpOperation.build<DescribeAcceleratorAttributesRequest, DescribeAcceleratorAttributesResponse> {
            serializer = DescribeAcceleratorAttributesOperationSerializer()
            deserializer = DescribeAcceleratorAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeAcceleratorAttributes"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeAcceleratorAttributesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeAcceleratorAttributes-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describe a custom routing accelerator.
     */
    override suspend fun describeCustomRoutingAccelerator(input: DescribeCustomRoutingAcceleratorRequest): DescribeCustomRoutingAcceleratorResponse {
        val op = SdkHttpOperation.build<DescribeCustomRoutingAcceleratorRequest, DescribeCustomRoutingAcceleratorResponse> {
            serializer = DescribeCustomRoutingAcceleratorOperationSerializer()
            deserializer = DescribeCustomRoutingAcceleratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCustomRoutingAccelerator"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeCustomRoutingAcceleratorRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeCustomRoutingAccelerator-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describe the attributes of a custom routing accelerator.
     */
    override suspend fun describeCustomRoutingAcceleratorAttributes(input: DescribeCustomRoutingAcceleratorAttributesRequest): DescribeCustomRoutingAcceleratorAttributesResponse {
        val op = SdkHttpOperation.build<DescribeCustomRoutingAcceleratorAttributesRequest, DescribeCustomRoutingAcceleratorAttributesResponse> {
            serializer = DescribeCustomRoutingAcceleratorAttributesOperationSerializer()
            deserializer = DescribeCustomRoutingAcceleratorAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCustomRoutingAcceleratorAttributes"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeCustomRoutingAcceleratorAttributesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeCustomRoutingAcceleratorAttributes-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describe an endpoint group for a custom routing accelerator.
     */
    override suspend fun describeCustomRoutingEndpointGroup(input: DescribeCustomRoutingEndpointGroupRequest): DescribeCustomRoutingEndpointGroupResponse {
        val op = SdkHttpOperation.build<DescribeCustomRoutingEndpointGroupRequest, DescribeCustomRoutingEndpointGroupResponse> {
            serializer = DescribeCustomRoutingEndpointGroupOperationSerializer()
            deserializer = DescribeCustomRoutingEndpointGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCustomRoutingEndpointGroup"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeCustomRoutingEndpointGroupRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeCustomRoutingEndpointGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * The description of a listener for a custom routing accelerator.
     */
    override suspend fun describeCustomRoutingListener(input: DescribeCustomRoutingListenerRequest): DescribeCustomRoutingListenerResponse {
        val op = SdkHttpOperation.build<DescribeCustomRoutingListenerRequest, DescribeCustomRoutingListenerResponse> {
            serializer = DescribeCustomRoutingListenerOperationSerializer()
            deserializer = DescribeCustomRoutingListenerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeCustomRoutingListener"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeCustomRoutingListenerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeCustomRoutingListener-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describe an endpoint group.
     */
    override suspend fun describeEndpointGroup(input: DescribeEndpointGroupRequest): DescribeEndpointGroupResponse {
        val op = SdkHttpOperation.build<DescribeEndpointGroupRequest, DescribeEndpointGroupResponse> {
            serializer = DescribeEndpointGroupOperationSerializer()
            deserializer = DescribeEndpointGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeEndpointGroup"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeEndpointGroupRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeEndpointGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describe a listener.
     */
    override suspend fun describeListener(input: DescribeListenerRequest): DescribeListenerResponse {
        val op = SdkHttpOperation.build<DescribeListenerRequest, DescribeListenerResponse> {
            serializer = DescribeListenerOperationSerializer()
            deserializer = DescribeListenerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeListener"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeListenerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeListener-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the accelerators for an Amazon Web Services account.
     */
    override suspend fun listAccelerators(input: ListAcceleratorsRequest): ListAcceleratorsResponse {
        val op = SdkHttpOperation.build<ListAcceleratorsRequest, ListAcceleratorsResponse> {
            serializer = ListAcceleratorsOperationSerializer()
            deserializer = ListAcceleratorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListAccelerators"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListAcceleratorsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListAccelerators-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists the IP address ranges that were specified in calls to [ProvisionByoipCidr](https://docs.aws.amazon.com/global-accelerator/latest/api/ProvisionByoipCidr.html), including the current state and a history of state changes.
     */
    override suspend fun listByoipCidrs(input: ListByoipCidrsRequest): ListByoipCidrsResponse {
        val op = SdkHttpOperation.build<ListByoipCidrsRequest, ListByoipCidrsResponse> {
            serializer = ListByoipCidrsOperationSerializer()
            deserializer = ListByoipCidrsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListByoipCidrs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListByoipCidrsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListByoipCidrs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the custom routing accelerators for an Amazon Web Services account.
     */
    override suspend fun listCustomRoutingAccelerators(input: ListCustomRoutingAcceleratorsRequest): ListCustomRoutingAcceleratorsResponse {
        val op = SdkHttpOperation.build<ListCustomRoutingAcceleratorsRequest, ListCustomRoutingAcceleratorsResponse> {
            serializer = ListCustomRoutingAcceleratorsOperationSerializer()
            deserializer = ListCustomRoutingAcceleratorsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCustomRoutingAccelerators"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListCustomRoutingAcceleratorsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListCustomRoutingAccelerators-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the endpoint groups that are associated with a listener for a custom routing accelerator.
     */
    override suspend fun listCustomRoutingEndpointGroups(input: ListCustomRoutingEndpointGroupsRequest): ListCustomRoutingEndpointGroupsResponse {
        val op = SdkHttpOperation.build<ListCustomRoutingEndpointGroupsRequest, ListCustomRoutingEndpointGroupsResponse> {
            serializer = ListCustomRoutingEndpointGroupsOperationSerializer()
            deserializer = ListCustomRoutingEndpointGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCustomRoutingEndpointGroups"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListCustomRoutingEndpointGroupsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListCustomRoutingEndpointGroups-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the listeners for a custom routing accelerator.
     */
    override suspend fun listCustomRoutingListeners(input: ListCustomRoutingListenersRequest): ListCustomRoutingListenersResponse {
        val op = SdkHttpOperation.build<ListCustomRoutingListenersRequest, ListCustomRoutingListenersResponse> {
            serializer = ListCustomRoutingListenersOperationSerializer()
            deserializer = ListCustomRoutingListenersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCustomRoutingListeners"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListCustomRoutingListenersRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListCustomRoutingListeners-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provides a complete mapping from the public accelerator IP address and port to destination EC2 instance IP addresses and ports in the virtual public cloud (VPC) subnet endpoint for a custom routing accelerator. For each subnet endpoint that you add, Global Accelerator creates a new static port mapping for the accelerator. The port mappings don't change after Global Accelerator generates them, so you can retrieve and cache the full mapping on your servers.
     *
     * If you remove a subnet from your accelerator, Global Accelerator removes (reclaims) the port mappings. If you add a subnet to your accelerator, Global Accelerator creates new port mappings (the existing ones don't change). If you add or remove EC2 instances in your subnet, the port mappings don't change, because the mappings are created when you add the subnet to Global Accelerator.
     *
     * The mappings also include a flag for each destination denoting which destination IP addresses and ports are allowed or denied traffic.
     */
    override suspend fun listCustomRoutingPortMappings(input: ListCustomRoutingPortMappingsRequest): ListCustomRoutingPortMappingsResponse {
        val op = SdkHttpOperation.build<ListCustomRoutingPortMappingsRequest, ListCustomRoutingPortMappingsResponse> {
            serializer = ListCustomRoutingPortMappingsOperationSerializer()
            deserializer = ListCustomRoutingPortMappingsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCustomRoutingPortMappings"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListCustomRoutingPortMappingsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListCustomRoutingPortMappings-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the port mappings for a specific EC2 instance (destination) in a VPC subnet endpoint. The response is the mappings for one destination IP address. This is useful when your subnet endpoint has mappings that span multiple custom routing accelerators in your account, or for scenarios where you only want to list the port mappings for a specific destination instance.
     */
    override suspend fun listCustomRoutingPortMappingsByDestination(input: ListCustomRoutingPortMappingsByDestinationRequest): ListCustomRoutingPortMappingsByDestinationResponse {
        val op = SdkHttpOperation.build<ListCustomRoutingPortMappingsByDestinationRequest, ListCustomRoutingPortMappingsByDestinationResponse> {
            serializer = ListCustomRoutingPortMappingsByDestinationOperationSerializer()
            deserializer = ListCustomRoutingPortMappingsByDestinationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListCustomRoutingPortMappingsByDestination"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListCustomRoutingPortMappingsByDestinationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListCustomRoutingPortMappingsByDestination-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the endpoint groups that are associated with a listener.
     */
    override suspend fun listEndpointGroups(input: ListEndpointGroupsRequest): ListEndpointGroupsResponse {
        val op = SdkHttpOperation.build<ListEndpointGroupsRequest, ListEndpointGroupsResponse> {
            serializer = ListEndpointGroupsOperationSerializer()
            deserializer = ListEndpointGroupsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListEndpointGroups"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListEndpointGroupsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListEndpointGroups-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List the listeners for an accelerator.
     */
    override suspend fun listListeners(input: ListListenersRequest): ListListenersResponse {
        val op = SdkHttpOperation.build<ListListenersRequest, ListListenersResponse> {
            serializer = ListListenersOperationSerializer()
            deserializer = ListListenersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListListeners"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListListenersRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListListeners-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * List all tags for an accelerator.
     *
     * For more information, see [Tagging in Global Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html) in the *Global Accelerator Developer Guide*.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListTagsForResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Provisions an IP address range to use with your Amazon Web Services resources through bring your own IP addresses (BYOIP) and creates a corresponding address pool. After the address range is provisioned, it is ready to be advertised using [ AdvertiseByoipCidr](https://docs.aws.amazon.com/global-accelerator/latest/api/AdvertiseByoipCidr.html).
     *
     * For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the *Global Accelerator Developer Guide*.
     */
    override suspend fun provisionByoipCidr(input: ProvisionByoipCidrRequest): ProvisionByoipCidrResponse {
        val op = SdkHttpOperation.build<ProvisionByoipCidrRequest, ProvisionByoipCidrResponse> {
            serializer = ProvisionByoipCidrOperationSerializer()
            deserializer = ProvisionByoipCidrOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ProvisionByoipCidr"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ProvisionByoipCidrRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ProvisionByoipCidr-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Remove endpoints from a custom routing accelerator.
     */
    override suspend fun removeCustomRoutingEndpoints(input: RemoveCustomRoutingEndpointsRequest): RemoveCustomRoutingEndpointsResponse {
        val op = SdkHttpOperation.build<RemoveCustomRoutingEndpointsRequest, RemoveCustomRoutingEndpointsResponse> {
            serializer = RemoveCustomRoutingEndpointsOperationSerializer()
            deserializer = RemoveCustomRoutingEndpointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveCustomRoutingEndpoints"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<RemoveCustomRoutingEndpointsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RemoveCustomRoutingEndpoints-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Remove endpoints from an endpoint group.
     *
     * The `RemoveEndpoints` API operation is the recommended option for removing endpoints. The alternative is to remove endpoints by updating an endpoint group by using the [UpdateEndpointGroup](https://docs.aws.amazon.com/global-accelerator/latest/api/API_UpdateEndpointGroup.html) API operation. There are two advantages to using `AddEndpoints` to remove endpoints instead:
     * + It's more convenient, because you only need to specify the endpoints that you want to remove. With the `UpdateEndpointGroup` API operation, you must specify all of the endpoints in the endpoint group except the ones that you want to remove from the group.
     * + It's faster, because Global Accelerator doesn't need to resolve any endpoints. With the `UpdateEndpointGroup` API operation, Global Accelerator must resolve all of the endpoints that remain in the group.
     */
    override suspend fun removeEndpoints(input: RemoveEndpointsRequest): RemoveEndpointsResponse {
        val op = SdkHttpOperation.build<RemoveEndpointsRequest, RemoveEndpointsResponse> {
            serializer = RemoveEndpointsOperationSerializer()
            deserializer = RemoveEndpointsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RemoveEndpoints"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<RemoveEndpointsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RemoveEndpoints-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Add tags to an accelerator resource.
     *
     * For more information, see [Tagging in Global Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html) in the *Global Accelerator Developer Guide*.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<TagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Remove tags from a Global Accelerator resource. When you specify a tag key, the action removes both that key and its associated value. The operation succeeds even if you attempt to remove tags from an accelerator that was already removed.
     *
     * For more information, see [Tagging in Global Accelerator](https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html) in the *Global Accelerator Developer Guide*.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UntagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Update an accelerator.
     *
     * Global Accelerator is a global service that supports endpoints in multiple Amazon Web Services Regions but you must specify the US West (Oregon) Region to create, update, or otherwise work with accelerators. That is, for example, specify `--region us-west-2` on AWS CLI commands.
     */
    override suspend fun updateAccelerator(input: UpdateAcceleratorRequest): UpdateAcceleratorResponse {
        val op = SdkHttpOperation.build<UpdateAcceleratorRequest, UpdateAcceleratorResponse> {
            serializer = UpdateAcceleratorOperationSerializer()
            deserializer = UpdateAcceleratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAccelerator"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateAcceleratorRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateAccelerator-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Update the attributes for an accelerator.
     */
    override suspend fun updateAcceleratorAttributes(input: UpdateAcceleratorAttributesRequest): UpdateAcceleratorAttributesResponse {
        val op = SdkHttpOperation.build<UpdateAcceleratorAttributesRequest, UpdateAcceleratorAttributesResponse> {
            serializer = UpdateAcceleratorAttributesOperationSerializer()
            deserializer = UpdateAcceleratorAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateAcceleratorAttributes"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateAcceleratorAttributesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateAcceleratorAttributes-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Update a custom routing accelerator.
     */
    override suspend fun updateCustomRoutingAccelerator(input: UpdateCustomRoutingAcceleratorRequest): UpdateCustomRoutingAcceleratorResponse {
        val op = SdkHttpOperation.build<UpdateCustomRoutingAcceleratorRequest, UpdateCustomRoutingAcceleratorResponse> {
            serializer = UpdateCustomRoutingAcceleratorOperationSerializer()
            deserializer = UpdateCustomRoutingAcceleratorOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCustomRoutingAccelerator"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateCustomRoutingAcceleratorRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateCustomRoutingAccelerator-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Update the attributes for a custom routing accelerator.
     */
    override suspend fun updateCustomRoutingAcceleratorAttributes(input: UpdateCustomRoutingAcceleratorAttributesRequest): UpdateCustomRoutingAcceleratorAttributesResponse {
        val op = SdkHttpOperation.build<UpdateCustomRoutingAcceleratorAttributesRequest, UpdateCustomRoutingAcceleratorAttributesResponse> {
            serializer = UpdateCustomRoutingAcceleratorAttributesOperationSerializer()
            deserializer = UpdateCustomRoutingAcceleratorAttributesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCustomRoutingAcceleratorAttributes"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateCustomRoutingAcceleratorAttributesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateCustomRoutingAcceleratorAttributes-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Update a listener for a custom routing accelerator.
     */
    override suspend fun updateCustomRoutingListener(input: UpdateCustomRoutingListenerRequest): UpdateCustomRoutingListenerResponse {
        val op = SdkHttpOperation.build<UpdateCustomRoutingListenerRequest, UpdateCustomRoutingListenerResponse> {
            serializer = UpdateCustomRoutingListenerOperationSerializer()
            deserializer = UpdateCustomRoutingListenerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateCustomRoutingListener"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateCustomRoutingListenerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateCustomRoutingListener-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Update an endpoint group. A resource must be valid and active when you add it as an endpoint.
     */
    override suspend fun updateEndpointGroup(input: UpdateEndpointGroupRequest): UpdateEndpointGroupResponse {
        val op = SdkHttpOperation.build<UpdateEndpointGroupRequest, UpdateEndpointGroupResponse> {
            serializer = UpdateEndpointGroupOperationSerializer()
            deserializer = UpdateEndpointGroupOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateEndpointGroup"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateEndpointGroupRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateEndpointGroup-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Update a listener.
     */
    override suspend fun updateListener(input: UpdateListenerRequest): UpdateListenerResponse {
        val op = SdkHttpOperation.build<UpdateListenerRequest, UpdateListenerResponse> {
            serializer = UpdateListenerOperationSerializer()
            deserializer = UpdateListenerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateListener"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateListenerRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateListener-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Stops advertising an address range that is provisioned as an address pool. You can perform this operation at most once every 10 seconds, even if you specify different address ranges each time.
     *
     * It can take a few minutes before traffic to the specified addresses stops routing to Amazon Web Services because of propagation delays.
     *
     * For more information, see [Bring your own IP addresses (BYOIP)](https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html) in the *Global Accelerator Developer Guide*.
     */
    override suspend fun withdrawByoipCidr(input: WithdrawByoipCidrRequest): WithdrawByoipCidrResponse {
        val op = SdkHttpOperation.build<WithdrawByoipCidrRequest, WithdrawByoipCidrResponse> {
            serializer = WithdrawByoipCidrOperationSerializer()
            deserializer = WithdrawByoipCidrOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "WithdrawByoipCidr"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<WithdrawByoipCidrRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(AwsJsonProtocol("GlobalAccelerator_V20180706", "1.1"))
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "globalaccelerator"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("WithdrawByoipCidr-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "globalaccelerator")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
